"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processorsFormatter = exports.migrateSyntheticsPackagePolicyToV8120 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateSyntheticsPackagePolicyToV8120 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'synthetics' || !packagePolicyDoc.attributes.is_managed) {
    return packagePolicyDoc;
  }
  const updatedAttributes = packagePolicyDoc.attributes;
  const namespace = packagePolicyDoc.namespace;
  const enabledInput = updatedAttributes.inputs.find(input => input.enabled === true);
  const enabledStream = enabledInput === null || enabledInput === void 0 ? void 0 : enabledInput.streams.find(stream => {
    return ['browser', 'http', 'icmp', 'tcp'].includes(stream.data_stream.dataset);
  });
  if (!enabledStream) {
    return {
      attributes: updatedAttributes
    };
  }
  if (enabledStream.vars) {
    const processors = processorsFormatter(enabledStream.vars.processors.value, namespace);
    enabledStream.vars.processors = {
      value: processors,
      type: 'yaml'
    };
    enabledStream.compiled_stream.processors = processors;
  }
  return {
    attributes: updatedAttributes
  };
};
exports.migrateSyntheticsPackagePolicyToV8120 = migrateSyntheticsPackagePolicyToV8120;
const processorsFormatter = (processorsStr, namespace) => {
  try {
    const processors = JSON.parse(processorsStr);
    processors[0].add_fields.fields.meta = {
      space_id: namespace
    };
    return JSON.stringify(processors);
  } catch (e) {
    return processorsStr;
  }
};
exports.processorsFormatter = processorsFormatter;