"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePackagePolicyPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _hooks = require("../../../hooks");
var _single_page_layout = require("./single_page_layout");
var _multi_page_layout = require("./multi_page_layout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreatePackagePolicyPage = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    params
  } = (0, _reactRouterDom.useRouteMatch)();
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const useMultiPageLayout = (0, _react.useMemo)(() => queryParams.has('useMultiPageLayout'), [queryParams]);
  const queryParamsPolicyId = (0, _react.useMemo)(() => {
    var _queryParams$get;
    return (_queryParams$get = queryParams.get('policyId')) !== null && _queryParams$get !== void 0 ? _queryParams$get : undefined;
  }, [queryParams]);
  const [prerelease, setPrerelease] = _react.default.useState(false);
  const {
    data: settings
  } = (0, _hooks.useGetSettings)();
  (0, _react.useEffect)(() => {
    const isEnabled = Boolean(settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled);
    if (settings !== null && settings !== void 0 && settings.item) {
      setPrerelease(isEnabled);
    }
  }, [settings === null || settings === void 0 ? void 0 : settings.item]);

  /**
   * Please note: policyId can come from one of two sources. The URL param (in the URL path) or
   * in the query params (?policyId=foo).
   *
   * Either way, we take this as an indication that a user is "coming from" the fleet policy UI
   * since we link them out to packages (a.k.a. integrations) UI when choosing a new package. It is
   * no longer possible to choose a package directly in the create package form.
   *
   * We may want to deprecate the ability to pass in policyId from URL params since there is no package
   * creation possible if a user has not chosen one from the packages UI.
   */
  const from = 'policyId' in params || queryParamsPolicyId ? 'policy' : 'package';
  const pageParams = {
    from,
    queryParamsPolicyId,
    prerelease
  };
  if (useMultiPageLayout) {
    return /*#__PURE__*/_react.default.createElement(_multi_page_layout.CreatePackagePolicyMultiPage, pageParams);
  }
  return /*#__PURE__*/_react.default.createElement(_single_page_layout.CreatePackagePolicySinglePage, pageParams);
};
exports.CreatePackagePolicyPage = CreatePackagePolicyPage;