"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineEditableTableLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateEmptyItem = columns => {
  const emptyItem = columns.reduce((acc, column) => ({
    ...acc,
    [column.field]: ''
  }), {});
  return emptyItem;
};
const getUnsavedItemId = () => null;
const doesIdMatchUnsavedId = idToCheck => idToCheck === getUnsavedItemId();
const InlineEditableTableLogic = exports.InlineEditableTableLogic = (0, _kea.kea)({
  path: key => ['enterprise_search', 'inline_editable_table_logic', key],
  key: props => props.instanceId,
  actions: () => ({
    deleteItem: item => ({
      item
    }),
    doneEditing: true,
    editNewItem: true,
    editExistingItem: item => ({
      item
    }),
    reorderItems: (items, oldItems) => ({
      items,
      oldItems
    }),
    saveExistingItem: true,
    saveNewItem: true,
    setEditingItemValue: newValue => ({
      item: newValue
    }),
    setFieldErrors: fieldErrors => ({
      fieldErrors
    }),
    setRowErrors: rowErrors => ({
      rowErrors
    })
  }),
  reducers: ({
    props: {
      columns,
      defaultItem
    }
  }) => ({
    editingItemValue: [null, {
      doneEditing: () => null,
      editNewItem: () => defaultItem ? {
        ...generateEmptyItem(columns),
        ...defaultItem
      } : generateEmptyItem(columns),
      editExistingItem: (_, {
        item
      }) => item,
      setEditingItemValue: (_, {
        item
      }) => item
    }],
    fieldErrors: [{}, {
      doneEditing: () => ({}),
      setEditingItemValue: () => ({}),
      setFieldErrors: (_, {
        fieldErrors
      }) => fieldErrors
    }],
    rowErrors: [[], {
      doneEditing: () => [],
      setEditingItemValue: () => [],
      setRowErrors: (_, {
        rowErrors
      }) => rowErrors
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    editingItemId: [() => [selectors.editingItemValue], editingItemValue => {
      var _editingItemValue$id;
      return (_editingItemValue$id = editingItemValue === null || editingItemValue === void 0 ? void 0 : editingItemValue.id) !== null && _editingItemValue$id !== void 0 ? _editingItemValue$id : null;
    }],
    isEditing: [() => [selectors.editingItemValue], editingItemValue => !!editingItemValue],
    isEditingUnsavedItem: [() => [selectors.isEditing, selectors.editingItemId], (isEditing, editingItemId) => {
      return isEditing && doesIdMatchUnsavedId(editingItemId);
    }],
    doesEditingItemValueContainEmptyProperty: [() => [selectors.editingItemValue], editingItemValue => {
      return Object.values(editingItemValue || {}).findIndex(value => typeof value === 'string' && value.length === 0) > -1;
    }]
  }),
  listeners: ({
    values,
    actions,
    props: {
      onAdd,
      onDelete,
      onReorder,
      onUpdate,
      transformItem,
      validateItem
    }
  }) => ({
    saveNewItem: () => {
      if (!values.editingItemValue) return;
      const itemToSave = transformItem ? transformItem(values.editingItemValue) : values.editingItemValue;
      const errors = typeof validateItem === 'undefined' ? {} : validateItem(itemToSave);
      if (Object.keys(errors).length) {
        actions.setFieldErrors(errors);
      } else {
        onAdd(itemToSave, actions.doneEditing);
      }
    },
    deleteItem: ({
      item: itemToDelete
    }) => {
      onDelete(itemToDelete, actions.doneEditing);
    },
    reorderItems: ({
      items,
      oldItems
    }) => {
      if (onReorder) onReorder(items, oldItems, actions.doneEditing);
    },
    saveExistingItem: () => {
      if (!values.editingItemValue) return;
      const itemToSave = values.editingItemValue;
      const errors = typeof validateItem === 'undefined' ? {} : validateItem(itemToSave);
      if (Object.keys(errors).length) {
        actions.setFieldErrors(errors);
      } else {
        onUpdate(itemToSave, actions.doneEditing);
      }
    }
  })
});