"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultHeaderItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
require("./result_header_item.scss");
var _eui_components = require("../../../shared/react_router_helpers/eui_components");
var _truncate = require("../../../shared/truncate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_CHARACTER_LENGTH = 30;
const ResultHeaderItem = ({
  field,
  type,
  value,
  href
}) => {
  let formattedValue = '-';
  if (typeof value === 'string') {
    formattedValue = value;
  } else if (typeof value === 'number') {
    if (type === 'clicks') {
      formattedValue = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.result.clicks', {
        defaultMessage: '{clicks} Clicks',
        values: {
          clicks: value
        },
        description: 'This is click count for Adaptive Relevance suggestion results'
      });
    } else {
      formattedValue = parseFloat(value.toFixed(2)).toString();
    }
  }
  const HeaderItemContent = () => /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
    content: formattedValue,
    length: MAX_CHARACTER_LENGTH,
    tooltipType: "title",
    beginning: type === 'id'
  });
  return /*#__PURE__*/_react.default.createElement("span", {
    className: `appSearchResultHeaderItem ${type === 'score' && 'appSearchResultHeaderItem__score'}`
  }, type !== 'clicks' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
    content: `${field}:`,
    length: MAX_CHARACTER_LENGTH,
    tooltipType: "title"
  }), "\xA0"), href ? /*#__PURE__*/_react.default.createElement(_eui_components.EuiLinkTo, {
    to: href
  }, /*#__PURE__*/_react.default.createElement(HeaderItemContent, null)) : /*#__PURE__*/_react.default.createElement(HeaderItemContent, null));
};
exports.ResultHeaderItem = ResultHeaderItem;