"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowCreationModes = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShowCreationModes = () => {
  const {
    closeDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: _constants2.FLYOUT_ARIA_LABEL_ID
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showCreationModes.title', {
    defaultMessage: 'Add new documents'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_.DocumentCreationButtons, {
    isFlyout: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeDocumentCreation
  }, _constants.CANCEL_BUTTON_LABEL)));
};
exports.ShowCreationModes = ShowCreationModes;