"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToAlertsPageWithFilters = void 0;
var _rison = require("@kbn/rison");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("./constants");
var _format_page_filter_search_param = require("./format_page_filter_search_param");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToAlertsPageWithFilters = () => {
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigation)();
  return (filterItems,
  /**
   * If true, the alerts page will be opened in a new tab
   */
  openInNewTab = false, timerange) => {
    const urlFilterParams = (0, _rison.encode)((0, _format_page_filter_search_param.formatPageFilterSearchParam)(Array.isArray(filterItems) ? filterItems : [filterItems]));
    const timerangePath = timerange ? `&timerange=${timerange}` : '';
    navigateTo({
      deepLinkId: _securitySolutionNavigation.SecurityPageName.alerts,
      path: `?${_constants.URL_PARAM_KEY.pageFilter}=${urlFilterParams}${timerangePath}`,
      openInNewTab
    });
  };
};
exports.useNavigateToAlertsPageWithFilters = useNavigateToAlertsPageWithFilters;