"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUsageMetricsRoute = void 0;
var _rest_types = require("../../../common/rest_types");
var _common = require("../../../common");
var _usage_metrics_handler = require("./usage_metrics_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUsageMetricsRoute = (router, dataUsageContext) => {
  router.versioned.post({
    access: 'internal',
    path: _common.DATA_USAGE_METRICS_API_ROUTE
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _rest_types.UsageMetricsRequestSchema
      },
      response: {
        200: _rest_types.UsageMetricsResponseSchema
      }
    }
  }, (0, _usage_metrics_handler.getUsageMetricsHandler)(dataUsageContext));
};
exports.registerUsageMetricsRoute = registerUsageMetricsRoute;