"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkTargetTypesMappings = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _compare_mappings = require("../core/compare_mappings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

/** @internal */

/** @internal */

/** @internal */

const checkTargetTypesMappings = ({
  indexTypes,
  indexMappings,
  appMappings,
  latestMappingsVersions,
  hashToVersionMap = {}
}) => async () => {
  var _indexMappings$_meta, _indexMappings$_meta2;
  if (!(indexMappings !== null && indexMappings !== void 0 && (_indexMappings$_meta = indexMappings._meta) !== null && _indexMappings$_meta !== void 0 && _indexMappings$_meta.migrationMappingPropertyHashes) && !(indexMappings !== null && indexMappings !== void 0 && (_indexMappings$_meta2 = indexMappings._meta) !== null && _indexMappings$_meta2 !== void 0 && _indexMappings$_meta2.mappingVersions) || indexMappings.dynamic !== appMappings.dynamic) {
    return Either.left({
      type: 'index_mappings_incomplete'
    });
  }
  const {
    newTypes,
    updatedTypes
  } = (0, _compare_mappings.getNewAndUpdatedTypes)({
    indexTypes,
    indexMeta: indexMappings === null || indexMappings === void 0 ? void 0 : indexMappings._meta,
    latestMappingsVersions,
    hashToVersionMap
  });
  if (updatedTypes.length) {
    return Either.left({
      type: 'types_changed',
      updatedTypes
    });
  } else if (newTypes.length) {
    return Either.left({
      type: 'types_added',
      newTypes
    });
  } else {
    return Either.right({
      type: 'types_match'
    });
  }
};
exports.checkTargetTypesMappings = checkTargetTypesMappings;