"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementNotSelected = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getCloseButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expressionElementNotSelected.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  getSelectDescription: () => _i18n.i18n.translate('xpack.canvas.expressionElementNotSelected.selectDescription', {
    defaultMessage: 'Select an element to show expression input'
  })
};
const ElementNotSelected = ({
  done
}) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", null, strings.getSelectDescription()), done && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  size: "s",
  onClick: done
}, ' ', strings.getCloseButtonLabel()));
exports.ElementNotSelected = ElementNotSelected;
ElementNotSelected.propTypes = {
  done: _propTypes.default.func
};