"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileServiceTemplate = MobileServiceTemplate;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _apm_service_context = require("../../../../context/apm_service/apm_service_context");
var _use_breadcrumb = require("../../../../context/breadcrumbs/use_breadcrumb");
var _service_anomaly_timeseries_context = require("../../../../context/service_anomaly_timeseries/service_anomaly_timeseries_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_time_range = require("../../../../hooks/use_time_range");
var _get_alerting_capabilities = require("../../../alerting/utils/get_alerting_capabilities");
var _search_bar = require("../../../app/mobile/search_bar");
var _service_icons = require("../../../shared/service_icons");
var _technical_preview_badge = require("../../../shared/technical_preview_badge");
var _apm_main_template = require("../apm_main_template");
var _analyze_data_button = require("../apm_service_template/analyze_data_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MobileServiceTemplate(props) {
  return /*#__PURE__*/_react.default.createElement(_apm_service_context.ApmServiceContextProvider, null, /*#__PURE__*/_react.default.createElement(TemplateWithContext, props));
}
function TemplateWithContext({
  title,
  children,
  selectedTabKey,
  searchBarOptions
}) {
  const {
    path: {
      serviceName
    },
    query,
    query: {
      rangeFrom,
      rangeTo,
      environment
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/*');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const router = (0, _use_apm_router.useApmRouter)();
  const tabs = useTabs({
    selectedTabKey
  });
  const selectedTab = tabs === null || tabs === void 0 ? void 0 : tabs.find(({
    isSelected
  }) => isSelected);
  const servicesLink = router.link('/services', {
    query: {
      ...query
    }
  });
  (0, _use_breadcrumb.useBreadcrumb)(() => [{
    title: _i18n.i18n.translate('xpack.apm.mobileServices.breadcrumb.title', {
      defaultMessage: 'Services'
    }),
    href: servicesLink
  }, ...(selectedTab ? [{
    title: serviceName,
    href: router.link('/mobile-services/{serviceName}', {
      path: {
        serviceName
      },
      query
    })
  }, {
    title: selectedTab.label,
    href: selectedTab.href
  }] : [])], [query, router, selectedTab, serviceName, servicesLink], {
    omitRootOnServerless: true
  });
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    pageHeader: {
      tabs,
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "l"
      }, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": "apmMainTemplateHeaderServiceName"
      }, serviceName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_service_icons.ServiceIcons, {
        serviceName: serviceName,
        environment: environment,
        start: start,
        end: end
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_analyze_data_button.AnalyzeDataButton, null)))
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.MobileSearchBar, searchBarOptions), /*#__PURE__*/_react.default.createElement(_service_anomaly_timeseries_context.ServiceAnomalyTimeseriesContextProvider, null, children));
}
function useTabs({
  selectedTabKey
}) {
  const {
    core,
    plugins
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    capabilities
  } = core.application;
  const {
    isAlertingAvailable,
    canReadAlerts
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(plugins, capabilities);
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    path: {
      serviceName
    },
    query: queryFromUrl
  } = (0, _use_apm_params.useApmParams)(`/mobile-services/{serviceName}/${selectedTabKey}`);
  const query = (0, _lodash.omit)(queryFromUrl, 'page', 'pageSize', 'sortField', 'sortDirection');
  const tabs = [{
    key: 'overview',
    href: router.link('/mobile-services/{serviceName}/overview', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.overviewTabLabel', {
      defaultMessage: 'Overview'
    })
  }, {
    key: 'transactions',
    href: router.link('/mobile-services/{serviceName}/transactions', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.transactionsTabLabel', {
      defaultMessage: 'Transactions'
    })
  }, {
    key: 'dependencies',
    href: router.link('/mobile-services/{serviceName}/dependencies', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.dependenciesTabLabel', {
      defaultMessage: 'Dependencies'
    })
  }, {
    key: 'errors-and-crashes',
    href: router.link('/mobile-services/{serviceName}/errors-and-crashes', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.mobileErrorsTabLabel', {
      defaultMessage: 'Errors & Crashes'
    })
  }, {
    key: 'service-map',
    href: router.link('/mobile-services/{serviceName}/service-map', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.serviceMapTabLabel', {
      defaultMessage: 'Service Map'
    })
  }, {
    key: 'alerts',
    href: router.link('/mobile-services/{serviceName}/alerts', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.alertsTabLabel', {
      defaultMessage: 'Alerts'
    }),
    hidden: !(isAlertingAvailable && canReadAlerts)
  }, {
    key: 'dashboards',
    href: router.link('/mobile-services/{serviceName}/dashboards', {
      path: {
        serviceName
      },
      query
    }),
    append: /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker"
    }),
    label: _i18n.i18n.translate('xpack.apm.mobileServiceDetails.dashboardsTabLabel', {
      defaultMessage: 'Dashboards'
    })
  }];
  return tabs.filter(t => !t.hidden).map(({
    href,
    key,
    label,
    append
  }) => ({
    href,
    label,
    append,
    isSelected: key === selectedTabKey,
    'data-test-subj': `${key}Tab`
  }));
}