"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRUMSettings = getRUMSettings;
exports.isRUMFormValid = isRUMFormValid;
var t = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/lib/Either");
var _i18n = require("@kbn/i18n");
var _utils = require("../settings_form/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const arrayRegex = new RegExp(/[\[\]]/);
function getAllowedOriginsRt() {
  return new t.Type('allowedOriginsRt', t.string.is, (input, context) => {
    return _Either.either.chain(t.string.validate(input, context), inputAsString => {
      return arrayRegex.test(inputAsString) ? t.failure(input, context, _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.allowedHeadersValidation', {
        defaultMessage: 'Square brackets not allowed'
      })) : t.success(inputAsString);
    });
  }, t.identity);
}
const ENABLE_RUM_KEY = 'enable_rum';
function getRUMSettings() {
  return [{
    key: ENABLE_RUM_KEY,
    type: 'boolean',
    rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.enableRumTitle', {
      defaultMessage: 'Enable RUM'
    }),
    rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.enableRumDescription', {
      defaultMessage: 'Enable Real User Monitoring (RUM)'
    }),
    settings: [{
      key: 'rum_allow_origins',
      type: 'combo',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumAllowOriginsLabel', {
        defaultMessage: 'Allowed Origins'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      helpText: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumAllowOriginsHelpText', {
        defaultMessage: 'Allowed Origin headers to be sent by User Agents.'
      }),
      validation: getAllowedOriginsRt()
    }, {
      key: 'rum_allow_headers',
      type: 'combo',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumAllowHeaderLabel', {
        defaultMessage: 'Access-Control-Allow-Headers'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      helpText: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumAllowHeaderHelpText', {
        defaultMessage: 'Supported Access-Control-Allow-Headers in addition to "Content-Type", "Content-Encoding" and "Accept".'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumAllowHeaderTitle', {
        defaultMessage: 'Custom headers'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumAllowHeaderDescription', {
        defaultMessage: 'Configure authentication for the agent'
      })
    }, {
      key: 'rum_response_headers',
      type: 'area',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumResponseHeadersLabel', {
        defaultMessage: 'Custom HTTP response headers'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      helpText: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumResponseHeadersHelpText', {
        defaultMessage: 'Added to RUM responses, e.g. for security policy compliance.'
      })
    }, {
      type: 'advanced_setting',
      settings: [{
        key: 'rum_library_pattern',
        type: 'text',
        label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumLibraryPatternLabel', {
          defaultMessage: 'Library Frame Pattern'
        }),
        labelAppend: _utils.OPTIONAL_LABEL,
        helpText: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumLibraryPatternHelpText', {
          defaultMessage: "Identify library frames by matching a stacktrace frame's file_name and abs_path against this regexp."
        })
      }, {
        key: 'rum_exclude_from_grouping',
        type: 'text',
        label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumExcludeFromGroupingLabel', {
          defaultMessage: 'Exclude from grouping'
        }),
        labelAppend: _utils.OPTIONAL_LABEL,
        helpText: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.rumExcludeFromGroupingHelpText', {
          defaultMessage: "Exclude stacktrace frames from error group calculations by matching a stacktrace frame's `file_name` against this regexp."
        })
      }]
    }]
  }];
}
function isRUMFormValid(newVars, rumSettings) {
  // only validates RUM when its flag is enabled
  return !newVars[ENABLE_RUM_KEY].value || (0, _utils.isSettingsFormValid)(rumSettings, newVars);
}