"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsnoozeRule = unsnoozeRule;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _apmUtils = require("@kbn/apm-utils");
var _saved_objects = require("../../../../saved_objects");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _lib = require("../../../../rules_client/lib");
var _authorization = require("../../../../authorization");
var _retry_if_conflicts = require("../../../../lib/retry_if_conflicts");
var _common = require("../../../../rules_client/common");
var _rule = require("../../../../data/rule");
var _update_meta_attributes = require("../../../../rules_client/lib/update_meta_attributes");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function unsnoozeRule(context, {
  id,
  scheduleIds
}) {
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `rulesClient.unsnooze('${id}')`, async () => await unsnoozeWithOCC(context, {
    id,
    scheduleIds
  }));
}
async function unsnoozeWithOCC(context, {
  id,
  scheduleIds
}) {
  var _context$auditLogger2;
  try {
    _schemas.unsnoozeRuleParamsSchema.validate({
      id,
      scheduleIds
    });
  } catch (error) {
    throw _boom.default.badRequest(`Error validating unsnooze params - ${error.message}`);
  }
  const {
    attributes,
    version
  } = await (0, _apmUtils.withSpan)({
    name: 'getRuleSavedObject',
    type: 'rules'
  }, () => (0, _lib.getRuleSavedObject)(context, {
    ruleId: id
  }));
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: attributes.alertTypeId,
      consumer: attributes.consumer,
      operation: _authorization.WriteOperations.Unsnooze,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
    if (attributes.actions.length) {
      await context.actionsAuthorization.ensureAuthorized({
        operation: 'execute'
      });
    }
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.UNSNOOZE,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id,
        name: attributes.name
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.UNSNOOZE,
    outcome: 'unknown',
    savedObject: {
      type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
      id,
      name: attributes.name
    }
  }));
  context.ruleTypeRegistry.ensureRuleTypeEnabled(attributes.alertTypeId);
  const newAttrs = (0, _common.getUnsnoozeAttributes)(attributes, scheduleIds);
  await (0, _rule.updateRuleSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    savedObjectsUpdateOptions: {
      version
    },
    id,
    updateRuleAttributes: (0, _update_meta_attributes.updateMetaAttributes)(context, {
      ...newAttrs,
      updatedBy: await context.getUserName(),
      updatedAt: new Date().toISOString()
    })
  });
}