"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSorting = exports.DataGridSortedContext = void 0;
var _react = require("react");
var _services = require("../../../services");
var _data_grid_schema = require("./data_grid_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var DataGridSortedContext = exports.DataGridSortedContext = /*#__PURE__*/(0, _react.createContext)({
  sortedRowMap: [],
  getCorrectRowIndex: function getCorrectRowIndex(number) {
    return number;
  }
});
var useSorting = exports.useSorting = function useSorting(_ref) {
  var sorting = _ref.sorting,
    inMemory = _ref.inMemory,
    inMemoryValues = _ref.inMemoryValues,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    startRow = _ref.startRow;
  var sortingColumns = (0, _services.useDeepEqual)(sorting === null || sorting === void 0 ? void 0 : sorting.columns);
  var sortedWrappedValues = (0, _react.useMemo)(function () {
    if ((inMemory === null || inMemory === void 0 ? void 0 : inMemory.level) === 'sorting' && sortingColumns != null && sortingColumns.length > 0) {
      var inMemoryRowIndices = Object.keys(inMemoryValues);
      return inMemoryRowIndices.map(function (row, index) {
        return {
          index: index,
          values: inMemoryValues[row]
        };
      }).sort(function (a, b) {
        for (var i = 0; i < sortingColumns.length; i++) {
          var column = sortingColumns[i];
          var aValue = a.values[column.id];
          var bValue = b.values[column.id];

          // get the comparator, based on schema
          var comparator = _data_grid_schema.defaultComparator;
          if (schema.hasOwnProperty(column.id)) {
            var columnType = schema[column.id].columnType;
            for (var _i = 0; _i < schemaDetectors.length; _i++) {
              var detector = schemaDetectors[_i];
              if (detector.type === columnType && detector.hasOwnProperty('comparator')) {
                comparator = detector.comparator;
              }
            }
          }
          var result = comparator(aValue, bValue, column.direction, {
            aIndex: a.index,
            bIndex: b.index
          });
          // only return if the columns are unequal, otherwise allow the next sort-by column to run
          if (result !== 0) return result;
        }
        return 0;
      });
    }
  }, [inMemory === null || inMemory === void 0 ? void 0 : inMemory.level, inMemoryValues, sortingColumns, schema, schemaDetectors]);
  var sortedRowMap = (0, _react.useMemo)(function () {
    if ((inMemory === null || inMemory === void 0 ? void 0 : inMemory.level) === 'sorting' && sortingColumns != null && sortingColumns.length > 0 && sortedWrappedValues != null) {
      return sortedWrappedValues.map(function (row) {
        return row.index;
      });
    } else {
      return [];
    }
  }, [inMemory === null || inMemory === void 0 ? void 0 : inMemory.level, sortingColumns, sortedWrappedValues]);

  // Given a visible row index, obtain the unpaginated & unsorted
  // row index from the passed cell data
  var getCorrectRowIndex = (0, _react.useCallback)(function (visibleRowIndex) {
    var isPaginated = visibleRowIndex - startRow < 0;
    var unpaginatedRowIndex = isPaginated ? visibleRowIndex + startRow : visibleRowIndex;
    var unsortedRowIndex = unpaginatedRowIndex in sortedRowMap ? sortedRowMap[unpaginatedRowIndex] : unpaginatedRowIndex;
    return unsortedRowIndex;
  }, [startRow, sortedRowMap]);
  return (0, _react.useMemo)(function () {
    return {
      sortedRowMap: sortedRowMap,
      getCorrectRowIndex: getCorrectRowIndex
    };
  }, [sortedRowMap, getCorrectRowIndex]);
};