/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal.elements;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTable;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTableCell;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTwipsMeasure;

public class StylableHeaderFooter
extends StylableTable
implements IMasterPageHeaderFooter {
    private final StylableDocument ownerDocument;
    private final boolean header;
    private StylableTableCell tableCell;
    private boolean flushed;
    private final Float y;
    private Float totalHeight;

    public StylableHeaderFooter(StylableDocument ownerDocument, STTwipsMeasure dxaY, boolean header) {
        super(ownerDocument, null, 1);
        this.ownerDocument = ownerDocument;
        this.header = header;
        this.tableCell = ownerDocument.createTableCell(this);
        this.tableCell.setBorder(0);
        this.y = dxaY != null ? Float.valueOf(DxaUtil.dxa2points((STTwipsMeasure)dxaY)) : null;
        this.totalHeight = null;
    }

    public StylableTableCell getTableCell() {
        return this.tableCell;
    }

    private void setWidthIfNecessary() {
        float headerFooterWidth = this.ownerDocument.right() - this.ownerDocument.left();
        if (this.getTotalWidth() != headerFooterWidth) {
            this.setTotalWidth(headerFooterWidth);
        }
    }

    public float getTotalHeight() {
        if (this.totalHeight == null) {
            this.totalHeight = Float.valueOf(this.computeTotalHeight());
        }
        return this.totalHeight.floatValue();
    }

    private float computeTotalHeight() {
        this.setWidthIfNecessary();
        float height = super.getRowHeight(0);
        if (this.y != null) {
            return height + this.y.floatValue();
        }
        return height;
    }

    public void flush() {
        if (this.flushed) {
            return;
        }
        super.addCell((PdfPCell)this.tableCell);
        this.flushed = true;
    }

    public float writeSelectedRows(int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas) {
        this.setWidthIfNecessary();
        return super.writeSelectedRows(rowStart, rowEnd, xPos, yPos, canvas);
    }

    public Float getY() {
        return this.y;
    }
}

