/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.epub;

import org.apache.tika.metadata.Epub;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xml.DcXMLParser;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.utils.StringUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OPFParser
extends DcXMLParser {
    protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        metadata.set(Epub.RENDITION_LAYOUT, "reflowable");
        return new TeeContentHandler(new ContentHandler[]{super.getContentHandler(handler, metadata, context), new OPFHandler(metadata)});
    }

    private static class OPFHandler
    extends DefaultHandler {
        private final Metadata metadata;
        boolean inRenditionLayout = false;
        StringBuilder sb = new StringBuilder();

        public OPFHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String v;
            if ("itemref".equals(localName)) {
                String val = XMLReaderUtils.getAttrValue((String)"properties", (Attributes)attributes);
                if (val != null && val.contains("rendition:layout-pre-paginated")) {
                    this.metadata.set(Epub.RENDITION_LAYOUT, "pre-paginated");
                }
            } else if ("meta".equals(localName)) {
                String prop = XMLReaderUtils.getAttrValue((String)"property", (Attributes)attributes);
                if ("rendition:layout".equals(prop)) {
                    this.inRenditionLayout = true;
                }
            } else if ("package".equals(localName) && !StringUtils.isBlank((String)(v = XMLReaderUtils.getAttrValue((String)"version", (Attributes)attributes)))) {
                this.metadata.set(Epub.VERSION, v);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inRenditionLayout && "meta".equals(localName)) {
                String layout = this.sb.toString();
                if ("pre-paginated".equals(layout)) {
                    this.metadata.set(Epub.RENDITION_LAYOUT, "pre-paginated");
                }
                this.inRenditionLayout = false;
                this.sb.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inRenditionLayout) {
                this.sb.append(ch, start, length);
            }
        }
    }
}

