# frozen_string_literal: true
class Views::SharedTogo::HomeHeader < ::Views::Base
  def content
    div(:class => 'euiHeader euiHeader--fixed') do
      div(:class => 'euiHeaderSection euiHeaderSection--dontGrow euiHeaderSection--left') do
        div(:class => 'euiHeaderSectionItem') do
          span(:style => 'padding: 16px;') do
            image_tag('shared/products/icon-elastic.svg', :class => 'euiIcon euiIcon--large', :alt => '', :role => 'presentation', :'data-test-subj' => 'HomeHeaderLogo')
          end
        end
        div(:class => 'euiHeaderSectionItem') do
          h4(:class => 'euiTitle euiTitle--xsmall', :'data-test-subj' => 'HomeHeaderTitle') do
            span('Elastic')
            span(:class => 'euiTextColor euiTextColor--subdued') do
              rawtext('&nbsp;Enterprise Search')
            end
          end
        end
      end
      if user_signed_in?
        div(:class => 'euiHeaderSection euiHeaderSection--dontGrow euiHeaderSection--right') do
          div(:class => 'euiHeaderSectionItem') do
            div(:class => 'enterprise-search-home__user-menu euiPopover euiPopover--anchorDownRight') do
              div(:class => 'euiPopover__anchor') do
                button(:id => 'js-user-menu-toggle', :class => 'euiAvatar euiAvatar--s euiAvatar--user', :title => current_user.name, :'aria-label' => 'Interact with this button to open the User Account Menu', :type => 'button') do
                  span(:'aria-hidden' => 'true') do
                    text current_user.name.first.capitalize
                  end
                end
              end
              div(:id => 'js-user-menu', :class => 'euiPanel euiPanel--paddingMedium euiPopover__panel euiPopover__panel--bottom') do
                div(:class => 'euiPopover__panelArrow euiPopover__panelArrow--bottom')
                div(:class => 'enterprise-search-home__user-menu-content') do
                  dl(:class => 'euiDescriptionList euiDescriptionList--row') do
                    dt(:class => 'euiDescriptionList__title') do
                      text 'Account'
                    end
                    dd(:class => 'euiDescriptionList__description eui-textTruncate') do
                      text current_user.name
                    end
                    dt(:class => 'euiDescriptionList__title') do
                      text 'Current license'
                    end
                    dd(:class => 'euiDescriptionList__description') do
                      span(:class => "enterprise-search-home__license enterprise-search-home__license--#{current_license['type']}") do
                        text actual_current_license_display_with_status
                      end
                    end
                    dt(:class => 'euiDescriptionList__title') do
                      text 'Version'
                    end
                    dd(:class => 'euiDescriptionList__description') do
                      text AppConfig.product_version
                    end
                  end
                  a(:class => 'enterprise-search-home__logout euiLink euiLink--primary', :href => '/logout') do
                    text 'Log Out'
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
