class Views::Stui::Components::Icons < ::Views::Base
  def content
    rawtext %{
      <svg width="0" height="0" style="position:absolute"><symbol viewBox="0 0 18 18" id="analytics" xmlns="http://www.w3.org/2000/svg"><path d="M16.836 7.896a.65.65 0 01-.65-.65V4.735l-4.877 4.877a.65.65 0 01-.92 0L6.645 5.868l-5.258 5.258a.65.65 0 11-.919-.92L6.186 4.49a.65.65 0 01.919 0l3.744 3.744 4.405-4.405h-2.485a.65.65 0 110-1.3h4.067a.65.65 0 01.65.65v4.068a.65.65 0 01-.65.65zM2.052 13.763v2.54a.65.65 0 001.3 0v-2.54a.65.65 0 10-1.3 0zm12 2.54V9.488a.65.65 0 111.3 0v6.815a.65.65 0 01-1.3 0zm-4-4.04v4.04a.65.65 0 101.3 0v-4.04a.65.65 0 00-1.3 0z" /><path d="M6.052 16.303V9.462a.65.65 0 111.3 0v6.84a.65.65 0 11-1.3 0z"/></symbol><symbol viewBox="0 0 18 18" id="analytics-fill" xmlns="http://www.w3.org/2000/svg"><path d="M16.832 8.105a.85.85 0 01-.85-.85V5.227l-4.536 4.536a.85.85 0 01-1.202 0L6.642 6.161l-5.117 5.116a.85.85 0 01-1.202-1.202l5.718-5.717a.85.85 0 011.202 0l3.602 3.602 3.922-3.922h-2.002a.85.85 0 010-1.7h4.067c.47 0 .85.38.85.85v4.067c0 .47-.38.85-.85.85zM1.848 13.773v2.54a.85.85 0 001.7 0v-2.54a.85.85 0 10-1.7 0z"/><path d="M13.848 16.313V9.497a.85.85 0 011.7 0v6.815a.85.85 0 11-1.7 0zm-4-4.04v4.04a.85.85 0 001.7 0v-4.04a.85.85 0 10-1.7 0zm-4 4.04V9.471a.85.85 0 011.7 0v6.84a.85.85 0 11-1.7 0z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-down" xmlns="http://www.w3.org/2000/svg"><path d="M12.899 6.149a.85.85 0 011.202 1.202l-4.5 4.5a.85.85 0 01-1.202 0l-4.5-4.5A.85.85 0 015.101 6.15L9 10.048l3.899-3.899z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-down-fill" xmlns="http://www.w3.org/2000/svg"><path d="M12.793 6.043a1 1 0 111.414 1.414l-4.5 4.5a1 1 0 01-1.414 0l-4.5-4.5a1 1 0 011.414-1.414L9 9.836l3.793-3.793z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-left" xmlns="http://www.w3.org/2000/svg"><path d="M11.851 12.899a.85.85 0 01-1.202 1.202l-4.5-4.5a.85.85 0 010-1.202l4.5-4.5a.85.85 0 011.202 1.202L7.952 9l3.9 3.899z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-left-fill" xmlns="http://www.w3.org/2000/svg"><path d="M11.957 12.793a1 1 0 01-1.414 1.414l-4.5-4.5a1 1 0 010-1.414l4.5-4.5a1 1 0 111.414 1.414L8.164 9l3.793 3.793z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-right" xmlns="http://www.w3.org/2000/svg"><path d="M6.149 5.101A.85.85 0 017.351 3.9l4.5 4.5a.85.85 0 010 1.202l-4.5 4.5A.85.85 0 016.15 12.9L10.048 9 6.149 5.101z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-right-fill" xmlns="http://www.w3.org/2000/svg"><path d="M6.043 5.207a1 1 0 011.414-1.414l4.5 4.5a1 1 0 010 1.414l-4.5 4.5a1 1 0 01-1.414-1.414L9.836 9 6.043 5.207z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-up" xmlns="http://www.w3.org/2000/svg"><path d="M9 7.952l-3.899 3.9A.85.85 0 013.9 10.648l4.5-4.5a.85.85 0 011.202 0l4.5 4.5A.85.85 0 0112.9 11.85L9 7.952z"/></symbol><symbol viewBox="0 0 18 18" id="arrow-up-fill" xmlns="http://www.w3.org/2000/svg"><path d="M5.207 11.957a1 1 0 01-1.414-1.414l4.5-4.5a1 1 0 011.414 0l4.5 4.5a1 1 0 01-1.414 1.414L9 8.164l-3.793 3.793z"/></symbol><symbol viewBox="0 0 19 18" id="boosts" xmlns="http://www.w3.org/2000/svg"><path d="M13.119 1.946L8.36 11.202a2.57 2.57 0 102.12.856l3.007-9.962a.2.2 0 00-.37-.15zm1.5 1.789a.65.65 0 00.38.837c.52.195 1.012.414 1.473.656l-1.848 3.388a8.875 8.875 0 00-.647-.3.65.65 0 10-.5 1.2c.384.16.732.34 1.04.534a.65.65 0 00.855-.143c.06-.075.114-.156.16-.241l2.39-4.38a.65.65 0 00-.239-.87c-.68-.405-1.426-.76-2.227-1.061a.65.65 0 00-.837.38zM8.17 8.062a.65.65 0 00-.713-.58c-1.54.159-2.951.554-4.08 1.134L1.529 5.228C3.587 4.149 6.213 3.539 9 3.539c.241 0 .482.005.721.014a.65.65 0 10.05-1.3c-.257-.01-.514-.014-.771-.014-3.267 0-6.345.785-8.683 2.177a.65.65 0 00-.239.87l2.39 4.38c.046.085.1.166.16.24a.65.65 0 00.856.144C4.508 9.4 5.959 8.943 7.59 8.775a.65.65 0 00.58-.713z"/></symbol><symbol viewBox="0 0 19 18" id="boosts-fill" xmlns="http://www.w3.org/2000/svg"><path d="M13.119 1.946L8.36 11.202a2.57 2.57 0 102.12.856l3.007-9.962a.2.2 0 00-.37-.15zm4.564 2.47c-.46-.275-1.19-.622-2.202-1.051a.65.65 0 00-.876.41l-1.5 4.953a.65.65 0 00.349.778c.508.236.866.42 1.063.544a.65.65 0 00.855-.143 1.64 1.64 0 00.16-.241l2.39-4.38a.65.65 0 00-.239-.87zM2.63 9.907a.65.65 0 00.855.143C4.508 9.4 5.959 8.943 7.59 8.775c.56-.058.641-.248 2.76-5.634a.65.65 0 00-.586-.888A28.82 28.82 0 009 2.239c-3.267 0-6.345.785-8.683 2.177a.65.65 0 00-.239.87l2.39 4.38c.046.085.1.166.16.24z"/></symbol><symbol viewBox="0 0 18 18" id="changecontext" xmlns="http://www.w3.org/2000/svg"><path d="M14.168 3.777c.083 1.697.087 3.496-.037 5.175-.264 3.56-1.072 5.655-2.253 5.655-1.092 0-1.622-1.47-2.262-5.705l-.008-.056C8.84 3.753 8.247 2.092 6.122 2.092 3.92 2.092 2.927 4.685 2.6 8.95a44.474 44.474 0 00-.07 5.08l-1.11-1.11a.65.65 0 00-.919.92l2.284 2.284a.65.65 0 00.92 0l2.284-2.285a.65.65 0 00-.92-.919l-1.234 1.235c-.071-1.671-.067-3.446.06-5.106.274-3.557 1.078-5.658 2.228-5.658 1.05 0 1.565 1.444 2.2 5.649l.008.056c.771 5.109 1.385 6.81 3.547 6.81 2.232 0 3.234-2.598 3.55-6.86.124-1.674.124-3.45.047-5.138l1.105 1.105a.65.65 0 00.92-.919L15.215 1.81a.65.65 0 00-.92 0l-2.283 2.284a.65.65 0 00.919.92l1.237-1.238z"/></symbol><symbol viewBox="0 0 18 18" id="check" xmlns="http://www.w3.org/2000/svg"><path d="M6.81 11.243l6.603-6.607a1 1 0 011.415 1.414l-7.31 7.314a1 1 0 01-1.415 0l-2.93-2.932a1 1 0 011.414-1.414l2.223 2.225z"/></symbol><symbol viewBox="0 0 18 18" id="check-fill" xmlns="http://www.w3.org/2000/svg"><path d="M13.06 4.282a1.5 1.5 0 112.121 2.12l-7.31 7.316a1.5 1.5 0 01-2.122 0l-2.93-2.933a1.5 1.5 0 012.122-2.12l1.87 1.87 6.248-6.253z"/></symbol><symbol viewBox="0 0 18 18" id="close" xmlns="http://www.w3.org/2000/svg"><path d="M10.194 8.939l3.702 3.704c.801.802-.401 2.003-1.203 1.202l-3.7-3.704-3.702 3.704a.85.85 0 01-1.202-1.202L7.79 8.94 4.21 5.357c-.801-.802.401-2.003 1.202-1.202l3.58 3.581 3.578-3.58a.85.85 0 111.203 1.2l-3.58 3.583z"/></symbol><symbol viewBox="0 0 18 18" id="close-fill" xmlns="http://www.w3.org/2000/svg"><path d="M10.414 8.939l3.596 3.598a1 1 0 01-1.415 1.414L9 10.354 5.405 13.95a1 1 0 01-1.415-1.414L7.586 8.94 4.112 5.463a1 1 0 011.415-1.414L9 7.524l3.473-3.475a1 1 0 011.415 1.414l-3.474 3.476z"/></symbol><symbol viewBox="0 0 18 18" id="code" xmlns="http://www.w3.org/2000/svg"><path d="M9.579 3.438l-1.88 11.196a.65.65 0 101.283.215L10.86 3.653a.65.65 0 00-1.282-.215zM5.911 6.38a.65.65 0 10-.82-1.009L1.07 8.64a.65.65 0 000 1.01l4.021 3.267a.65.65 0 10.82-1.009l-3.4-2.763 3.4-2.764zm6.351 6.442a.65.65 0 01.095-.915l3.4-2.763-3.4-2.764a.65.65 0 11.82-1.009l4.021 3.268a.65.65 0 010 1.01l-4.021 3.267a.65.65 0 01-.915-.095z"/></symbol><symbol viewBox="0 0 18 18" id="code-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9.53 3.405L7.651 14.601a.85.85 0 101.677.281l1.879-11.195a.85.85 0 10-1.677-.282zM6.186 6.536a.85.85 0 00-1.072-1.32L1.093 8.484a.85.85 0 000 1.32l4.02 3.267a.85.85 0 101.073-1.32l-3.21-2.607 3.21-2.608zm6.07 6.412a.85.85 0 01.123-1.196l3.21-2.608-3.21-2.608a.85.85 0 011.073-1.32l4.02 3.268a.85.85 0 010 1.32l-4.02 3.267a.85.85 0 01-1.196-.123z"/></symbol><symbol viewBox="0 0 18 18" id="content" xmlns="http://www.w3.org/2000/svg"><path d="M7.666 9.75h6.08a.65.65 0 100-1.3h-6.08a.65.65 0 100 1.3zm6.081 3.448h-6.08a.65.65 0 110-1.3h6.08a.65.65 0 010 1.3zM4.054 9.75h.694a.65.65 0 000-1.3h-.694a.65.65 0 100 1.3zm.694 3.448h-.694a.65.65 0 110-1.3h.694a.65.65 0 010 1.3z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M1.006 1.384h16a.65.65 0 01.65.65v13.932a.65.65 0 01-.65.65h-16a.65.65 0 01-.65-.65V2.034a.65.65 0 01.65-.65zm.65 13.932h14.7v-8.99h-14.7v8.99zm0-10.29V2.684h14.7v2.342h-14.7z"/></symbol><symbol viewBox="0 0 18 18" id="content-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.66 9.762a.85.85 0 010-1.7h6.081a.85.85 0 010 1.7H7.66zm0 2.102h6.081a.85.85 0 110 1.7H7.66a.85.85 0 010-1.7zM4.048 8.062h.694a.85.85 0 110 1.7h-.694a.85.85 0 010-1.7zm.694 3.802a.85.85 0 110 1.7h-.694a.85.85 0 010-1.7h.694zM1.65 5.02h14.7V2.684H1.65v2.337zM1 1.384a.65.65 0 00-.65.65v13.932c0 .359.291.65.65.65h16a.65.65 0 00.65-.65V2.034a.65.65 0 00-.65-.65H1z"/></symbol><symbol viewBox="0 0 18 18" id="context" xmlns="http://www.w3.org/2000/svg"><path d="M10.5 9a1.502 1.502 0 11-3.003 0A1.502 1.502 0 0110.5 9zm4.498 1.501a1.501 1.501 0 100-3.002 1.501 1.501 0 000 3.002zm-12-.003a1.498 1.498 0 100-2.996 1.498 1.498 0 000 2.996z"/></symbol><symbol viewBox="0 0 18 18" id="context-fill" xmlns="http://www.w3.org/2000/svg"><path d="M11.006 9a2.005 2.005 0 11-4.01 0 2.005 2.005 0 014.01 0zm-8.005 2.001a2.001 2.001 0 100-4.002 2.001 2.001 0 000 4.002zm12-.002a1.999 1.999 0 100-3.998 1.999 1.999 0 000 3.998z"/></symbol><symbol viewBox="0 0 18 18" id="conversions" xmlns="http://www.w3.org/2000/svg"><path d="M3.822 2.063L3.771 1.9a1.25 1.25 0 10-2.387.745l.052.164c.146.468.541.789.994.862l3.967 12.714a.65.65 0 001.241-.387l-4-12.82v-.003c.225-.31.307-.717.184-1.11zm7.392 4.11c.126.002.226.006.447.013 1.844.064 2.787-.132 3.623-1.214-1.288.117-2.557-.2-4.365-.896-1.951-.75-2.566-.913-3.411-.779-.467.075-.91.273-1.362.625a.65.65 0 11-.8-1.024c.621-.486 1.27-.775 1.957-.885 1.166-.185 1.893.008 4.082.85 2.25.864 3.466 1.062 5.026.54a.65.65 0 01.787.909c-1.368 2.716-2.724 3.272-5.582 3.174a33.01 33.01 0 00-.431-.014C9.572 7.436 8.72 7.72 7.82 8.857A.65.65 0 116.8 8.05c1.196-1.51 2.433-1.922 4.414-1.877z"/></symbol><symbol viewBox="0 0 18 18" id="conversions-fill" xmlns="http://www.w3.org/2000/svg"><path d="M3.886 2.002l-.051-.163a1.5 1.5 0 00-2.864.893l.05.164A1.5 1.5 0 002.118 3.91L6.03 16.457a.85.85 0 101.623-.506L3.701 3.282c.243-.364.325-.83.185-1.28zm7.328 1.041c-2.19-.842-2.917-1.035-4.082-.85a4.11 4.11 0 00-1.696.693.65.65 0 00-.255.725l1.517 4.993a.65.65 0 001.11.24c.857-.977 1.677-1.227 3.205-1.192l.432.013c2.858.1 4.214-.457 5.581-3.173a.65.65 0 00-.787-.909c-1.56.522-2.776.324-5.025-.54z"/></symbol><symbol viewBox="0 0 18 18" id="copy" xmlns="http://www.w3.org/2000/svg"><path d="M6.825 4.625a1.7 1.7 0 00-1.7 1.7v8a1.7 1.7 0 001.7 1.7h7a1.7 1.7 0 001.7-1.7v-8a1.7 1.7 0 00-1.7-1.7h-7zm0-1.3h7a3 3 0 013 3v8a3 3 0 01-3 3h-7a3 3 0 01-3-3v-8a3 3 0 013-3zm-4.032 10.18a.65.65 0 01-1.124.655 3.635 3.635 0 01-.494-1.835v-8a3.65 3.65 0 013.65-3.65h7.002c.653 0 1.282.172 1.835.494a.65.65 0 01-.654 1.123 2.337 2.337 0 00-1.18-.317H4.825a2.35 2.35 0 00-2.35 2.35v8c-.001.421.11.825.317 1.18z"/></symbol><symbol viewBox="0 0 18 18" id="copy-fill" xmlns="http://www.w3.org/2000/svg"><path d="M6.925 3.425h7a3 3 0 013 3v8a3 3 0 01-3 3h-7a3 3 0 01-3-3v-8a3 3 0 013-3zm-3.86 10.08a.85.85 0 01-1.469.856 3.835 3.835 0 01-.521-1.936v-8a3.85 3.85 0 013.85-3.85h7.002c.689 0 1.353.182 1.936.521a.85.85 0 01-.856 1.47 2.137 2.137 0 00-1.08-.291H4.926a2.15 2.15 0 00-2.151 2.15v8c0 .386.101.755.29 1.08z"/></symbol><symbol viewBox="0 0 18 18" id="delete" xmlns="http://www.w3.org/2000/svg"><path d="M4.74 3.41l.202-.665A2.65 2.65 0 017.477.87h3.038a2.65 2.65 0 012.535 1.876l.202.664h2.752a.65.65 0 110 1.3h-.465v8.422a4 4 0 01-4 4H6.453a4 4 0 01-4-4V4.71h-.457a.65.65 0 010-1.3h2.743zm1.358 0h5.795l-.087-.285a1.35 1.35 0 00-1.29-.956h-3.04a1.35 1.35 0 00-1.29.956l-.088.284zM3.753 4.796v8.334a2.7 2.7 0 002.7 2.7h5.086a2.7 2.7 0 002.7-2.7V4.797H3.753zm4.593 2.031a.65.65 0 011.3 0v6a.65.65 0 11-1.3 0v-6zm2.75 0a.65.65 0 111.3 0v6a.65.65 0 11-1.3 0v-6zm-5.5 0a.65.65 0 011.3 0v6a.65.65 0 11-1.3 0v-6z"/></symbol><symbol viewBox="0 0 18 18" id="delete-fill" xmlns="http://www.w3.org/2000/svg"><path d="M4.74 3.41l.202-.665A2.65 2.65 0 017.477.87h3.038a2.65 2.65 0 012.535 1.876l.202.664h2.752a.65.65 0 110 1.3H1.996a.65.65 0 010-1.3h2.743zm1.358 0h5.795l-.087-.285a1.35 1.35 0 00-1.29-.956h-3.04a1.35 1.35 0 00-1.29.956l-.088.284zM2.453 5.706h13.086v7.424a4 4 0 01-4 4H6.453a4 4 0 01-4-4V5.707zm5.893 2.121v6a.65.65 0 101.3 0v-6a.65.65 0 00-1.3 0zm2.75 0v6a.65.65 0 101.3 0v-6a.65.65 0 10-1.3 0zm-5.5 0v6a.65.65 0 101.3 0v-6a.65.65 0 00-1.3 0z"/></symbol><symbol viewBox="0 0 18 18" id="documentation" xmlns="http://www.w3.org/2000/svg"><path d="M11.348 10.289v2.307a.65.65 0 101.3 0V10.29a.65.65 0 10-1.3 0zm0-1.924v-.386a.65.65 0 111.3 0v.386a.65.65 0 11-1.3 0z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14.906.726v5.017a5.37 5.37 0 012.466 4.52 5.37 5.37 0 01-2.466 4.52v2.491a.65.65 0 01-.65.65H1.271a.65.65 0 01-.65-.65V7.041a.65.65 0 01.197-.466L7.311.26a.65.65 0 01.453-.184h6.492a.65.65 0 01.65.65zM1.921 7.579v9.045h11.685v-1.232a5.374 5.374 0 01-6.264-7.813h-5.42zm6.493-1.32a5.354 5.354 0 013.584-1.37c.56 0 1.1.086 1.608.245V1.376H8.414v4.883zm-1.3-3.994L2.987 6.279h4.127V2.265zm8.958 7.998a4.074 4.074 0 11-8.147 0 4.074 4.074 0 018.147 0z"/></symbol><symbol viewBox="0 0 18 18" id="documentation-fill" xmlns="http://www.w3.org/2000/svg"><path d="M11.349 12.601v-2.309a.65.65 0 011.3 0v2.31a.65.65 0 01-1.3 0zm0-4.618v.386a.65.65 0 101.3 0v-.386a.65.65 0 00-1.3 0z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M17.372 10.267a5.361 5.361 0 00-2.466-4.508V.73a.65.65 0 00-.65-.65H7.763a.651.651 0 00-.453.184L.818 6.58a.651.651 0 00-.197.466v10.233c0 .36.291.65.65.65h12.985a.65.65 0 00.65-.65v-2.502a5.364 5.364 0 002.466-4.509zm-1.3 0a4.074 4.074 0 11-8.148 0 4.074 4.074 0 018.148 0zm-8.687-3.71V2.005l-4.68 4.552h4.68z"/></symbol><symbol viewBox="0 0 18 18" id="domains" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M.384 8.966a8.616 8.616 0 1017.232 0 8.616 8.616 0 00-17.232 0zm15.932 0c0 .818-.134 1.604-.381 2.338h-2.911a28.247 28.247 0 00.024-4.364h2.984c.185.643.284 1.323.284 2.026zm-.798-3.326a7.348 7.348 0 00-3.241-3.217 19.9 19.9 0 01.645 3.217h2.596zm-3.906 0c-.188-1.455-.498-2.758-.903-3.79a7.335 7.335 0 00-3.418 0c-.405 1.032-.715 2.335-.903 3.79h5.224zm-5.356 1.3a27.093 27.093 0 00.025 4.364h5.438a26.887 26.887 0 00.025-4.364H6.256zm-1.304 0a28.454 28.454 0 00.024 4.364h-2.91a7.307 7.307 0 01-.382-2.338c0-.703.099-1.382.284-2.026h2.984zm.126-1.3H2.482a7.348 7.348 0 013.241-3.217 19.959 19.959 0 00-.645 3.217zm7.805 6.964h2.466a7.35 7.35 0 01-3.07 2.905c.257-.872.461-1.853.604-2.905zm-2.172 3.477c.375-.957.669-2.148.86-3.477H6.43c.19 1.33.484 2.52.86 3.477a7.335 7.335 0 003.42 0zm-4.99-.572a19.564 19.564 0 01-.604-2.905H2.651a7.35 7.35 0 003.07 2.905z"/></symbol><symbol viewBox="0 0 18 18" id="domains-fill" xmlns="http://www.w3.org/2000/svg"><path d="M8.227.44C7.5 1.419 6.93 3.258 6.629 5.49h4.769C11.1 3.28 10.537 1.455 9.82.467a.123.123 0 01-.016-.033.14.14 0 00-.013-.03 8.69 8.69 0 00-.777-.04c-.26 0-.516.017-.77.039l-.007.015V.42a.08.08 0 01-.01.02zm4.885 5.05h3.775A8.634 8.634 0 0011.972.896c.524 1.233.916 2.814 1.14 4.594zM6.46 7.19a27.192 27.192 0 00-.066 1.805c0 .742.037 1.46.092 2.16h5.055a27.42 27.42 0 00.092-2.16c0-.617-.027-1.216-.066-1.805H6.46zm5.528 9.868c.482-1.144.85-2.585 1.078-4.204h3.636a8.63 8.63 0 01-4.715 4.204zM17.63 8.98a8.61 8.61 0 01-.288 2.174h-4.097c.052-.703.088-1.42.088-2.159 0-.614-.025-1.214-.06-1.805h4.168c.122.578.188 1.176.188 1.79zM4.962 12.854H1.325a8.626 8.626 0 004.715 4.204c-.482-1.144-.851-2.585-1.078-4.204zm6.392.001c-.308 2.043-.85 3.717-1.524 4.656-.006.007-.009.016-.012.024a.121.121 0 01-.01.022c-.261.024-.526.04-.794.04-.267 0-.53-.016-.791-.04a.052.052 0 01-.006-.014l-.007-.016c-.68-.934-1.226-2.617-1.536-4.672h4.68zm-6.66-3.86c0-.614.025-1.214.06-1.805H.587a8.654 8.654 0 00-.189 1.79c0 .752.107 1.478.288 2.174h4.097a29.139 29.139 0 01-.088-2.159zM6.057.896C5.53 2.13 5.14 3.71 4.916 5.49H1.14A8.63 8.63 0 016.058.896z"/></symbol><symbol viewBox="0 0 18 18" id="edit" xmlns="http://www.w3.org/2000/svg"><path d="M12.86 1.71L6.003 8.569a.485.485 0 00-.128.225l-.853 3.398a.647.647 0 00.787.789l3.394-.85a.485.485 0 00.225-.127L16.29 5.14A2.424 2.424 0 0014.576 1a2.425 2.425 0 00-1.715.71zm-3.7 9.19L7.1 8.842l5.257-5.259 2.058 2.058-5.257 5.26zm6.445-6.445l-.501.5-2.058-2.057.501-.501a1.455 1.455 0 112.058 2.058z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M1.35 5A3.65 3.65 0 015 1.35h3.611a.65.65 0 010 1.3H5A2.35 2.35 0 002.65 5v8A2.35 2.35 0 005 15.35h8A2.35 2.35 0 0015.35 13V9a.65.65 0 111.3 0v4A3.65 3.65 0 0113 16.65H5A3.65 3.65 0 011.35 13V5z"/></symbol><symbol viewBox="0 0 18 18" id="edit-fill" xmlns="http://www.w3.org/2000/svg"><path d="M5 1a4 4 0 00-4 4v8a4 4 0 004 4h8a4 4 0 004-4V9a1 1 0 00-2 0v4a2 2 0 01-2 2H5a2 2 0 01-2-2V5a2 2 0 012-2h3.611a1 1 0 100-2H5zm7.366 1.205l3.429 3.43.494-.495A2.426 2.426 0 0014.576 1a2.425 2.425 0 00-1.715.71l-.495.495z"/><path d="M11.658 2.912L7.123 7.447l3.43 3.43 4.535-4.535-3.43-3.43zM6.416 8.155l-.414.414a.486.486 0 00-.128.225l-.853 3.398a.647.647 0 00.787.789l3.395-.85a.485.485 0 00.224-.127l.42-.42-3.43-3.43z"/></symbol><symbol viewBox="0 0 18 18" id="engagementmodule" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.088 8.8c0-4.503-3.62-8.124-8.088-8.124a8.089 8.089 0 00-8.088 8.09l.4 7.941a.65.65 0 00.65.617h4.283a.65.65 0 00.65-.65V9.341c0-1.143.95-2.08 2.105-2.08 1.156 0 2.105.937 2.105 2.08v7.333c0 .36.291.65.65.65h4.267a.65.65 0 00.649-.616l.417-7.909zm-1.51 3.942l-.173 3.282h-3v-3.282h3.174zm.07-1.3l.14-2.677c0-3.75-3.038-6.79-6.788-6.79-3.75 0-6.788 3.04-6.79 6.757l.138 2.71h3.247v-2.1C5.595 7.476 7.13 5.96 9 5.96c1.87 0 3.405 1.517 3.405 3.381v2.1h3.242zm-13.235 1.3h3.182v3.282H2.58l-.166-3.282z"/></symbol><symbol viewBox="0 0 18 18" id="engagementmodule-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.406 16.024v-3.282h3.173l-.173 3.282h-3zm-9.826 0l-.166-3.282h3.182v3.282H2.58zM9 .676A8.089 8.089 0 00.913 8.765l.4 7.942a.65.65 0 00.65.617h4.284a.65.65 0 00.65-.65V9.341c0-1.143.949-2.081 2.105-2.081 1.156 0 2.105.938 2.105 2.081v7.333c0 .359.29.65.65.65h4.267c.345 0 .63-.271.649-.616l.417-7.909C17.089 4.297 13.468.676 9 .676z"/></symbol><symbol viewBox="0 0 18 18" id="engine" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.776 1.389a7.66 7.66 0 00-.725-.04v.001H9a7.65 7.65 0 00-.051 15.301v-.001H9a7.65 7.65 0 00.776-15.261zm-1.52 1.254a6.401 6.401 0 00.02 12.716l2.333-3.791a.875.875 0 00-.354-1.242l-3.07-1.534a2.125 2.125 0 01-.859-3.015l1.93-3.134zm1.489 12.714l1.929-3.134a2.125 2.125 0 00-.86-3.015l-3.07-1.534a.875.875 0 01-.353-1.242L9.724 2.64a6.401 6.401 0 01.02 12.717z"/></symbol><symbol viewBox="0 0 18 18" id="engine-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.65a7.65 7.65 0 10-1.436-.134l3.045-4.948a.875.875 0 00-.354-1.242l-3.07-1.534a2.125 2.125 0 01-.859-3.015L9.051 1.35c.473.003.936.05 1.385.135L7.39 6.432a.875.875 0 00.354 1.242l3.07 1.534a2.125 2.125 0 01.859 3.015L8.949 16.65H9z"/></symbol><symbol viewBox="0 0 18 18" id="engine_selector" xmlns="http://www.w3.org/2000/svg"><path d="M2 3a1 1 0 011-1h1.5a1 1 0 011 1v1.5a1 1 0 01-1 1H3a1 1 0 01-1-1V3zm5.25 0a1 1 0 011-1h1.5a1 1 0 011 1v1.5a1 1 0 01-1 1h-1.5a1 1 0 01-1-1V3zm6.25-1a1 1 0 00-1 1v1.5a1 1 0 001 1H15a1 1 0 001-1V3a1 1 0 00-1-1h-1.5zM2 8.25a1 1 0 011-1h1.5a1 1 0 011 1v1.5a1 1 0 01-1 1H3a1 1 0 01-1-1v-1.5zm6.25-1a1 1 0 00-1 1v1.5a1 1 0 001 1h1.5a1 1 0 001-1v-1.5a1 1 0 00-1-1h-1.5zm4.25 1a1 1 0 011-1H15a1 1 0 011 1v1.5a1 1 0 01-1 1h-1.5a1 1 0 01-1-1v-1.5zM3 12.5a1 1 0 00-1 1V15a1 1 0 001 1h1.5a1 1 0 001-1v-1.5a1 1 0 00-1-1H3zm4.25 1a1 1 0 011-1h1.5a1 1 0 011 1V15a1 1 0 01-1 1h-1.5a1 1 0 01-1-1v-1.5zm6.25-1a1 1 0 00-1 1V15a1 1 0 001 1H15a1 1 0 001-1v-1.5a1 1 0 00-1-1h-1.5z"/></symbol><symbol viewBox="0 0 18 18" id="engine_selector-fill" xmlns="http://www.w3.org/2000/svg"><path d="M1.75 3c0-.69.56-1.25 1.25-1.25h1.5c.69 0 1.25.56 1.25 1.25v1.5c0 .69-.56 1.25-1.25 1.25H3c-.69 0-1.25-.56-1.25-1.25V3zM7 3c0-.69.56-1.25 1.25-1.25h1.5c.69 0 1.25.56 1.25 1.25v1.5c0 .69-.56 1.25-1.25 1.25h-1.5C7.56 5.75 7 5.19 7 4.5V3zm6.5-1.25H15c.69 0 1.25.56 1.25 1.25v1.5c0 .69-.56 1.25-1.25 1.25h-1.5c-.69 0-1.25-.56-1.25-1.25V3c0-.69.56-1.25 1.25-1.25zM1.75 8.25C1.75 7.56 2.31 7 3 7h1.5c.69 0 1.25.56 1.25 1.25v1.5c0 .69-.56 1.25-1.25 1.25H3c-.69 0-1.25-.56-1.25-1.25v-1.5zM8.25 7h1.5c.69 0 1.25.56 1.25 1.25v1.5c0 .69-.56 1.25-1.25 1.25h-1.5C7.56 11 7 10.44 7 9.75v-1.5C7 7.56 7.56 7 8.25 7zm4 1.25c0-.69.56-1.25 1.25-1.25H15c.69 0 1.25.56 1.25 1.25v1.5c0 .69-.56 1.25-1.25 1.25h-1.5c-.69 0-1.25-.56-1.25-1.25v-1.5zm-9.25 4h1.5c.69 0 1.25.56 1.25 1.25V15c0 .69-.56 1.25-1.25 1.25H3c-.69 0-1.25-.56-1.25-1.25v-1.5c0-.69.56-1.25 1.25-1.25zm4 1.25c0-.69.56-1.25 1.25-1.25h1.5c.69 0 1.25.56 1.25 1.25V15c0 .69-.56 1.25-1.25 1.25h-1.5C7.56 16.25 7 15.69 7 15v-1.5zm6.5-1.25H15c.69 0 1.25.56 1.25 1.25V15c0 .69-.56 1.25-1.25 1.25h-1.5c-.69 0-1.25-.56-1.25-1.25v-1.5c0-.69.56-1.25 1.25-1.25z"/></symbol><symbol viewBox="0 0 18 18" id="error" xmlns="http://www.w3.org/2000/svg"><path d="M9.086 7.922l1.884-1.884a.75.75 0 111.06 1.06l-1.883 1.885 1.883 1.884a.75.75 0 11-1.06 1.06l-1.884-1.884-1.884 1.884a.75.75 0 01-1.06-1.06l1.883-1.884-1.884-1.884a.75.75 0 011.06-1.06l1.885 1.883zM9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3zm0-1.3a6.35 6.35 0 100-12.7 6.35 6.35 0 000 12.7z"/></symbol><symbol viewBox="0 0 18 18" id="error-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9.086 7.922L7.202 6.038a.75.75 0 00-1.06 1.06l1.883 1.885-1.884 1.884a.75.75 0 001.06 1.06l1.885-1.884 1.884 1.884a.75.75 0 001.06-1.06l-1.883-1.884 1.883-1.884a.75.75 0 00-1.06-1.061L9.086 7.922zM9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3z"/></symbol><symbol viewBox="0 0 18 18" id="exit" xmlns="http://www.w3.org/2000/svg"><path d="M10.892 9.418H3.415l1.858 1.858a.65.65 0 01-.919.919l-2.97-2.97a.65.65 0 010-.919L4.35 5.34a.65.65 0 01.92.919L3.41 8.117h7.48c.867 0 .867 1.3 0 1.3h.001z"/><path d="M15.465 2.625v12.75H8.668v-2.832a.65.65 0 10-1.3 0v3.482c0 .359.29.65.65.65h8.097a.65.65 0 00.65-.65V1.975a.65.65 0 00-.65-.65H8.018a.65.65 0 00-.65.65v3.292a.65.65 0 101.3 0V2.626h6.797z"/></symbol><symbol viewBox="0 0 18 18" id="expand" xmlns="http://www.w3.org/2000/svg"><path d="M11.705 2.65a.65.65 0 110-1.3h.795a4.15 4.15 0 014.15 4.15v.895a.65.65 0 11-1.3 0V5.5a2.85 2.85 0 00-2.85-2.85h-.795zm3.645 9.024a.65.65 0 011.3 0v.826a4.15 4.15 0 01-4.15 4.15h-.847a.65.65 0 110-1.3h.847a2.85 2.85 0 002.85-2.85v-.826zM6.394 15.35a.65.65 0 010 1.3H5.5a4.15 4.15 0 01-4.15-4.15v-.851a.65.65 0 011.3 0v.851a2.85 2.85 0 002.85 2.85h.894zM2.65 6.409a.65.65 0 01-1.3 0V5.5A4.15 4.15 0 015.5 1.35h.89a.65.65 0 010 1.3H5.5A2.85 2.85 0 002.65 5.5v.909z"/></symbol><symbol viewBox="0 0 18 18" id="expand-fill" xmlns="http://www.w3.org/2000/svg"><path d="M11.704 2.85a.85.85 0 010-1.7h.796a4.35 4.35 0 014.35 4.35v.895a.85.85 0 01-1.7 0V5.5a2.65 2.65 0 00-2.65-2.65h-.796zm3.446 8.824a.85.85 0 111.7 0v.826a4.35 4.35 0 01-4.35 4.35h-.847a.85.85 0 010-1.7h.847a2.65 2.65 0 002.65-2.65v-.826zM6.394 15.15a.85.85 0 110 1.7H5.5a4.35 4.35 0 01-4.35-4.35v-.851a.85.85 0 111.7 0v.851a2.65 2.65 0 002.65 2.65h.894zM2.85 6.409a.85.85 0 11-1.7 0V5.5A4.35 4.35 0 015.5 1.15h.89a.85.85 0 010 1.7H5.5A2.65 2.65 0 002.85 5.5v.909z"/></symbol><symbol viewBox="0 0 18 18" id="feedback" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M1.55 12.982a.65.65 0 01-.842-.8l.832-2.75a5.127 5.127 0 01-.978-2.99C.563 3.246 3.58.705 7.253.705c3.346 0 6.172 2.114 6.627 4.94 2.11.958 3.557 2.858 3.557 5.071a5.127 5.127 0 01-.977 2.991l.832 2.749a.65.65 0 01-.843.8l-3.286-1.187a7.679 7.679 0 01-2.416.385c-3.159 0-5.833-1.88-6.52-4.439l-2.676.967zm2.506-2.287c.014-3.186 3.026-5.716 6.69-5.716a7.77 7.77 0 011.668.18c-.67-1.818-2.723-3.154-5.16-3.154-3 0-5.392 2.013-5.392 4.437 0 .883.315 1.729.901 2.453a.65.65 0 01.117.597l-.965 1.976 2.141-.774zm11.18 2.474a.65.65 0 00-.116.598l.553 1.826-2.285-.825a.65.65 0 00-.446.001 6.348 6.348 0 01-2.195.385c-3 0-5.391-2.014-5.391-4.438s2.391-4.437 5.39-4.437c3 0 5.391 2.013 5.391 4.437 0 .883-.314 1.729-.9 2.453z"/></symbol><symbol viewBox="0 0 18 18" id="feedback-fill" xmlns="http://www.w3.org/2000/svg"><path d="M10.747 3.814c.936 0 1.836.139 2.674.394C12.4 2.132 10.002.704 7.253.704 3.58.704.563 3.246.563 6.442c0 1.074.343 2.102.977 2.99l-.832 2.75a.65.65 0 00.843.8l1.516-.548a5.946 5.946 0 01-.277-1.797c0-3.8 3.59-6.823 7.957-6.823z"/><path d="M4.056 10.716c0 3.196 3.018 5.738 6.69 5.738.837 0 1.653-.132 2.417-.385l3.286 1.187a.65.65 0 00.843-.8l-.832-2.75a5.125 5.125 0 00.977-2.99c0-3.196-3.017-5.737-6.69-5.737-3.673 0-6.691 2.541-6.691 5.737z"/></symbol><symbol viewBox="0 0 18 18" id="functional" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.578 6.294l-1.023 4.04c-.478 1.905-.944 3.287-1.399 4.144-.454.857-.986 1.49-1.595 1.902-.61.41-1.308.616-2.095.616-.495 0-.86-.095-1.092-.284-.234-.19-.35-.413-.35-.67 0-.238.096-.445.288-.62.193-.175.446-.262.761-.262.262 0 .463.067.603.2.14.135.21.304.21.508 0 .187-.044.325-.131.415-.087.09-.131.15-.131.18l.044.06a.18.18 0 00.122.044.641.641 0 00.446-.166 2.54 2.54 0 00.69-.996c.106-.268.307-.977.604-2.125l1.784-6.986H6.587l.288-1.023c.438.006 1.267-.05 1.465-.166.198-.117.408-.38.63-.787.64-1.183 1.317-2.032 2.028-2.544a3.97 3.97 0 012.378-.77c.56 0 .966.108 1.22.324.253.215.38.495.38.839 0 .303-.084.544-.253.721a.834.834 0 01-.63.267.799.799 0 01-.577-.219.702.702 0 01-.227-.524c0-.146.048-.3.144-.464.096-.163.144-.274.144-.332a.206.206 0 00-.065-.157.24.24 0 00-.17-.061c-.345 0-.697.212-1.059.638-.594.682-1.072 1.76-1.434 3.235h1.614l-.306 1.023h-1.579z"/></symbol><symbol viewBox="0 0 18 18" id="functional-fill" xmlns="http://www.w3.org/2000/svg"><path d="M10.664 6.73l-.904 3.573c-.45 1.793-.89 3.096-1.325 3.916-.441.832-.963 1.453-1.567 1.86-.61.412-1.308.618-2.09.618-.514 0-.907-.102-1.176-.32-.273-.223-.418-.5-.418-.818 0-.295.12-.554.35-.763.229-.207.525-.31.877-.31.305 0 .554.084.735.257.18.173.273.396.273.653 0 .091-.01.175-.028.253.226-.217.397-.475.514-.775.093-.237.279-.893.552-1.95L8.04 6.73H6.422l.41-1.455.193.002c.46.006 1.128-.058 1.233-.12.137-.08.307-.293.494-.637.613-1.132 1.266-1.95 1.962-2.453a3.947 3.947 0 012.361-.764c.576 0 1.01.115 1.298.361.293.249.443.58.443.972 0 .343-.1.63-.305.844a1.026 1.026 0 01-.768.327.993.993 0 01-.71-.274.904.904 0 01-.289-.669c0-.183.058-.37.17-.558.031-.055.056-.1.072-.133-.22.024-.468.185-.74.505-.482.553-.885 1.42-1.202 2.6h1.517l-.435 1.452h-1.462z"/></symbol><symbol viewBox="0 0 18 18" id="hide" xmlns="http://www.w3.org/2000/svg"><path d="M9.213 12.83a.65.65 0 11-.074-1.297 2.39 2.39 0 002.237-2.651.65.65 0 011.292-.142 3.69 3.69 0 01-3.455 4.09zm-.79-7.329a.65.65 0 11.202 1.284A2.391 2.391 0 006.61 9.147a.65.65 0 11-1.3 0A3.691 3.691 0 018.423 5.5zm-6.53 4.09a17.15 17.15 0 001.705 1.81l.134.12a.65.65 0 01-.866.97l-.145-.13A18.44 18.44 0 01.384 9.766a8.569 8.569 0 01-.182-.256.65.65 0 010-.729c.033-.05.095-.136.182-.256A18.44 18.44 0 012.72 5.932C4.698 4.126 6.812 3.029 9 3.029c.459 0 .919.05 1.378.146a.65.65 0 11-.268 1.272A5.389 5.389 0 009 4.328c-1.803 0-3.642.954-5.402 2.564a17.152 17.152 0 00-2.055 2.255c.097.127.214.277.35.443zm14.214-.888a17.159 17.159 0 00-1.977-2.054.65.65 0 01.854-.98 18.429 18.429 0 012.632 2.857c.087.12.149.207.182.256a.65.65 0 010 .729 16.5 16.5 0 01-.684.901 18.431 18.431 0 01-1.835 1.948c-1.977 1.809-4.09 2.905-6.28 2.905a6.79 6.79 0 01-1.69-.219.65.65 0 01.324-1.26c.46.119.915.179 1.367.179 1.803 0 3.642-.954 5.402-2.564a17.155 17.155 0 002.055-2.254 16.7 16.7 0 00-.35-.444zM3.994 15.92A.65.65 0 013 15.08l11-13a.65.65 0 01.993.84l-11 13z"/></symbol><symbol viewBox="0 0 18 18" id="hide-fill" xmlns="http://www.w3.org/2000/svg"><path d="M7.141 15.038l1.835-2.168H9a3.69 3.69 0 003.636-4.326l2.38-2.814a18.43 18.43 0 012.599 2.829c.088.12.15.207.183.256a.65.65 0 010 .729 16.492 16.492 0 01-.684.901 18.431 18.431 0 01-1.835 1.948c-1.977 1.809-4.09 2.905-6.28 2.905-.625 0-1.245-.09-1.858-.26zm-4.433-2.656A18.448 18.448 0 01.384 9.8a8.583 8.583 0 01-.182-.256.65.65 0 010-.729c.033-.05.095-.136.182-.256A18.438 18.438 0 012.72 5.965C4.698 4.159 6.812 3.062 9 3.062c.49 0 .977.055 1.459.16l-1.946 2.3a3.691 3.691 0 00-3.201 3.783l-2.604 3.078zm1.35 3.667a.85.85 0 01-1.297-1.098l11-13a.85.85 0 011.298 1.098l-11 13z"/></symbol><symbol viewBox="0 0 18 18" id="home" xmlns="http://www.w3.org/2000/svg"><path d="M8.787 2.03a.763.763 0 00-.193.115c-.071.058-2.718 2.467-5.029 4.577-.213.191-.41.39-.44.441-.134.217-.13.036-.122 4.314.007 3.733.009 3.955.05 4.052.067.155.22.326.36.398l.127.064 5.364.007c3.936.005 5.403 0 5.522-.023a.672.672 0 00.537-.48c.032-.101.037-.601.037-4.09 0-4.334.01-4.05-.133-4.26-.032-.046-.898-.85-1.921-1.78l-2.693-2.457c-.459-.416-.876-.789-.934-.824a.697.697 0 00-.532-.054zm2.55 3.804l2.313 2.115v6.526H4.348V7.95l1.581-1.444 2.32-2.12c.407-.37.747-.671.756-.669.009.003 1.058.957 2.332 2.118z"/></symbol><symbol viewBox="0 0 18 18" id="home-fill" xmlns="http://www.w3.org/2000/svg"><path d="M8.787 2.03a.763.763 0 00-.193.115c-.071.058-2.718 2.467-5.029 4.577-.213.191-.41.39-.44.441-.134.217-.13.036-.122 4.314.007 3.733.009 3.955.05 4.052.067.155.22.326.36.398l.127.064 5.364.007c3.936.005 5.403 0 5.522-.023a.672.672 0 00.537-.48c.032-.101.037-.601.037-4.09 0-4.334.01-4.05-.133-4.26-.032-.046-.898-.85-1.921-1.78l-2.693-2.457c-.459-.416-.876-.789-.934-.824a.697.697 0 00-.532-.054zm2.55 3.804l2.313 2.115v6.526H4.348V7.95l1.581-1.444 2.32-2.12c.407-.37.747-.671.756-.669.009.003 1.058.957 2.332 2.118z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M8.687 1.762a1.041 1.041 0 00-.28.166c-.142.124-2.759 2.505-5.034 4.582a7.622 7.622 0 00-.41.398.753.753 0 00-.083.107l-.01.016a.67.67 0 00-.1.233 2.966 2.966 0 00-.044.525c-.014.485-.013 1.407-.01 3.245l.001.444c.004 1.865.006 2.856.012 3.392.004.267.008.427.015.529a.713.713 0 00.046.242c.09.21.288.435.494.54l.188.095 5.431.008c1.968.003 3.32.003 4.194-.001a82.947 82.947 0 001.23-.014.958.958 0 00.908-.686c.022-.069.028-.16.033-.267.005-.12.009-.306.011-.593.005-.575.007-1.574.007-3.317v-.744c0-1.661 0-2.5-.014-2.942a2.362 2.362 0 00-.049-.505c-.03-.115-.092-.194-.113-.222a.29.29 0 01-.007-.008l-.001-.002-.001-.001a.454.454 0 00-.044-.052 195.032 195.032 0 00-1.918-1.776l-.724-.66-1.969-1.797v-.001a77.522 77.522 0 00-.836-.744 1.605 1.605 0 00-.134-.107.869.869 0 00-.384-.125.935.935 0 00-.403.042h-.002zm.632.322c.058.035.475.408.934.824a1735.151 1735.151 0 002.693 2.456c1.023.932 1.889 1.735 1.92 1.781l.044.06c.097.145.09.36.09 4.2 0 3.489-.005 3.989-.037 4.09a.672.672 0 01-.537.48c-.12.023-1.586.028-5.522.023l-5.364-.007-.126-.064a.887.887 0 01-.36-.398c-.042-.097-.044-.32-.051-4.052-.006-3.864-.01-4.09.087-4.258l.034-.056c.03-.05.228-.25.441-.441 2.311-2.11 4.958-4.519 5.029-4.577a.763.763 0 01.193-.115.697.697 0 01.532.054zm4.046 5.99l-2.22-2.029a1679.814 1679.814 0 00-2.143-1.948L9 4.095l-.034.03c-.136.12-.321.287-.524.47a726.79 726.79 0 01-2.32 2.12l-1.489 1.36v6.114h8.732V8.075zm-9.017 6.401V7.95l1.581-1.444 2.32-2.12c.407-.37.747-.671.756-.669.009.003 1.058.957 2.332 2.118L13.65 7.95v6.526H4.348z"/></symbol><symbol viewBox="0 0 18 18" id="import" xmlns="http://www.w3.org/2000/svg"><path d="M8.15 7.646L6.678 9.118a.85.85 0 01-1.202-1.202l2.923-2.923a.85.85 0 011.202 0l2.923 2.923a.85.85 0 11-1.202 1.202L9.85 7.646v8.075a.85.85 0 01-1.7 0V7.647zm-3.108 4.737a.65.65 0 110 1.3h-.993a2.65 2.65 0 01-2.65-2.65V4.078a2.65 2.65 0 012.65-2.65h9.902a2.65 2.65 0 012.65 2.65v6.955a2.65 2.65 0 01-2.65 2.65h-.917a.65.65 0 110-1.3h.917a1.35 1.35 0 001.35-1.35V4.078a1.35 1.35 0 00-1.35-1.35H4.049a1.35 1.35 0 00-1.35 1.35v6.955c0 .745.605 1.35 1.35 1.35h.993z"/></symbol><symbol viewBox="0 0 18 18" id="import-fill" xmlns="http://www.w3.org/2000/svg"><path d="M10 8.033v7.714a1 1 0 11-2 0V8.033L6.784 9.25A1 1 0 015.37 7.835l2.923-2.923a1 1 0 011.414 0l2.923 2.923a1 1 0 11-1.414 1.414L10 8.033zm-4.958 4.175a.85.85 0 010 1.7h-.993a2.85 2.85 0 01-2.85-2.85V4.104a2.85 2.85 0 012.85-2.85h9.902a2.85 2.85 0 012.85 2.85v6.954a2.85 2.85 0 01-2.85 2.85h-.917a.85.85 0 010-1.7h.917a1.15 1.15 0 001.15-1.15V4.104a1.15 1.15 0 00-1.15-1.15H4.049a1.15 1.15 0 00-1.15 1.15v6.954c0 .635.515 1.15 1.15 1.15h.993z"/></symbol><symbol viewBox="0 0 18 18" id="info" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3zm0-1.3a6.35 6.35 0 100-12.7 6.35 6.35 0 000 12.7zM9.596 4.5c.59 0 .884.41.884.88 0 .588-.512 1.131-1.179 1.131-.559 0-.884-.337-.869-.895 0-.47.388-1.116 1.164-1.116zm-1.815 9c-.466 0-.807-.293-.482-1.586l.535-2.291c.093-.366.108-.514 0-.514-.14 0-.744.253-1.102.503L6.5 9.216c1.132-.984 2.435-1.56 2.994-1.56.465 0 .543.573.31 1.453l-.612 2.409c-.108.425-.062.572.047.572.14 0 .597-.177 1.047-.543l.264.366C9.449 13.059 8.245 13.5 7.78 13.5z"/></symbol><symbol viewBox="0 0 18 18" id="info-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3zM9.596 4.5c-.776 0-1.164.646-1.164 1.116-.015.558.31.895.87.895.666 0 1.178-.543 1.178-1.13 0-.47-.295-.881-.884-.881zm-1.815 9c.465 0 1.668-.441 2.769-1.587l-.264-.367c-.45.367-.908.544-1.047.544-.11 0-.155-.147-.047-.572l.612-2.409c.233-.88.155-1.453-.31-1.453-.56 0-1.862.576-2.994 1.56l.232.396c.358-.25.962-.503 1.102-.503.108 0 .093.147 0 .514l-.535 2.291c-.325 1.293.016 1.586.482 1.586z"/></symbol><symbol viewBox="0 0 18 18" id="insights" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.774 11.382A6.02 6.02 0 008.616.68C5.607.87 3.173 3.32 2.999 6.33a6.009 6.009 0 002.255 5.062c.335.267.529.663.529 1.08 0 1.459 1.168 2.49 2.658 2.49h1.133c1.488 0 2.658-1.03 2.658-2.484 0-.423.197-.82.542-1.097zm.952-4.695a4.72 4.72 0 00-5.028-4.709c-2.352.15-4.265 2.074-4.401 4.428a4.709 4.709 0 001.768 3.97 2.685 2.685 0 011.018 2.098c0 .64.46 1.102 1.152 1.178L6.994 7.644a.65.65 0 011.273-.263l.74 3.584.74-3.584a.65.65 0 011.274.263L9.78 13.652c.692-.076 1.152-.537 1.152-1.173 0-.824.38-1.591 1.028-2.11a4.708 4.708 0 001.766-3.682z"/><path d="M10.28 17.544H7.734a.65.65 0 110-1.3h2.546a.65.65 0 110 1.3z"/></symbol><symbol viewBox="0 0 18 18" id="insights-fill" xmlns="http://www.w3.org/2000/svg"><path d="M15.019 6.689c0 1.848-.839 3.56-2.252 4.694a1.405 1.405 0 00-.542 1.097c0 1.409-1.097 2.42-2.518 2.482l1.502-7.276a.85.85 0 00-1.664-.344L9 9.978l-.544-2.636a.85.85 0 00-1.665.344l1.502 7.276c-1.422-.063-2.518-1.074-2.518-2.487 0-.417-.194-.814-.528-1.08A6.008 6.008 0 012.99 6.331C3.165 3.322 5.6.873 8.61.682a6.02 6.02 0 016.41 6.007zm-3.896 10.188c0 .47-.38.85-.85.85H7.727a.85.85 0 010-1.7h2.546c.47 0 .85.38.85.85z"/></symbol><symbol viewBox="0 0 18 18" id="install" xmlns="http://www.w3.org/2000/svg"><path d="M9.541 6.452l2.327-2.327a.65.65 0 11.92.92L9.35 8.48a.65.65 0 01-.92 0L4.996 5.044a.65.65 0 01.92-.919L8.24 6.452V1.527a.65.65 0 111.3 0v4.925z"/><path d="M2.61 15.567h12.86V9.282h-2.316a.65.65 0 010-1.3h2.966c.36 0 .65.29.65.65v7.586a.65.65 0 01-.65.65H1.96a.65.65 0 01-.65-.65V8.632a.65.65 0 01.65-.65h2.977a.65.65 0 010 1.3H2.61v6.285z"/><path d="M6.634 12.59a1.116 1.116 0 11-2.231 0 1.116 1.116 0 012.231 0z"/></symbol><symbol viewBox="0 0 18 18" id="install-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9.729 5.968l1.985-1.986a.85.85 0 111.202 1.202L9.48 8.621a.85.85 0 01-1.202 0L4.841 5.184a.85.85 0 111.203-1.202l1.985 1.985V1.525a.85.85 0 011.7 0v4.443z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M5.366 8.153a.65.65 0 00-.441-.173H1.949a.65.65 0 00-.65.65v7.586c0 .359.29.65.65.65h14.16a.65.65 0 00.65-.65V8.63a.65.65 0 00-.65-.65h-2.967a.65.65 0 00-.44.172l-3.232 2.98a.67.67 0 01-.88 0l-3.224-2.98zm1.36 4.43a1.276 1.276 0 11-2.553 0 1.276 1.276 0 012.552 0z"/></symbol><symbol viewBox="0 0 18 18" id="interfacedesigner" xmlns="http://www.w3.org/2000/svg"><path d="M3.269.868a.65.65 0 01-.65.65h-.797v.903a.65.65 0 11-1.3 0V.868a.65.65 0 01.65-.65H2.62a.65.65 0 01.65.65zm8.35-.65h3a.65.65 0 110 1.3h-3a.65.65 0 110-1.3z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M5.505 4.93h11.45c.36 0 .65.291.65.65v11.45a.65.65 0 01-.65.65H5.505a.65.65 0 01-.65-.65V5.58a.65.65 0 01.65-.65zm.65 11.45h10.15V6.23H6.155v10.15z"/><path d="M8.619.218h-3a.65.65 0 100 1.3h3a.65.65 0 000-1.3zM.522 5.421v3a.65.65 0 001.3 0v-3a.65.65 0 10-1.3 0zm0 9v-3a.65.65 0 111.3 0v3a.65.65 0 11-1.3 0z"/></symbol><symbol viewBox="0 0 18 18" id="interfacedesigner-fill" xmlns="http://www.w3.org/2000/svg"><path d="M2.417 2.145a1 1 0 000-2H1.37a1 1 0 00-1 1v.953a1 1 0 002 .047h.047zm3.5-2H8.23a1 1 0 110 2H5.917a1 1 0 110-2zm6.036 0h2.292a1 1 0 110 2h-2.292a1 1 0 110-2zM.37 8.298V5.64a1 1 0 112 0v2.658a1 1 0 11-2 0zm0 3.488V14.1a1 1 0 002 0v-2.313a1 1 0 10-2 0zm16.588-6.825H5.508a.65.65 0 00-.65.65v11.45c0 .36.29.65.65.65h11.45a.65.65 0 00.65-.65V5.611a.65.65 0 00-.65-.65z"/></symbol><symbol viewBox="0 0 18 18" id="invoices" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.334 3.858v.31c-2 .174-3.453 1.254-3.097 2.747.216.903 1.046 1.327 2.788 1.835.064.019.183.053.31.088v2.38c-1.09-.109-1.675-.482-1.888-1.054a.65.65 0 00-1.218.454c.416 1.12 1.47 1.763 3.105 1.904v.354a.65.65 0 001.3 0v-.349c2.001-.174 3.454-1.254 3.097-2.748-.215-.903-1.045-1.326-2.787-1.834a64.3 64.3 0 00-.31-.09v-2.38c1.09.11 1.675.483 1.888 1.055a.65.65 0 001.218-.453c-.417-1.12-1.47-1.763-3.106-1.905v-.314a.65.65 0 10-1.3 0zM6.502 6.614c-.115-.481.603-1.013 1.832-1.142v2.014c-1.177-.348-1.781-.659-1.832-.872zm3.132 4.609V9.209c1.178.347 1.782.658 1.833.871.114.481-.604 1.014-1.833 1.143z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M2.335 17.531a.65.65 0 01-.985-.557V1.042A.65.65 0 012 .392h13.969a.65.65 0 01.65.65v15.932a.65.65 0 01-.996.551l-2.16-1.354-1.794 1.326a.65.65 0 01-.756.012l-1.923-1.33-1.859 1.325a.65.65 0 01-.768-.01l-1.762-1.326-2.266 1.363zm.315-1.707l1.656-.996a.65.65 0 01.726.037l1.732 1.304 1.843-1.314a.65.65 0 01.747-.005l1.916 1.325 1.776-1.313a.65.65 0 01.732-.028l1.54.966V1.692H2.65v14.132z"/></symbol><symbol viewBox="0 0 18 18" id="invoices-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9.65 9.2v2.014c1.23-.13 1.947-.661 1.832-1.142-.05-.214-.655-.525-1.832-.872zm-1.3-3.737c-1.23.129-1.947.661-1.832 1.142.05.214.655.525 1.832.872V5.463z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M2.351 17.523a.65.65 0 01-.985-.557V1.033a.65.65 0 01.65-.65h13.968a.65.65 0 01.65.65v15.933a.65.65 0 01-.995.55l-2.16-1.354-1.794 1.326a.65.65 0 01-.756.012l-1.923-1.33-1.859 1.325a.65.65 0 01-.768-.01l-1.763-1.326-2.265 1.364zm7.3-5.005v.35a.65.65 0 11-1.301 0v-.355c-1.635-.141-2.689-.784-3.106-1.904a.65.65 0 111.219-.454c.212.572.798.946 1.887 1.055V8.83l-.31-.089C6.3 8.233 5.469 7.81 5.254 6.907 4.897 5.413 6.35 4.333 8.35 4.159v-.31a.65.65 0 111.3 0v.315c1.635.141 2.69.784 3.106 1.904a.65.65 0 11-1.218.454c-.213-.572-.799-.946-1.888-1.055v2.38l.31.089c1.741.508 2.572.932 2.787 1.834.356 1.494-1.096 2.574-3.097 2.748z"/></symbol><symbol viewBox="0 0 18 18" id="key" xmlns="http://www.w3.org/2000/svg"><path d="M8.288 13.5H6.636v.98l-1.494 1.495h-3.39v-2.97L5.99 8.767a5.238 5.238 0 113.516 3.516L8.288 13.5zm.886-2.724l.396.155a3.939 3.939 0 10-2.228-2.228l.155.396-4.444 4.444v1.132h1.55l.733-.733V12.2H7.75l1.424-1.424zm1.969-3.646a1.113 1.113 0 111.574-1.574 1.113 1.113 0 01-1.574 1.574z"/></symbol><symbol viewBox="0 0 18 18" id="key-fill" xmlns="http://www.w3.org/2000/svg"><path d="M8.418 13.37l-2-.089.045 1.373-1.156 1.155-3.554.166.219-3.19L5.99 8.768a5.238 5.238 0 113.516 3.516L8.418 13.37zm2.495-6.01a1.437 1.437 0 102.033-2.033 1.437 1.437 0 00-2.033 2.033z"/></symbol><symbol viewBox="0 0 18 18" id="leaf" xmlns="http://www.w3.org/2000/svg"><path d="M14.55 4.286c.842 0 1.117 1.963 1.117 2.531 0 4.187-4.384 6.375-7.442 6.375-1.903 0-3.497-.844-3.497-.844-.372 0-.82 1.366-1.467 1.366-.622 0-.928-.506-.928-.811 0-.697 1.473-1.238 1.473-1.626 0 0-.29-.445-.29-1.246 0-2.13 1.884-3.648 3.995-4.28 1.525-.455 4.77.075 5.803-.809.411-.343.611-.656 1.236-.656zm0-1.286c-1.2 0-1.733.656-2.108.97-.484.404-3.809.101-5.325.554-2.678.798-4.934 2.783-4.934 5.507 0 .346.04.649.098.908C1.606 11.435 1 12.024 1 12.903 1 13.955 1.939 15 3.264 15c.797 0 1.375-.477 1.83-1.095.998.356 2.064.573 3.131.573 3.522 0 8.775-2.51 8.775-7.661C17 5.162 16.303 3 14.55 3zm-8.72 8.07c1.4-1.8 3.173-2.592 5.714-2.413a.66.66 0 00.714-.595.652.652 0 00-.616-.688c-3.034-.214-5.23.804-6.878 2.922a.627.627 0 00.133.9.682.682 0 00.934-.126z"/></symbol><symbol viewBox="0 0 18 18" id="leaf-fill" xmlns="http://www.w3.org/2000/svg"><path d="M11.982 13.224c-1.205.554-2.552.882-3.91.882-2.282 0-4.195-1.028-4.195-1.028-.447 0-.983 1.664-1.758 1.664-.75 0-1.116-.616-1.116-.987 0-.849 1.766-1.51 1.766-1.982 0 0-.347-.543-.347-1.517 0-2.594 2.257-4.445 4.793-5.21 1.83-.555 5.72.089 6.96-.988.492-.415.734-.8 1.484-.8 1.008 0 1.338 2.39 1.338 3.084 0 2.843-1.513 5.293-5.015 6.882zm-7.061-1.938c1.763-2.304 4.012-3.3 7.156-3.075.244.018.458-.152.477-.377.02-.226-.164-.423-.408-.441-3.443-.246-5.995.869-7.95 3.422a.39.39 0 00.106.571c.2.131.477.088.619-.1z"/></symbol><symbol viewBox="0 0 18 18" id="location" xmlns="http://www.w3.org/2000/svg"><path d="M9 .832c3.207 0 5.8 2.594 5.8 5.8 0 .989-.29 2.096-.824 3.308-.463 1.05-1.098 2.155-1.862 3.288a34.503 34.503 0 01-2.632 3.406L9 17.168l-.482-.534a31.739 31.739 0 01-.827-.977 34.525 34.525 0 01-1.805-2.43c-.764-1.132-1.399-2.237-1.862-3.287C3.49 8.728 3.2 7.62 3.2 6.633A5.796 5.796 0 019 .832zm.3 14.005a33.241 33.241 0 001.737-2.336c.723-1.073 1.321-2.114 1.75-3.085.466-1.06.714-2.002.714-2.783A4.497 4.497 0 009 2.132a4.497 4.497 0 00-4.5 4.5c0 .782.247 1.723.714 2.784.428.971 1.026 2.012 1.75 3.085A33.244 33.244 0 009 15.2c.096-.114.196-.236.3-.364zM9 7.822a1.19 1.19 0 10-.001-2.38A1.19 1.19 0 009 7.822zm0 1.3a2.49 2.49 0 11.001-4.98A2.49 2.49 0 019 9.122z"/></symbol><symbol viewBox="0 0 18 18" id="location-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9 .832c3.207 0 5.8 2.594 5.8 5.8 0 .989-.29 2.096-.824 3.308-.463 1.05-1.098 2.155-1.862 3.288a34.501 34.501 0 01-2.632 3.406L9 17.168l-.482-.534a31.987 31.987 0 01-.827-.978 34.523 34.523 0 01-1.805-2.428c-.764-1.133-1.399-2.238-1.862-3.288C3.49 8.728 3.2 7.62 3.2 6.633A5.796 5.796 0 019 .832zm0 8.29a2.49 2.49 0 10-.001-4.98A2.49 2.49 0 009 9.122z"/></symbol><symbol viewBox="0 0 18 18" id="logout" xmlns="http://www.w3.org/2000/svg"><path d="M10.156 9.65a2.433 2.433 0 110-1.3h4.998l-1.267-1.267a.65.65 0 11.92-.919l2.376 2.376a.65.65 0 010 .92l-2.377 2.376a.65.65 0 11-.919-.92l1.267-1.266h-4.998zm1.387 3.901a.65.65 0 01.826 1.004 7.185 7.185 0 11.003-11.108.65.65 0 11-.826 1.004 5.885 5.885 0 10-.003 9.1zm-3.731-3.419a1.132 1.132 0 100-2.264 1.132 1.132 0 000 2.264z"/></symbol><symbol viewBox="0 0 18 18" id="logout-fill" xmlns="http://www.w3.org/2000/svg"><path d="M12.613 13.513a.85.85 0 00-1.197-.116 5.685 5.685 0 11.002-8.792.85.85 0 001.08-1.312 7.386 7.386 0 10-.002 11.417.85.85 0 00.117-1.197z"/><path d="M17.324 9.601l-2.376 2.376a.85.85 0 01-1.202-1.202l.925-.925h-4.367a2.633 2.633 0 110-1.7h4.367l-.925-.925a.85.85 0 111.202-1.202l2.376 2.376a.85.85 0 010 1.202z"/></symbol><symbol viewBox="0 0 18 18" id="logs" xmlns="http://www.w3.org/2000/svg"><path d="M9 17.15A8.15 8.15 0 119 .85a8.15 8.15 0 010 16.3zm0-1.3a6.85 6.85 0 100-13.7 6.85 6.85 0 000 13.7zM9.62 4a.65.65 0 00-1.3 0v5.402l3.553 1.776a.65.65 0 10.581-1.162L9.619 8.598V4z"/></symbol><symbol viewBox="0 0 18 18" id="logs-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9 17.15A8.15 8.15 0 119 .85a8.15 8.15 0 010 16.3zM9.62 4a.65.65 0 00-1.3 0v5.402l3.553 1.776a.65.65 0 10.581-1.162L9.619 8.598V4z"/></symbol><symbol viewBox="0 0 18 18" id="meta-engine" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M4 9a5.002 5.002 0 005 5 5 5 0 10-5-5zm5.506 1.653L8.37 12.697a3.751 3.751 0 01-.003-7.394L7.402 7.04a1.625 1.625 0 00.519 2.142l1.465.976a.375.375 0 01.12.495zm1.092.607l-.777 1.4a3.751 3.751 0 00-.04-7.329L8.494 7.647a.375.375 0 00.12.495l1.465.976c.705.47.93 1.402.52 2.142z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.5 1.375A5.125 5.125 0 001.375 6.5v5A5.125 5.125 0 006.5 16.625h5a5.125 5.125 0 005.125-5.125v-5A5.125 5.125 0 0011.5 1.375h-5zM2.625 6.5A3.875 3.875 0 016.5 2.625h5A3.875 3.875 0 0115.375 6.5v5a3.875 3.875 0 01-3.875 3.875h-5A3.875 3.875 0 012.625 11.5v-5z"/></symbol><symbol viewBox="0 0 18 18" id="meta-engine-fill" xmlns="http://www.w3.org/2000/svg"><path d="M7.736 13.839l.014.004A5.002 5.002 0 019.09 4L7.402 7.04a1.625 1.625 0 00.519 2.14l1.465.978a.375.375 0 01.12.494l-1.77 3.186z"/><path d="M14 9a5 5 0 01-4.924 5l1.522-2.74a1.625 1.625 0 00-.519-2.142l-1.465-.976a.375.375 0 01-.12-.495l1.915-3.446A5.002 5.002 0 0114 9z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.5 1.375A5.125 5.125 0 001.375 6.5v5A5.125 5.125 0 006.5 16.625h5a5.125 5.125 0 005.125-5.125v-5A5.125 5.125 0 0011.5 1.375h-5zM2.625 6.5A3.875 3.875 0 016.5 2.625h5A3.875 3.875 0 0115.375 6.5v5a3.875 3.875 0 01-3.875 3.875h-5A3.875 3.875 0 012.625 11.5v-5z"/></symbol><symbol viewBox="0 0 18 18" id="minimize" xmlns="http://www.w3.org/2000/svg"><path d="M6.39 1.35a.65.65 0 00-.65.65v.908a2.85 2.85 0 01-2.85 2.85H2a.65.65 0 100 1.3h.89a4.15 4.15 0 004.15-4.15V2a.65.65 0 00-.65-.65zm10.26 5.046a.65.65 0 00-.65-.65h-.796a2.85 2.85 0 01-2.85-2.85v-.895a.65.65 0 10-1.3 0v.895a4.15 4.15 0 004.15 4.15H16a.65.65 0 00.65-.65zM11.652 16.65a.65.65 0 00.65-.65v-.825a2.85 2.85 0 012.85-2.85H16a.65.65 0 100-1.3h-.847a4.15 4.15 0 00-4.15 4.15V16c0 .36.291.65.65.65zM2 12.299a.65.65 0 110-1.3h.894a4.15 4.15 0 014.15 4.15v.85a.65.65 0 11-1.3 0v-.85a2.85 2.85 0 00-2.85-2.85H2z"/></symbol><symbol viewBox="0 0 18 18" id="minimize-fill" xmlns="http://www.w3.org/2000/svg"><path d="M6.39 1.15a.85.85 0 00-.85.85v.909a2.65 2.65 0 01-2.65 2.65H2a.85.85 0 000 1.7h.89a4.35 4.35 0 004.35-4.35v-.91a.85.85 0 00-.85-.85zm10.46 5.247a.85.85 0 00-.85-.85h-.796a2.65 2.65 0 01-2.65-2.65V2a.85.85 0 00-1.7 0v.896a4.35 4.35 0 004.35 4.35H16a.85.85 0 00.85-.85zM11.652 16.85c.47 0 .85-.38.85-.85v-.825a2.65 2.65 0 012.65-2.65H16a.85.85 0 000-1.7h-.847a4.35 4.35 0 00-4.35 4.35V16c0 .47.38.85.85.85zM2 12.498a.85.85 0 110-1.7h.894a4.35 4.35 0 014.35 4.35V16a.85.85 0 11-1.7 0v-.851a2.65 2.65 0 00-2.65-2.65H2z"/></symbol><symbol viewBox="0 0 18 18" id="notifications" xmlns="http://www.w3.org/2000/svg"><path d="M8 2.363v-.438a1 1 0 112 0v.438a5.652 5.652 0 014.65 5.562v1.847l1.431 2.862a.65.65 0 01-.581.941h-13a.65.65 0 01-.581-.941l1.433-2.862-.002-1.847c0-2.78 2.007-5.09 4.65-5.562zM6.35 14.425h1.3a1.35 1.35 0 102.7 0h1.3a2.65 2.65 0 01-5.3 0zm-2.797-2.15h10.895l-1.03-2.06a.65.65 0 01-.068-.29v-2a4.35 4.35 0 00-8.7 0c0 .445 0 1.112.003 1.999a.65.65 0 01-.07.292l-1.03 2.059z"/></symbol><symbol viewBox="0 0 18 18" id="notifications-fill" xmlns="http://www.w3.org/2000/svg"><path d="M8 2.288V1.85a1 1 0 112 0v.438a5.652 5.652 0 014.65 5.562v1.847l1.431 2.862a.65.65 0 01-.581.941h-13a.65.65 0 01-.581-.941l1.433-2.862L3.35 7.85c0-2.78 2.007-5.09 4.65-5.562zM6.35 14.35h5.3a2.65 2.65 0 01-5.3 0z"/></symbol><symbol viewBox="0 0 18 18" id="overview" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.494 10.671l-.373-1.056-.822-2.323a306.07 306.07 0 00-1.214-3.4c-.428-1.05-1.43-1.752-2.564-1.752-1.529 0-2.76 1.264-2.778 2.82a4.026 4.026 0 00-1.49.045v-.01c0-1.572-1.24-2.855-2.78-2.855-1.132 0-2.135.702-2.563 1.752-.053.129-.48 1.327-1.208 3.383l-.828 2.34-.373 1.056.013.005a4.099 4.099 0 00-.176 1.192c0 2.2 1.731 3.992 3.878 3.992 2.08 0 3.77-1.684 3.872-3.79a3.02 3.02 0 01.206-.066c.534-.15 1.093-.171 1.615.006.073 2.134 1.775 3.85 3.875 3.85 2.147 0 3.878-1.792 3.878-3.992 0-.415-.062-.816-.177-1.194l.009-.003zM8.241 6.35a803.18 803.18 0 01-.027 1.922l-.008.574-.03 1.848a4.03 4.03 0 011.642-.049l-.029-1.799-.008-.574c-.012-.773-.02-1.44-.027-1.979-.477-.125-.978-.095-1.46.041l-.053.016zm2.85 2.647l-.01-.744c-.024-1.63-.038-2.787-.038-3.258 0-.863.667-1.554 1.478-1.554.595 0 1.128.373 1.36.943.04.097.498 1.382 1.187 3.326l.16.453a3.805 3.805 0 00-4.136.834zm-6.875-1.12c-.513 0-1.002.103-1.45.288l.156-.438a388.61 388.61 0 011.192-3.343c.232-.57.765-.943 1.36-.943.811 0 1.479.69 1.479 1.554 0 .47-.014 1.628-.038 3.258l-.012.739a3.805 3.805 0 00-2.687-1.114zm2.577 3.992c0 1.492-1.159 2.692-2.577 2.692-1.419 0-2.578-1.2-2.578-2.692 0-1.491 1.16-2.691 2.578-2.691s2.577 1.2 2.577 2.691zm9.569 0c0 1.492-1.16 2.692-2.578 2.692s-2.577-1.2-2.577-2.692c0-1.491 1.159-2.691 2.577-2.691 1.419 0 2.578 1.2 2.578 2.691z"/></symbol><symbol viewBox="0 0 18 18" id="overview-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M11.207 11.868c0-1.491 1.16-2.692 2.577-2.692 1.418 0 2.577 1.201 2.577 2.692 0 1.492-1.159 2.692-2.577 2.692s-2.577-1.2-2.577-2.692zm-3-3.023l.009-.574c.01-.748.02-1.391.026-1.921l.054-.017a2.77 2.77 0 011.459-.034l.027 1.972.009.574.028 1.811a4.011 4.011 0 00-1.641.048l.029-1.859zM1.64 11.868c0-1.491 1.159-2.692 2.577-2.692 1.419 0 2.578 1.201 2.578 2.692 0 1.492-1.16 2.692-2.578 2.692s-2.577-1.2-2.577-2.692zm15.753-1.487l-.271-.766-.822-2.324a330.378 330.378 0 00-1.213-3.399c-.428-1.05-1.431-1.752-2.565-1.752-1.534 0-2.767 1.273-2.777 2.835a4.02 4.02 0 00-1.492.043c0-1.595-1.239-2.878-2.778-2.878-1.134 0-2.136.702-2.564 1.752-.053.129-.48 1.327-1.208 3.383l-.827 2.34c-.16.449-.16.449-.271.766-.084.237-.265 1.072-.265 1.487 0 2.2 1.73 3.992 3.876 3.992 2.078 0 3.75-1.682 3.857-3.784.057-.021.127-.045.223-.072.539-.152 1.101-.16 1.627.023.083 2.125 1.768 3.833 3.862 3.833 2.147 0 3.877-1.792 3.877-3.992 0-.416-.186-1.25-.27-1.487z"/></symbol><symbol viewBox="0 0 18 18" id="payment" xmlns="http://www.w3.org/2000/svg"><path d="M11.869 12.137h-.604a.65.65 0 110-1.3h.604a.65.65 0 110 1.3z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.076 1.142l1.865 4.187h1.185a.65.65 0 01.65.65v2.362h.095a.65.65 0 01.65.65v4.992a.65.65 0 01-.65.65h-.095v2.283a.65.65 0 01-.65.65H1.654a.65.65 0 01-.65-.65V5.98a.65.65 0 01.65-.65h.42L12.218.813a.65.65 0 01.858.33zm2.4 13.49h-5.217a2.647 2.647 0 01-2.646-2.65v-.99a2.646 2.646 0 012.646-2.651h5.217V6.629H2.35a.678.678 0 01-.046.017v9.62h13.172v-1.633zM13.518 5.33H5.27l6.883-3.064 1.365 3.064zm-3.259 4.312c-.746 0-1.346.603-1.346 1.351v.99c0 .748.602 1.35 1.346 1.35h5.962V9.642h-5.962z"/></symbol><symbol viewBox="0 0 18 18" id="payment-fill" xmlns="http://www.w3.org/2000/svg"><path d="M11.864 12.353h-.604a.85.85 0 010-1.7h.604a.85.85 0 010 1.7z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16.771 8.334h.095c.36 0 .65.291.65.65v4.992a.65.65 0 01-.65.65h-.095v2.283a.65.65 0 01-.65.65H1.651a.65.65 0 01-.65-.65V5.972c0-.356.286-.644.641-.648a.533.533 0 00.04-.03.316.316 0 01.072-.05L12.132.623a.85.85 0 011.123.43l1.9 4.268h.966c.36 0 .65.291.65.65v2.362zM5.758 5.322h7.536l-1.247-2.8-6.289 2.8zm4.497 4.312c-.747 0-1.347.602-1.347 1.351v.99c0 .748.602 1.351 1.347 1.351h5.961V9.634h-5.96z"/></symbol><symbol viewBox="0 0 18 18" id="payment_alt" xmlns="http://www.w3.org/2000/svg"><path d="M2.006 2.51h11.78a.65.65 0 010 1.3H2.006a.353.353 0 00-.353.346v7.402a.65.65 0 11-1.3 0V4.156c0-.906.742-1.646 1.653-1.646zm11.449 10.434h1.334a.65.65 0 000-1.3h-1.334a.65.65 0 100 1.3zm-2.803 0H9.318a.65.65 0 010-1.3h1.334a.65.65 0 110 1.3z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M4.744 5.312c-.912 0-1.65.742-1.65 1.655v7.063c0 .914.738 1.655 1.65 1.655h11.447c.912 0 1.65-.742 1.65-1.655V6.967c0-.913-.738-1.655-1.65-1.655H4.744zm-.35 4.418v4.3c0 .197.158.356.35.356h11.447c.193 0 .35-.159.35-.356v-4.3H4.394zm0-1.3h12.147V6.967a.353.353 0 00-.35-.355H4.744a.353.353 0 00-.35.355V8.43z"/></symbol><symbol viewBox="0 0 18 18" id="payment_alt-fill" xmlns="http://www.w3.org/2000/svg"><path d="M2.009 2.312h11.78a.85.85 0 110 1.7H2.01c-.083 0-.153.07-.153.146v7.402a.85.85 0 01-1.7 0V4.158c0-1.016.832-1.846 1.853-1.846z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M3.097 6.97c0-.914.738-1.656 1.65-1.656h11.447c.913 0 1.65.742 1.65 1.656v7.062c0 .914-.738 1.656-1.65 1.656H4.747c-.912 0-1.65-.742-1.65-1.656V6.97zm1.567 2.963h11.65v-1.7H4.664v1.7zm10.128 3.429h-1.334a.85.85 0 010-1.7h1.334a.85.85 0 110 1.7zm-5.471 0h1.334a.85.85 0 000-1.7H9.32a.85.85 0 100 1.7z"/></symbol><symbol viewBox="0 0 18 18" id="plan" xmlns="http://www.w3.org/2000/svg"><path d="M8.69 10.18h4.082a.65.65 0 000-1.3H8.69a.65.65 0 100 1.3zm4.081 3.802h-4.08a.65.65 0 110-1.3h4.08a.65.65 0 110 1.3zM5.079 10.18h.694a.65.65 0 000-1.3h-.694a.65.65 0 100 1.3zm.694 3.802h-.694a.65.65 0 110-1.3h.694a.65.65 0 110 1.3z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M9 .13c1.127 0 2.077.76 2.363 1.797h1.447a.65.65 0 01.628.482l.108.403h1.937a.65.65 0 01.65.65v13.686a.65.65 0 01-.65.65H2.518a.65.65 0 01-.65-.65V3.462a.65.65 0 01.65-.65h1.936l.108-.403a.65.65 0 01.628-.482h1.447A2.452 2.452 0 019 .13zm5.285 5.447l-.392-1.465h.94v12.386H3.168V4.112h.939l-.392 1.465a.65.65 0 00.628.818h9.314a.65.65 0 00.628-.818zm-4.134-2.999a.65.65 0 00.65.65h1.51l.5 1.867H5.19l.499-1.868h1.51a.65.65 0 00.65-.649 1.151 1.151 0 012.302 0z"/></symbol><symbol viewBox="0 0 18 18" id="plan-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.772 10.38H8.69a.85.85 0 010-1.7h4.08a.85.85 0 010 1.7zm0 3.801H8.69a.85.85 0 110-1.7h4.08a.85.85 0 010 1.7zm-7-3.801H5.08a.85.85 0 010-1.7h.694a.85.85 0 110 1.7zm0 3.801H5.08a.85.85 0 110-1.7h.694a.85.85 0 110 1.7zM5.69 3.227H7.2a.65.65 0 00.65-.649 1.15 1.15 0 012.303 0 .65.65 0 00.65.649h1.51l.499 1.868H5.19l.499-1.868zm9.794-.415h-1.936l-.108-.403a.65.65 0 00-.628-.482h-1.448a2.451 2.451 0 00-4.725 0H5.19a.65.65 0 00-.628.482l-.107.403H2.518a.65.65 0 00-.65.65v13.686c0 .359.29.65.65.65h12.965a.65.65 0 00.65-.65V3.462a.65.65 0 00-.65-.65z"/></symbol><symbol viewBox="0 0 18 18" id="plus" xmlns="http://www.w3.org/2000/svg"><path d="M9.801 8.113l5.237.001c1.133 0 1.133 1.7 0 1.7l-5.236-.001.001 5.235a.85.85 0 01-1.7 0l-.001-5.236-5.065-.002c-1.133 0-1.132-1.7.001-1.7l5.063.002L8.1 3.049a.85.85 0 011.7 0l.002 5.064z"/></symbol><symbol viewBox="0 0 18 18" id="plus-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9.957 7.957l5.086.002a1 1 0 110 2l-5.086-.002.002 5.086a1 1 0 11-2 0l-.002-5.087-4.914-.001a1 1 0 110-2l4.914.001-.002-4.913a1 1 0 112 0l.002 4.914z"/></symbol><symbol viewBox="0 0 18 18" id="proximity" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.75a7.75 7.75 0 110-15.5 7.75 7.75 0 010 15.5zm0-1.3a6.45 6.45 0 100-12.9 6.45 6.45 0 000 12.9zm0-1.753a4.697 4.697 0 110-9.394 4.697 4.697 0 010 9.394zm0-1.3a3.397 3.397 0 100-6.794 3.397 3.397 0 000 6.794zm0-2.045a1.352 1.352 0 110-2.704 1.352 1.352 0 010 2.704z"/></symbol><symbol viewBox="0 0 18 18" id="proximity-fill" xmlns="http://www.w3.org/2000/svg"><path d="M8.95 16.9a7.95 7.95 0 110-15.9 7.95 7.95 0 010 15.9zm0-1.7a6.25 6.25 0 100-12.5 6.25 6.25 0 000 12.5zm0-1.353a4.897 4.897 0 110-9.794 4.897 4.897 0 010 9.794zm0-1.7a3.197 3.197 0 100-6.394 3.197 3.197 0 000 6.394zm0-1.267a1.93 1.93 0 110-3.86 1.93 1.93 0 010 3.86z"/></symbol><symbol viewBox="0 0 18 18" id="query_tester" xmlns="http://www.w3.org/2000/svg"><path d="M13.934 17.032H4.065c-1.748 0-2.74-2.006-1.677-3.398L6.856 7.81l.05-5.498H6.24a.365.365 0 01-.365-.365v-.614A.366.366 0 016.24.968h5.521c.2 0 .363.164.364.365v.615a.365.365 0 01-.365.364l-.617-.004-.01 5.47 4.479 5.857c1.062 1.392.072 3.397-1.678 3.397zM3.285 15.306a.87.87 0 00.781.483h9.87a.868.868 0 00.69-1.397l-4.608-6.027a.638.638 0 01-.117-.348v-5.71h-1.75L8.1 8.02a.637.637 0 01-.114.342l-4.612 6.03a.868.868 0 00-.09.915z"/></symbol><symbol viewBox="0 0 18 18" id="query_tester-fill" xmlns="http://www.w3.org/2000/svg"><path d="M13.97 17.038H4.03c-1.719 0-2.694-1.972-1.65-3.34L6.892 7.8V3.29h4.217V7.8l4.51 5.898c1.046 1.368.073 3.34-1.648 3.34zM6.22 2.473a.317.317 0 01-.317-.317V1.28c0-.175.142-.317.317-.317h5.56c.174 0 .317.142.317.317v.877a.317.317 0 01-.317.317H6.22z"/></symbol><symbol viewBox="0 0 18 18" id="restore" xmlns="http://www.w3.org/2000/svg"><path d="M9.648 5.764l.763 1.738a.65.65 0 11-1.19.523L7.726 4.62l2.998-2.21a.65.65 0 01.772 1.046L10.06 4.515A5.652 5.652 0 019 15.716a5.65 5.65 0 01-5.65-5.65.65.65 0 011.3 0 4.35 4.35 0 104.998-4.302z"/></symbol><symbol viewBox="0 0 18 18" id="restore-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9.98 6.029l.613 1.396a.85.85 0 01-1.556.684l-1.56-3.55 3.127-2.306a.85.85 0 011.01 1.369l-1.079.794a5.85 5.85 0 11-7.385 5.646.85.85 0 111.7 0A4.15 4.15 0 109.98 6.03z"/></symbol><symbol viewBox="0 0 18 18" id="result-settings" xmlns="http://www.w3.org/2000/svg"><path d="M14.625 7.931l-.182-.404-.225-.503-.529-.123a5.672 5.672 0 00-.189-.04V2.25H2.25v12.375h4.905c.177.398.4.776.664 1.125H1.125V1.125h13.5v6.806z"/><path d="M5.625 5.625h6.749V4.5H5.625v1.125zm-2.25 0H4.5V4.5H3.375v1.125zm0 3.375H4.5V7.875H3.375V9zm6.775-1.125l-.169.375-.83-.088-.524-.056-.372.384a5.77 5.77 0 00-.439.51H5.625V7.875h4.525zM6.77 11.25l-.02.063.344.462.45.6h-1.92V11.25h1.144zm-3.395 1.125H4.5V11.25H3.375v1.125z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.466 7.998a4.886 4.886 0 00-2.183 0l-.667 1.454-1.65-.17a4.44 4.44 0 00-1.091 1.81l.98 1.283-.979 1.283a4.449 4.449 0 001.09 1.81l1.65-.17.668 1.454a4.918 4.918 0 002.183 0l.669-1.454 1.648.17c.25-.254.47-.537.656-.843.183-.304.33-.628.435-.966l-.98-1.284.979-1.283a4.435 4.435 0 00-1.09-1.81l-1.648.17-.67-1.454zm-.645 5.432a1.125 1.125 0 11-.789-2.108 1.125 1.125 0 01.789 2.108z"/></symbol><symbol viewBox="0 0 18 18" id="result-settings-fill" xmlns="http://www.w3.org/2000/svg"><path d="M6.638 13.387l.787-1.012h-1.8V11.25h1.013l.112-.45c.225-.675.563-1.238 1.013-1.8H5.625V7.875h4.5l.338-.9.562-.112c.45-.113.9-.113 1.35-.113.45 0 .9 0 1.35.112l.563.113.337.9v-6.75h-13.5V15.75h6.638c-.45-.563-.675-1.125-.9-1.8l-.226-.563zM5.625 4.5h6.75v1.125h-6.75V4.5zM4.5 12.375H3.375V11.25H4.5v1.125zM4.5 9H3.375V7.875H4.5V9zm0-3.375H3.375V4.5H4.5v1.125zm11.363 6.75l1.012-1.238a4.404 4.404 0 00-1.125-1.8l-1.688.226-.562-1.576c-.338-.112-.787-.112-1.125-.112-.338 0-.787 0-1.125.112l-.675 1.463L9 9.225c-.45.563-.9 1.125-1.125 1.8l1.012 1.35-1.012 1.238c.225.675.563 1.35 1.125 1.8l1.688-.226.675 1.463a6.81 6.81 0 002.137 0l.675-1.462 1.688.224c.224-.225.45-.562.675-.9.224-.337.337-.675.45-1.012l-1.125-1.125zM12.375 13.5c-.563 0-1.012-.45-1.125-1.125 0-.675.45-1.125 1.125-1.125h.113c.675 0 1.125.563 1.125 1.125-.113.675-.563 1.125-1.238 1.125z"/></symbol><symbol viewBox="0 0 18 18" id="result_ranking" xmlns="http://www.w3.org/2000/svg"><path d="M12.893 5.515a.65.65 0 01-.92 0L9.647 3.188v4.97h3.902a.65.65 0 110 1.3H9.647v2.7h3.902a.65.65 0 110 1.3H9.647v2.7h7.61a.65.65 0 010 1.3H.736a.65.65 0 010-1.3h7.61v-2.7H4.444a.65.65 0 010-1.3h3.903v-2.7H4.444a.65.65 0 110-1.3h3.903v-4.97L6.02 5.515a.65.65 0 11-.92-.92L8.538 1.16a.65.65 0 01.92 0l3.436 3.436a.65.65 0 010 .92z"/></symbol><symbol viewBox="0 0 18 18" id="result_ranking-fill" xmlns="http://www.w3.org/2000/svg"><path d="M13.135 5.81a1 1 0 01-1.414 0l-1.73-1.73v3.926h3.553a.85.85 0 110 1.7H9.992v2.3h3.552a.85.85 0 110 1.7H9.992v2.15h6.991a1 1 0 010 2H1a1 1 0 010-2h6.992v-2.15H4.439a.85.85 0 010-1.7h3.553v-2.3H4.439a.85.85 0 010-1.7h3.553V4.08l-1.73 1.73a1 1 0 01-1.414-1.415L8.285.96a1 1 0 011.414 0l3.436 3.436a1 1 0 010 1.414z"/></symbol><symbol viewBox="0 0 18 18" id="search" xmlns="http://www.w3.org/2000/svg"><path d="M10.505 12.28a4.99 4.99 0 100-9.98 4.99 4.99 0 000 9.98zm-3.973-.113a.66.66 0 01-.062.073L2.11 16.6a.65.65 0 11-.92-.92l4.36-4.36a.65.65 0 01.074-.063 6.29 6.29 0 11.909.91z"/></symbol><symbol viewBox="0 0 18 18" id="search-fill" xmlns="http://www.w3.org/2000/svg"><path d="M10.708 11.885a4.59 4.59 0 100-9.18 4.59 4.59 0 000 9.18zm-3.816.411a.855.855 0 01-.078.09l-4.36 4.36a.85.85 0 11-1.202-1.202l4.36-4.36a.848.848 0 01.09-.079 6.29 6.29 0 111.19 1.191z"/></symbol><symbol viewBox="0 0 18 18" id="security" xmlns="http://www.w3.org/2000/svg"><path d="M9 8.902c.8 0 1.5.7 1.5 1.5 0 .6-.4 1.2-.9 1.4l.8 2.6H7.7l.8-2.6c-.6-.2-1-.7-1-1.4 0-.8.7-1.5 1.5-1.5z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M12.6 3.902v2.8c1.6 1.1 2.5 2.9 2.5 4.9 0 3.4-2.7 6.1-6.1 6.1-3.4 0-6.1-2.7-6.1-6.1 0-2 1-3.8 2.5-4.9v-2.8c0-2 1.6-3.7 3.6-3.6 2 0 3.6 1.6 3.6 3.6zM9 1.602c-1.3 0-2.3 1-2.3 2.3v2.1c.7-.3 1.5-.5 2.3-.5.8 0 1.6.2 2.3.5v-2.1c0-1.3-1-2.3-2.3-2.3zm-4.8 10.1c0 2.6 2.1 4.8 4.8 4.8 2.7 0 4.8-2.2 4.8-4.8 0-2.6-2.2-4.8-4.8-4.8-2.6 0-4.8 2.1-4.8 4.8z"/></symbol><symbol viewBox="0 0 18 18" id="security-fill" xmlns="http://www.w3.org/2000/svg"><path d="M11.144 3.982v.856a7.21 7.21 0 011.7.78V3.981A3.84 3.84 0 009 .148a3.84 3.84 0 00-3.845 3.834v1.636a7.205 7.205 0 011.7-.78v-.856A2.14 2.14 0 019 1.848a2.14 2.14 0 012.144 2.134z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M2.864 11.734c0 3.38 2.748 6.118 6.136 6.118s6.136-2.738 6.136-6.118c0-3.38-2.748-6.119-6.136-6.119s-6.136 2.74-6.136 6.119zm4.828 2.746l.813-2.572a1.503 1.503 0 01.501-2.92 1.503 1.503 0 11.54 2.905l.812 2.587H7.692z"/></symbol><symbol viewBox="0 0 18 18" id="settings" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M11.955 8.947a2.987 2.987 0 11-5.973 0 2.987 2.987 0 015.973 0zM8.968 7.261a1.687 1.687 0 110 3.373 1.687 1.687 0 010-3.373z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.818 1.975V.212h2.3v1.763a7.028 7.028 0 012.967 1.23l1.247-1.247 1.626 1.626-1.247 1.247a7.03 7.03 0 011.211 2.862h1.781v2.3h-1.746a7.027 7.027 0 01-1.246 3.07l1.247 1.247-1.626 1.627-1.247-1.247a7.028 7.028 0 01-2.967 1.229v1.763h-2.3v-1.763a7.027 7.027 0 01-2.966-1.23l-1.247 1.248L1.98 14.31l1.247-1.247a7.027 7.027 0 01-1.246-3.07H.234v-2.3h1.78A7.028 7.028 0 013.226 4.83L1.979 3.584l1.626-1.626 1.247 1.247a7.027 7.027 0 012.966-1.23zm1.15 1.207a5.765 5.765 0 110 11.53 5.765 5.765 0 010-11.53z"/></symbol><symbol viewBox="0 0 18 18" id="settings-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.915 7.694a7.028 7.028 0 00-1.212-2.861l1.247-1.247-1.626-1.627-1.247 1.247a7.027 7.027 0 00-2.966-1.229V.214h-2.3v1.763a7.027 7.027 0 00-2.966 1.23L3.598 1.958 1.97 3.586l1.247 1.247a7.027 7.027 0 00-1.211 2.861H.227v2.3h1.746a7.027 7.027 0 001.245 3.071l-1.247 1.247 1.627 1.627 1.247-1.248a7.028 7.028 0 002.966 1.23v1.763h2.3V15.92a7.029 7.029 0 002.966-1.23l1.247 1.247 1.627-1.626-1.248-1.247a7.025 7.025 0 001.246-3.07h1.747v-2.3h-1.781zM8.96 11.935a2.986 2.986 0 100-5.973 2.986 2.986 0 000 5.973z"/></symbol><symbol viewBox="0 0 18 18" id="show" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.117 10.412a16.614 16.614 0 00.684-.901.65.65 0 000-.729 16.577 16.577 0 00-.684-.901 18.45 18.45 0 00-1.835-1.948c-1.977-1.808-4.09-2.905-6.28-2.905-2.188 0-4.302 1.097-6.279 2.905A18.427 18.427 0 00.387 8.526a9.12 9.12 0 00-.183.256.65.65 0 000 .729 16.562 16.562 0 00.684.901 18.428 18.428 0 001.835 1.948c1.977 1.809 4.09 2.905 6.28 2.905 2.188 0 4.302-1.097 6.279-2.905a18.45 18.45 0 001.835-1.948zm-2.713-3.52a17.136 17.136 0 012.055 2.254 17.142 17.142 0 01-2.055 2.255c-1.76 1.61-3.599 2.564-5.402 2.564-1.802 0-3.641-.954-5.401-2.564a17.156 17.156 0 01-2.055-2.255A17.15 17.15 0 013.6 6.891c1.76-1.608 3.6-2.562 5.402-2.562 1.803 0 3.642.954 5.402 2.564zm-5.401 5.945a3.69 3.69 0 110-7.38 3.69 3.69 0 010 7.38zm2.39-3.69a2.39 2.39 0 11-4.78 0 2.39 2.39 0 014.78 0z"/></symbol><symbol viewBox="0 0 18 18" id="show-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.706 9.8c.088-.12.149-.207.182-.256a.65.65 0 000-.728 16.584 16.584 0 00-.684-.901 18.45 18.45 0 00-1.835-1.95c-1.976-1.807-4.09-2.904-6.279-2.904S4.788 4.158 2.811 5.966A18.427 18.427 0 00.475 8.559c-.088.12-.15.207-.183.257a.65.65 0 000 .728 16.564 16.564 0 00.684.901 18.429 18.429 0 001.835 1.949c1.977 1.808 4.09 2.904 6.28 2.904 2.188 0 4.302-1.096 6.279-2.904A18.451 18.451 0 0017.706 9.8zM5.4 9.18a3.69 3.69 0 107.38 0 3.69 3.69 0 00-7.38 0z"/></symbol><symbol viewBox="0 0 18 18" id="source" xmlns="http://www.w3.org/2000/svg"><path d="M9.093 2.637a5.49 5.49 0 00-5.415 4.59 3.2 3.2 0 00.254 6.388h1.555a.5.5 0 000-1H3.932a2.2 2.2 0 11.153-4.394.5.5 0 00.533-.459 4.49 4.49 0 018.586-1.442.5.5 0 00.4.296 3.01 3.01 0 01-.346 5.999h-1.514a.5.5 0 000 1h1.514A4.01 4.01 0 0014 5.665a5.489 5.489 0 00-4.908-3.029v.001z"/><path d="M11.55 9.313H9.4a.188.188 0 01-.174-.26l1.342-3.285c.045-.108-.097-.195-.173-.106l-4.247 4.914a.122.122 0 00.092.201h1.998c.135 0 .226.137.174.26L6.893 14.69c-.045.108.097.196.173.107l4.577-5.282a.122.122 0 00-.093-.202z"/></symbol><symbol viewBox="0 0 18 18" id="star" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.281 6.792H11.38L9.767 2.435a.82.82 0 00-1.535-.002L6.608 6.792h-3.89a.822.822 0 00-.494 1.474l3.313 2.513-1.59 4.21a.817.817 0 001.26.945L9 13.057l3.806 2.877a.815.815 0 00.787.111.82.82 0 00.47-1.058l-1.6-4.209 3.311-2.512a.82.82 0 00-.494-1.474zm-4.668 1.1h3.836l-3.306 2.507 1.547 4.068L9 11.677l-3.68 2.79L6.857 10.4 3.55 7.892h3.82l1.627-4.364 1.615 4.364z"/></symbol><symbol viewBox="0 0 18 18" id="star-fill" xmlns="http://www.w3.org/2000/svg"><path d="M15.281 6.792H11.38L9.767 2.435a.82.82 0 00-1.535-.002L6.608 6.792h-3.89a.822.822 0 00-.494 1.474l3.313 2.513-1.59 4.21a.818.818 0 001.26.945L9 13.057l3.806 2.878a.82.82 0 001.258-.947l-1.601-4.21 3.311-2.512a.82.82 0 00-.494-1.474z"/></symbol><symbol viewBox="0 0 18 18" id="success" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3zm0-1.3a6.35 6.35 0 100-12.7 6.35 6.35 0 000 12.7zm-1.446-4.947l4.296-4.298a.75.75 0 011.06 1.06l-4.825 4.829a.75.75 0 01-1.061 0L5.09 10.058a.75.75 0 011.06-1.06l1.404 1.405z"/></symbol><symbol viewBox="0 0 18 18" id="success-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3zm-1.446-6.247L6.152 8.998a.75.75 0 00-1.061 1.06l1.934 1.936a.75.75 0 001.061 0l4.825-4.829a.75.75 0 10-1.06-1.06l-4.295 4.298z"/></symbol><symbol viewBox="0 0 18 18" id="support" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.455 9.167c0-.857-.126-1.684-.36-2.466L17 6.347l-.017.002a8.65 8.65 0 00-5.33-5.33l.001-.017-.352-.096a8.627 8.627 0 00-2.473-.36c-.86 0-1.692.126-2.475.36l-.351.096.002.016A8.65 8.65 0 00.673 6.35l-.016-.002-.096.35a8.626 8.626 0 00-.36 2.476c0 .86.125 1.691.36 2.475l.096.35.016-.001a8.65 8.65 0 005.33 5.33l-.001.017.36.099a8.612 8.612 0 002.709.354 8.61 8.61 0 002.224-.355l.358-.098-.002-.017a8.65 8.65 0 005.331-5.33l.017.002.097-.356c.233-.78.358-1.608.359-2.464v-.012zM6.17 16.004a7.35 7.35 0 01-4.174-4.175l3.807-.482c.235.327.522.614.85.85l-.483 3.807zm1.446-4.73a2.435 2.435 0 01-.887-.885l-.035-.063a2.414 2.414 0 01-.292-1.151v-.002c0-.422.109-.819.299-1.164l.027-.05c.213-.368.52-.675.889-.887l.045-.025.004-.003.005-.002a2.411 2.411 0 011.156-.293c.418 0 .812.106 1.155.293l.01.005.05.028c.365.212.669.516.881.88l.03.054c.19.345.298.742.298 1.164v.001c0 .393-.094.763-.26 1.091l-.025.048-.003.005-.003.006-.008.014-.027.05c-.213.367-.52.674-.888.886l-.046.025-.004.003-.005.003a2.413 2.413 0 01-1.28.29 2.412 2.412 0 01-1.031-.29l-.005-.003-.004-.003-.046-.025zM5.804 6.999l-3.807-.482A7.35 7.35 0 016.17 2.342l.482 3.807a3.747 3.747 0 00-.85.85zm6.047 4.349l3.807.481a7.35 7.35 0 01-4.174 4.175l-.482-3.807c.327-.236.614-.523.85-.85zm3.808-4.831l-3.808.482a3.746 3.746 0 00-.85-.85l.483-3.807a7.35 7.35 0 014.175 4.175zM8.828 5.449c-.32 0-.635.04-.938.12l-.454-3.59a7.316 7.316 0 012.783 0l-.454 3.59a3.722 3.722 0 00-.937-.12zm0 7.448c.32 0 .634-.04.937-.12l.454 3.59a7.317 7.317 0 01-2.783 0l.454-3.59c.303.08.618.12.938.12zm3.604-2.786a3.723 3.723 0 000-1.875l3.59-.455a7.31 7.31 0 010 2.784l-3.59-.454zm-7.21-1.875a3.72 3.72 0 000 1.875l-3.588.454a7.31 7.31 0 010-2.784l3.589.455z"/></symbol><symbol viewBox="0 0 18 18" id="support-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M11.457 15.793l-.427-3.373a3.942 3.942 0 001.044-1.044l3.374.427a7.143 7.143 0 01-3.991 3.99zm-9.25-3.99l3.374-.427c.279.41.633.765 1.044 1.044l-.427 3.373a7.143 7.143 0 01-3.991-3.99zm3.991-9.25l.427 3.373A3.942 3.942 0 005.581 6.97l-3.374-.427a7.143 7.143 0 013.991-3.99zm2.629 8.844a2.224 2.224 0 110-4.449 2.224 2.224 0 010 4.449zm6.621-4.854l-3.374.427a3.942 3.942 0 00-1.044-1.044l.427-3.373a7.143 7.143 0 013.991 3.99zM8.827.346a8.827 8.827 0 000 17.654 8.827 8.827 0 100-17.654z"/></symbol><symbol viewBox="0 0 18 18" id="supportforum" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M.8 12.266a.65.65 0 00.842.8l2.676-.967c.687 2.559 3.362 4.439 6.52 4.439.837 0 1.653-.132 2.417-.385l3.286 1.187a.65.65 0 00.843-.8l-.833-2.749c.634-.89.978-1.917.978-2.99 0-2.214-1.447-4.114-3.557-5.072-.456-2.826-3.282-4.94-6.627-4.94C3.672.789.655 3.33.655 6.526c0 1.074.343 2.102.977 2.99l-.833 2.75zm10.038-7.203c-3.664 0-6.677 2.53-6.69 5.715l-2.142.774.966-1.976a.65.65 0 00-.117-.597c-.586-.724-.901-1.57-.901-2.453 0-2.424 2.391-4.438 5.39-4.438 2.439 0 4.492 1.337 5.161 3.154a7.769 7.769 0 00-1.667-.18zm4.49 8.19a.65.65 0 00-.117.598l.553 1.826-2.285-.825a.65.65 0 00-.445.001 6.348 6.348 0 01-2.196.385c-3 0-5.39-2.014-5.39-4.438s2.39-4.437 5.39-4.437c3 0 5.391 2.013 5.391 4.437 0 .883-.315 1.729-.901 2.453z"/></symbol><symbol viewBox="0 0 18 18" id="supportforum-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.019 8.827c-.558-.69-.856-1.491-.856-2.327 0-2.305 2.294-4.238 5.19-4.238 2.31 0 4.216 1.237 4.901 2.904a7.824 7.824 0 00-1.407-.13c-3.58 0-6.53 2.417-6.677 5.498l-1.436.518.438-1.444a.852.852 0 00-.153-.781zm13.541 4.938c.634-.89.977-1.918.977-2.992 0-2.135-1.351-3.974-3.342-4.962C13.798 2.829 10.863.56 7.353.56 3.577.562.463 3.186.463 6.5c0 1.083.337 2.122.958 3.026L.616 12.18a.85.85 0 001.103 1.046l2.671-.966c.767 2.462 3.378 4.25 6.457 4.25.836 0 1.653-.131 2.416-.386l3.286 1.188a.65.65 0 00.843-.8l-.832-2.749z"/></symbol><symbol viewBox="0 0 18 18" id="synonyms" xmlns="http://www.w3.org/2000/svg"><path d="M5.477 4.69c-1.1-.043-2.176.7-3.365 2.596a.65.65 0 01-1.101-.69c1.413-2.255 2.883-3.27 4.518-3.204 1.214.048 2.125.522 3.977 1.812l.075.052c3.175 2.212 4.387 2.352 6.33-.339a.65.65 0 111.054.761c-2.48 3.436-4.447 3.209-8.128.645l-.074-.052c-1.64-1.142-2.415-1.546-3.286-1.58zm0 6.35c-1.1-.043-2.176.7-3.365 2.596a.65.65 0 01-1.101-.69c1.413-2.255 2.883-3.27 4.518-3.204 1.214.048 2.125.522 3.977 1.812l.075.052c3.175 2.212 4.387 2.352 6.33-.338a.65.65 0 111.054.76c-2.48 3.436-4.447 3.209-8.128.645l-.074-.052c-1.64-1.142-2.415-1.546-3.286-1.58z"/></symbol><symbol viewBox="0 0 18 18" id="synonyms-fill" xmlns="http://www.w3.org/2000/svg"><path d="M5.463 5.04c-.956-.038-1.926.632-3.054 2.432A1 1 0 11.714 6.41c1.474-2.35 3.05-3.439 4.828-3.368 1.307.052 2.255.546 4.164 1.875l.075.052c3.039 2.117 4.048 2.234 5.847-.256a1 1 0 011.621 1.17c-2.626 3.637-4.795 3.386-8.612.727l-.074-.052c-1.582-1.102-2.321-1.486-3.1-1.517zm0 6.35c-.956-.037-1.926.632-3.054 2.432A1 1 0 01.714 12.76c1.474-2.35 3.05-3.439 4.828-3.368 1.307.052 2.255.546 4.164 1.875l.075.052c3.039 2.117 4.048 2.234 5.847-.256a1 1 0 011.621 1.17c-2.626 3.637-4.795 3.386-8.612.727l-.074-.051c-1.582-1.103-2.321-1.487-3.1-1.518z"/></symbol><symbol viewBox="0 0 18 18" id="team" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.457 3.734a2.8 2.8 0 11-5.6 0 2.8 2.8 0 015.6 0zm-2.8-1.5a1.5 1.5 0 110 3 1.5 1.5 0 010-3zM1.41 14.7h5.885l-.104 1.298a.65.65 0 00.648.702h8.494a.65.65 0 00.648-.702l-.19-2.364c-.189-2.366-2.105-3.733-4.705-3.733a6.12 6.12 0 00-2.079.34c-.7-1.51-2.328-2.34-4.35-2.34-2.6 0-4.516 1.367-4.705 3.733l-.19 2.364a.65.65 0 00.649.702zm4.247-5.5c-1.981 0-3.28.928-3.41 2.537L2.116 13.4h5.29c.144-1.085.664-1.946 1.452-2.541C8.4 9.8 7.238 9.2 5.657 9.2zm6.43 2c1.98 0 3.28.928 3.409 2.537l.133 1.663H8.543l.133-1.663c.13-1.61 1.429-2.536 3.41-2.536zm2.799-5.466a2.8 2.8 0 11-5.6 0 2.8 2.8 0 015.6 0zm-2.8-1.5a1.5 1.5 0 110 3 1.5 1.5 0 010-3z"/></symbol><symbol viewBox="0 0 18 18" id="team-fill" xmlns="http://www.w3.org/2000/svg"><path d="M5.656 6.537a2.8 2.8 0 110-5.6 2.8 2.8 0 010 5.6zM1.41 14.703A.65.65 0 01.761 14l.189-2.365c.19-2.365 2.106-3.732 4.706-3.732 1.424 0 2.643.41 3.485 1.17-1.774.777-2.996 2.311-3.167 4.45l-.094 1.18H1.41zm10.675-6.166a2.8 2.8 0 110-5.6 2.8 2.8 0 010 5.6zM7.19 16a.65.65 0 00.648.703h8.494A.65.65 0 0016.98 16l-.19-2.365c-.189-2.366-2.105-3.733-4.705-3.733s-4.516 1.367-4.706 3.733L7.19 16z"/></symbol><symbol viewBox="0 0 18 18" id="value" xmlns="http://www.w3.org/2000/svg"><path d="M5.457 1.457h7.086a4 4 0 014 4v7.086a4 4 0 01-4 4H5.457a4 4 0 01-4-4V5.457a4 4 0 014-4zm0 1.3a2.7 2.7 0 00-2.7 2.7v7.086a2.7 2.7 0 002.7 2.7h7.086a2.7 2.7 0 002.7-2.7V5.457a2.7 2.7 0 00-2.7-2.7H5.457zM6 8.15a.65.65 0 010-1.3h6a.65.65 0 110 1.3H6zm0 3a.65.65 0 110-1.3h6a.65.65 0 110 1.3H6z"/></symbol><symbol viewBox="0 0 18 18" id="value-fill" xmlns="http://www.w3.org/2000/svg"><path d="M5.457 1.457h7.086a4 4 0 014 4v7.086a4 4 0 01-4 4H5.457a4 4 0 01-4-4V5.457a4 4 0 014-4zM6 8.15h6a.65.65 0 100-1.3H6a.65.65 0 000 1.3zm0 3h6a.65.65 0 100-1.3H6a.65.65 0 100 1.3z"/></symbol><symbol viewBox="0 0 18 18" id="wand" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.17 6.68c.112.029.144.029.244.09a.68.68 0 01.277.796c-.041.11-.067.129-.137.22l-8.4 9.008c-.032.029-.062.061-.097.086a.689.689 0 01-.933-.148.675.675 0 01-.028-.737c.023-.037.053-.07.08-.104l8.399-9.007c.033-.029.063-.061.098-.087a.67.67 0 01.237-.108.895.895 0 01.26-.01zm-.103 3.509c.019.001.023.001.042.004a.409.409 0 01.336.352c.002.018.001.023.002.042v2.734c-.007.259-.29.469-.544.372a.414.414 0 01-.258-.372v-2.734a.339.339 0 01.02-.123.41.41 0 01.34-.274c.04-.004.05-.002.062-.001zm2.33-1.061c.053.004.062.007.085.013.073.02.138.06.19.114l1.755 1.882c.172.193.107.54-.145.64a.42.42 0 01-.443-.099l-1.755-1.881a.413.413 0 01-.008-.533.416.416 0 01.321-.136zm-5.5-1.375H4.492c-.26-.006-.472-.286-.375-.54a.417.417 0 01.375-.256h2.424c.261.019.455.314.348.557a.415.415 0 01-.367.24zm8.706 0h-2.405c-.24-.005-.445-.243-.391-.484a.414.414 0 01.39-.312h2.426c.26.019.454.314.347.557a.415.415 0 01-.367.24zM6.138 2.745c.053.004.062.007.085.014.072.019.137.06.19.113l1.754 1.882c.174.195.103.542-.144.64a.42.42 0 01-.443-.098L5.825 3.414c-.169-.188-.114-.524.128-.634a.403.403 0 01.185-.035zm7.85 0c.244.014.44.265.371.506a.4.4 0 01-.092.163l-1.753 1.88c-.181.187-.533.148-.653-.094a.413.413 0 01.065-.447l1.754-1.88a.415.415 0 01.257-.126c.033-.003.041-.002.052-.002zm-3.92-1.744c.018.001.022.001.04.004a.409.409 0 01.337.352c.002.019.001.023.002.042v2.734c-.007.259-.29.47-.544.372a.414.414 0 01-.258-.372V1.4a.34.34 0 01.02-.123.41.41 0 01.34-.273c.04-.005.05-.002.062-.002z"/></symbol><symbol viewBox="0 0 18 18" id="wand-fill" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.158 6.502c.049.012.098.02.145.037a.926.926 0 01.578 1.073.898.898 0 01-.12.271c-.028.041-.062.078-.092.117l-8.112 8.718c-.037.034-.071.07-.11.1a.93.93 0 01-1.11-.003.925.925 0 01-.196-1.203c.027-.041.06-.078.092-.117l8.112-8.718c.036-.034.07-.07.11-.1A.909.909 0 019.86 6.5a1.23 1.23 0 01.297.002zm-.143 3.391a.665.665 0 01.617.59l.002.052v2.647a.665.665 0 01-.417.6.666.666 0 01-.8-.301.669.669 0 01-.073-.299v-2.647c0-.023 0-.028.002-.051a.66.66 0 01.617-.59h.052zm2.24-1.027c.066.003.077.006.106.011a.65.65 0 01.322.164l.03.03 1.695 1.822c.254.282.202.78-.137.986a.668.668 0 01-.808-.112l-1.695-1.822a.663.663 0 01-.124-.68.661.661 0 01.61-.399zM6.946 8.05H4.625a.668.668 0 01-.604-.416.66.66 0 01.299-.793.675.675 0 01.305-.076H6.97c.32.018.602.286.62.606a.662.662 0 01-.62.679h-.024zm8.408 0h-2.322a.667.667 0 01-.642-.582.664.664 0 01.617-.703h2.371c.345.02.64.331.62.679a.662.662 0 01-.62.606h-.024zM6.21 2.69c.067.002.078.005.107.01a.65.65 0 01.322.165l.03.03 1.695 1.822c.15.166.209.407.146.62a.662.662 0 01-.61.459.666.666 0 01-.481-.206L5.723 3.768a.665.665 0 01.034-.908.664.664 0 01.452-.171zm7.602 0a.667.667 0 01.56.379.658.658 0 01-.116.7l-1.694 1.82a.666.666 0 01-.524.204.664.664 0 01-.591-.584.66.66 0 01.17-.494l1.693-1.82a.65.65 0 01.438-.205c.042-.002.051 0 .064 0zM10.015 1a.665.665 0 01.617.59l.002.052V4.29a.67.67 0 01-.593.64.662.662 0 01-.697-.614V1.642c0-.023 0-.028.002-.051A.66.66 0 019.963 1h.052z"/></symbol><symbol viewBox="0 0 18 18" id="warning" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3zm0-1.3a6.35 6.35 0 100-12.7 6.35 6.35 0 000 12.7zM8.25 5.19a.75.75 0 111.5 0v5.06a.75.75 0 01-1.5 0V5.19zM9 13.7A.85.85 0 119 12a.85.85 0 010 1.7z"/></symbol><symbol viewBox="0 0 18 18" id="warning-fill" xmlns="http://www.w3.org/2000/svg"><path d="M9 16.65a7.65 7.65 0 110-15.3 7.65 7.65 0 010 15.3zM8.25 5.19v5.06a.75.75 0 001.5 0V5.19a.75.75 0 00-1.5 0zM9 13.7A.85.85 0 109 12a.85.85 0 000 1.7z"/></symbol><symbol viewBox="0 0 18 18" id="weights" xmlns="http://www.w3.org/2000/svg"><path d="M5.316 4.513V5.6a.65.65 0 11-1.3 0V4.513H.953a.65.65 0 110-1.3h3.063v-1.08a.65.65 0 111.3 0v1.08h11.599a.65.65 0 010 1.3H5.316zm8.705 4.197V7.7a.65.65 0 10-1.3 0v1.01H.953a.65.65 0 100 1.3h11.768v1.158a.65.65 0 101.3 0V10.01h2.894a.65.65 0 000-1.3H14.02zm-4.437 5.643v-1.084a.65.65 0 10-1.3 0v1.084H.954a.65.65 0 000 1.3h7.33v1.084a.65.65 0 101.3 0v-1.084h7.33a.65.65 0 000-1.3h-7.33z"/></symbol><symbol viewBox="0 0 18 18" id="weights-fill" xmlns="http://www.w3.org/2000/svg"><path d="M5.71 1.363h-2a.5.5 0 00-.5.5v.986H1.221a1 1 0 000 2h1.987v1.014a.5.5 0 00.5.5h2a.5.5 0 00.5-.5V4.849h10.563a1 1 0 100-2H6.209v-.986a.5.5 0 00-.5-.5zm9.15 8.981h1.87a1 1 0 000-2h-1.87v-.91a.5.5 0 00-.5-.5h-2a.5.5 0 00-.5.5v.91H1.248a1 1 0 000 2h10.61v1.09a.5.5 0 00.5.5h2a.5.5 0 00.5-.5v-1.09zm-4.534 5.67h6.452a1 1 0 100-2h-6.452v-1.078a.5.5 0 00-.5-.5h-2a.5.5 0 00-.5.5v1.078h-6.07a1 1 0 000 2h6.07v.922a.5.5 0 00.5.5h2a.5.5 0 00.5-.5v-.922z"/></symbol></svg>
    }
  end
end
