/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.logging;

import org.jruby.rack.RackLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
extends RackLogger.Base {
    private Logger logger;

    public Slf4jLogger() {
        this.setLoggerName("");
    }

    public Slf4jLogger(String loggerName) {
        this.setLoggerName(loggerName);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerName(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    @Override
    public boolean isEnabled(RackLogger.Level level) {
        if (level == null) {
            return this.logger.isInfoEnabled();
        }
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case FATAL: {
                return this.logger.isErrorEnabled();
            }
        }
        return this.logger.isTraceEnabled();
    }

    @Override
    public void log(RackLogger.Level level, String message) {
        if (level == null) {
            this.logger.info(message);
            return;
        }
        switch (level) {
            case DEBUG: {
                this.logger.debug(message);
            }
            case INFO: {
                this.logger.info(message);
            }
            case WARN: {
                this.logger.warn(message);
            }
            case ERROR: {
                this.logger.error(message);
            }
            case FATAL: {
                this.logger.error(message);
            }
        }
    }

    @Override
    public void log(RackLogger.Level level, String message, Throwable ex) {
        if (level == null) {
            this.logger.error(message, ex);
            return;
        }
        switch (level) {
            case DEBUG: {
                this.logger.debug(message, ex);
            }
            case INFO: {
                this.logger.info(message, ex);
            }
            case WARN: {
                this.logger.warn(message, ex);
            }
            case ERROR: {
                this.logger.error(message, ex);
            }
            case FATAL: {
                this.logger.error(message, ex);
            }
        }
    }

    @Override
    public RackLogger.Level getLevel() {
        if (this.logger.isDebugEnabled()) {
            return RackLogger.Level.DEBUG;
        }
        if (this.logger.isInfoEnabled()) {
            return RackLogger.Level.INFO;
        }
        if (this.logger.isWarnEnabled()) {
            return RackLogger.Level.WARN;
        }
        if (this.logger.isErrorEnabled()) {
            return RackLogger.Level.ERROR;
        }
        if (this.logger.isErrorEnabled()) {
            return RackLogger.Level.FATAL;
        }
        return null;
    }
}

