/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.ext;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.rack.RackException;
import org.jruby.rack.RackResponse;
import org.jruby.rack.RackResponseEnvironment;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"JRuby::Rack::Response"})
public class Response
extends RubyObject
implements RackResponse {
    protected static Boolean swallowClientAbort = Boolean.TRUE;
    protected static Boolean dechunk;
    private static Integer channelChunkSize;
    protected static Integer channelBufferSize;
    static final ObjectAllocator ALLOCATOR;
    private int status;
    private RubyHash headers;
    private IRubyObject body;
    private static final ByteList NEW_LINE;
    private static final ByteList TRANSFER_ENCODING;
    private Boolean chunked;
    private static final ByteList CONTENT_LENGTH;
    private static final ByteList CHUNKED;

    @JRubyMethod(name={"swallow_client_abort?"}, meta=true)
    public static IRubyObject is_swallow_client_abort(ThreadContext context, IRubyObject self) {
        if (swallowClientAbort == null) {
            return context.runtime.getFalse();
        }
        return context.runtime.newBoolean(swallowClientAbort.booleanValue());
    }

    @JRubyMethod(name={"swallow_client_abort="}, meta=true, required=1)
    public static IRubyObject set_swallow_client_abort(IRubyObject self, IRubyObject value) {
        swallowClientAbort = value instanceof RubyBoolean ? Boolean.valueOf(((RubyBoolean)value).isTrue()) : Boolean.valueOf(!value.isNil());
        return value;
    }

    @JRubyMethod(name={"dechunk?"}, meta=true)
    public static IRubyObject is_dechunk(ThreadContext context, IRubyObject self) {
        if (dechunk == null) {
            return context.nil;
        }
        return context.runtime.newBoolean(dechunk.booleanValue());
    }

    @JRubyMethod(name={"dechunk="}, meta=true, required=1)
    public static IRubyObject set_dechunk(IRubyObject self, IRubyObject value) {
        dechunk = value instanceof RubyBoolean ? Boolean.valueOf(((RubyBoolean)value).isTrue()) : Boolean.valueOf(!value.isNil());
        return value;
    }

    @JRubyMethod(name={"channel_chunk_size"}, meta=true)
    public static IRubyObject get_channel_chunk_size(ThreadContext context, IRubyObject self) {
        if (channelChunkSize == null) {
            return context.nil;
        }
        return context.runtime.newFixnum(channelChunkSize.intValue());
    }

    @JRubyMethod(name={"channel_chunk_size="}, meta=true, required=1)
    public static IRubyObject set_channel_chunk_size(IRubyObject self, IRubyObject value) {
        if (value.isNil()) {
            channelChunkSize = null;
        } else {
            long val = value.convertToInteger("to_i").getLongValue();
            channelChunkSize = (int)val;
        }
        return value;
    }

    @JRubyMethod(name={"channel_buffer_size"}, meta=true)
    public static IRubyObject get_channel_buffer_size(ThreadContext context, IRubyObject self) {
        return context.runtime.newFixnum(channelBufferSize.intValue());
    }

    @JRubyMethod(name={"channel_buffer_size="}, meta=true, required=1)
    public static IRubyObject set_channel_buffer_size(IRubyObject self, IRubyObject value) {
        if (value.isNil()) {
            channelBufferSize = 16384;
        } else {
            long val = value.convertToInteger("to_i").getLongValue();
            channelBufferSize = (int)val;
        }
        return value;
    }

    protected Response(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg) {
        if (arg instanceof RubyArray) {
            RubyArray arr = (RubyArray)arg;
            if (arr.size() < 3) {
                throw context.runtime.newArgumentError("expected 3 array elements (rack-respose)");
            }
            this.status = (int)arr.eltInternal(0).convertToInteger("to_i").getLongValue();
            this.headers = arr.eltInternal(1).convertToHash();
            this.body = arr.eltInternal(2);
        } else {
            this.status = (int)arg.callMethod(context, "[]", (IRubyObject)context.runtime.newFixnum(0)).convertToInteger("to_i").getLongValue();
            this.headers = arg.callMethod(context, "[]", (IRubyObject)context.runtime.newFixnum(1)).convertToHash();
            this.body = arg.callMethod(context, "[]", (IRubyObject)context.runtime.newFixnum(2));
        }
        if (!this.body.respondsTo("each_line") && !this.body.respondsTo("each")) {
            this.body = this.body.asString();
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject status(ThreadContext context) {
        return context.runtime.newFixnum(this.status);
    }

    @JRubyMethod
    public IRubyObject body(ThreadContext context) {
        return this.body;
    }

    @JRubyMethod
    public IRubyObject headers(ThreadContext context) {
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBody() {
        if (this.body instanceof RubyString) {
            return this.body.asJavaString();
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        try {
            final StringBuilder bodyParts = new StringBuilder();
            Response.invoke(context, this.body, "each", (BlockBody)new JavaInternalBlockBody(context.runtime, Arity.ONE_REQUIRED){

                public IRubyObject yield(ThreadContext context, IRubyObject[] args) {
                    return this.yield(context, args[0]);
                }

                public IRubyObject yield(ThreadContext context, IRubyObject part) {
                    bodyParts.append(part.asString().toString());
                    return part;
                }
            });
            String string = bodyParts.toString();
            return string;
        }
        finally {
            if (this.body.respondsTo("close")) {
                this.body.callMethod(context, "close");
            }
        }
    }

    @Override
    public void respond(RackResponseEnvironment response) throws RackException {
        if (!response.isCommitted()) {
            try {
                if (this.getMetaClass().getName().startsWith("JRuby::Rack")) {
                    this.writeStatus(response);
                    this.writeHeaders(response);
                    this.writeBody(response);
                } else {
                    ThreadContext context = this.currentContext();
                    IRubyObject rubyResponse = JavaUtil.convertJavaToRuby((Ruby)context.runtime, (Object)response);
                    this.callMethod(context, "write_status", rubyResponse);
                    this.callMethod(context, "write_headers", rubyResponse);
                    this.callMethod(context, "write_body", rubyResponse);
                }
            }
            catch (IOException e) {
                throw new RackException(e);
            }
        }
    }

    @JRubyMethod(name={"write_status"})
    public IRubyObject write_status(ThreadContext context, IRubyObject response) {
        this.writeStatus((RackResponseEnvironment)response.toJava(RackResponseEnvironment.class));
        return context.nil;
    }

    protected void writeStatus(RackResponseEnvironment response) {
        response.setStatus(this.status);
    }

    @JRubyMethod(name={"write_headers"})
    public IRubyObject write_headers(ThreadContext context, IRubyObject response) throws IOException {
        this.writeHeaders((RackResponseEnvironment)response.toJava(RackResponseEnvironment.class));
        return context.nil;
    }

    protected void writeHeaders(final RackResponseEnvironment response) throws IOException {
        this.headers.visitAll(new RubyHash.Visitor(){

            public void visit(IRubyObject key, IRubyObject val) {
                final String name = key.toString();
                if (name.equalsIgnoreCase("Content-Type")) {
                    response.setContentType(val.asJavaString());
                    return;
                }
                if (name.equalsIgnoreCase("Content-Length")) {
                    if (Response.this.isChunked()) {
                        return;
                    }
                    long length = val.convertToInteger("to_i").getLongValue();
                    if (length < Integer.MAX_VALUE) {
                        response.setContentLength((int)length);
                        return;
                    }
                }
                if (name.equals("Transfer-Encoding") && Response.this.skipEncodingHeader(val)) {
                    return;
                }
                boolean each_line = val.respondsTo("each_line");
                if (each_line || val.respondsTo("each")) {
                    ThreadContext context = Response.this.getRuntime().getCurrentContext();
                    final RubyString newLine = RubyString.newString((Ruby)context.runtime, (ByteList)NEW_LINE);
                    Response.invoke(context, val, each_line ? "each_line" : "each", (BlockBody)new JavaInternalBlockBody(context.runtime, Arity.ONE_REQUIRED){

                        public IRubyObject yield(ThreadContext context, IRubyObject[] args) {
                            return this.yield(context, args[0]);
                        }

                        public IRubyObject yield(ThreadContext context, IRubyObject value) {
                            value.callMethod(context, "chomp!", (IRubyObject)newLine);
                            response.addHeader(name, value.toString());
                            return value;
                        }
                    });
                    return;
                }
                if (val instanceof RubyNumeric) {
                    long value = val.convertToInteger("to_i").getLongValue();
                    if (value < Integer.MAX_VALUE) {
                        response.addIntHeader(name, (int)value);
                        return;
                    }
                } else if (val instanceof RubyTime) {
                    long millis = ((RubyTime)val).getDateTime().getMillis();
                    response.addDateHeader(name, millis);
                    return;
                }
                response.addHeader(name, val.toString());
            }
        });
    }

    @JRubyMethod(name={"write_body"})
    public IRubyObject write_body(ThreadContext context, IRubyObject response) throws IOException {
        this.writeBody((RackResponseEnvironment)response.toJava(RackResponseEnvironment.class));
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBody(RackResponseEnvironment response) throws IOException {
        block26: {
            Channel bodyChannel = null;
            IRubyObject body = this.body;
            try {
                if (body.respondsTo("call") && !body.respondsTo("each")) {
                    ThreadContext context = this.currentContext();
                    IRubyObject outputStream = JavaUtil.convertJavaToRuby((Ruby)context.runtime, (Object)response.getOutputStream());
                    this.body.callMethod(context, "call", outputStream);
                    return;
                }
                if (body.respondsTo("to_path")) {
                    ThreadContext context = this.currentContext();
                    IRubyObject path = body.callMethod(context, "to_path");
                    this.callMethod("send_file", new IRubyObject[]{path, JavaUtil.convertJavaToRuby((Ruby)context.runtime, (Object)response)});
                    return;
                }
                if (body.respondsTo("body_parts")) {
                    body = body.callMethod(this.currentContext(), "body_parts");
                }
                if (body.respondsTo("to_channel")) {
                    if (body instanceof RubyIO) {
                        bodyChannel = ((RubyIO)body).getChannel();
                    } else {
                        ThreadContext context = this.currentContext();
                        IRubyObject channel = body.callMethod(context, "to_channel");
                        bodyChannel = (Channel)channel.toJava(Channel.class);
                    }
                    if (bodyChannel instanceof FileChannel) {
                        this.transferChannel((FileChannel)bodyChannel, response.getOutputStream());
                    } else {
                        this.transferChannel((ReadableByteChannel)bodyChannel, response.getOutputStream());
                    }
                    return;
                }
                final OutputStream output = response.getOutputStream();
                ThreadContext context = this.currentContext();
                Object error = null;
                if (this.doDechunk()) {
                    IRubyObject output_stream = JavaUtil.convertJavaToRuby((Ruby)context.runtime, (Object)output);
                    this.callMethod(context, "write_body_dechunked", output_stream);
                    break block26;
                }
                String method = body.respondsTo("each_line") ? "each_line" : "each";
                try {
                    Response.invoke(context, body, method, (BlockBody)new JavaInternalBlockBody(context.runtime, Arity.ONE_REQUIRED){

                        public IRubyObject yield(ThreadContext context, IRubyObject[] args) {
                            return this.yield(context, args[0]);
                        }

                        public IRubyObject yield(ThreadContext context, IRubyObject line) {
                            try {
                                output.write(line.asString().getBytes());
                                if (Response.this.doFlush()) {
                                    output.flush();
                                }
                            }
                            catch (IOException e) {
                                throw new WrappedException(e);
                            }
                            return context.nil;
                        }
                    });
                }
                catch (WrappedException e) {
                    throw e.getIOCause();
                }
            }
            catch (IOException e) {
                if (!this.handledAsClientAbort(e)) {
                    throw e;
                }
            }
            catch (RuntimeException e) {
                if (!this.handledAsClientAbort(e)) {
                    throw e;
                }
            }
            finally {
                if (body.respondsTo("close")) {
                    body.callMethod(this.currentContext(), "close");
                } else if (bodyChannel != null) {
                    bodyChannel.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"send_file"})
    public IRubyObject send_file(ThreadContext context, IRubyObject path, IRubyObject response) throws IOException {
        RackResponseEnvironment servletResponse = (RackResponseEnvironment)response.toJava(Object.class);
        FileInputStream input = new FileInputStream(path.asString().toString());
        FileChannel inputChannel = input.getChannel();
        try {
            this.transferChannel(inputChannel, servletResponse.getOutputStream());
        }
        finally {
            inputChannel.close();
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return context.nil;
    }

    @JRubyMethod(name={"chunked?"})
    public IRubyObject chunked_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isChunked());
    }

    public boolean isChunked() {
        RubyString key;
        IRubyObject value;
        if (this.chunked != null) {
            return this.chunked;
        }
        if (this.headers != null && (value = this.headers.callMethod("[]", (IRubyObject)(key = RubyString.newString((Ruby)this.getRuntime(), (ByteList)TRANSFER_ENCODING)))) instanceof RubyString) {
            this.chunked = ((RubyString)value).getByteList().equal(CHUNKED);
            return this.chunked;
        }
        this.chunked = Boolean.FALSE;
        return this.chunked;
    }

    protected boolean doDechunk() {
        return dechunk == Boolean.TRUE && this.isChunked();
    }

    @JRubyMethod(name={"flush?"})
    public IRubyObject flush_p(ThreadContext context) {
        return context.runtime.newBoolean(this.doFlush());
    }

    protected boolean doFlush() {
        if (this.isChunked()) {
            return true;
        }
        if (this.headers != null) {
            RubyString key = RubyString.newString((Ruby)this.getRuntime(), (ByteList)CONTENT_LENGTH);
            IRubyObject value = this.headers.callMethod("[]", (IRubyObject)key);
            return value.isNil();
        }
        return false;
    }

    private boolean handledAsClientAbort(Exception ioe) {
        if (swallowClientAbort == Boolean.TRUE) {
            return this.isClientAbortException(ioe);
        }
        return false;
    }

    protected boolean isClientAbortException(Exception ioe) {
        String error = ioe.toString();
        if (error.contains("ClientAbortException")) {
            return true;
        }
        if (error.contains("EofException")) {
            return true;
        }
        do {
            if (!error.toLowerCase().contains("broken pipe")) continue;
            return true;
        } while (ioe.getCause() != null && (error = ioe.getCause().getMessage()) != null);
        return false;
    }

    private boolean skipEncodingHeader(IRubyObject value) {
        if (dechunk == Boolean.FALSE) {
            return false;
        }
        if (value instanceof RubyString) {
            return ((RubyString)value).getByteList().equal(CHUNKED);
        }
        return false;
    }

    public Integer getChannelChunkSize() {
        return channelChunkSize;
    }

    private void transferChannel(FileChannel channel, OutputStream output) throws IOException {
        Integer chunkSize = this.getChannelChunkSize();
        if (chunkSize != null && chunkSize > 0) {
            WritableByteChannel outputChannel = Channels.newChannel(output);
            long size = channel.size();
            for (long pos = 0L; pos < size; pos += channel.transferTo(pos, chunkSize.intValue(), outputChannel)) {
            }
        } else {
            this.transferChannel((ReadableByteChannel)channel, output);
        }
    }

    public Integer getChannelBufferSize() {
        return channelBufferSize;
    }

    private void transferChannel(ReadableByteChannel channel, OutputStream output) throws IOException {
        WritableByteChannel outputChannel = Channels.newChannel(output);
        ByteBuffer buffer = ByteBuffer.allocate(this.getChannelBufferSize());
        while (channel.read(buffer) != -1) {
            buffer.flip();
            outputChannel.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            outputChannel.write(buffer);
        }
    }

    ThreadContext currentContext() {
        return this.getRuntime().getCurrentContext();
    }

    static IRubyObject invoke(ThreadContext context, IRubyObject self, String method, BlockBody body) {
        Block block = new Block(body, context.currentBinding(self, Visibility.PUBLIC));
        return Helpers.invoke((ThreadContext)context, (IRubyObject)self, (String)method, (Block)block);
    }

    public Object toJava(Class target) {
        if (target == null || target == RackResponse.class) {
            return this;
        }
        return super.toJava(target);
    }

    static {
        channelChunkSize = 0x2000000;
        channelBufferSize = 16384;
        ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Response(runtime, klass);
            }
        };
        NEW_LINE = new ByteList(new byte[]{10}, false);
        TRANSFER_ENCODING = new ByteList(new byte[]{84, 114, 97, 110, 115, 102, 101, 114, 45, 69, 110, 99, 111, 100, 105, 110, 103}, false);
        CONTENT_LENGTH = new ByteList(new byte[]{67, 111, 110, 116, 101, 110, 116, 45, 76, 101, 110, 103, 116, 104}, false);
        CHUNKED = new ByteList(new byte[]{99, 104, 117, 110, 107, 101, 100}, false);
    }

    private static class WrappedException
    extends RuntimeException {
        WrappedException(IOException cause) {
            super(cause);
        }

        IOException getIOCause() {
            return (IOException)this.getCause();
        }
    }
}

