/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_component;

import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_component.JCasProcessor;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.impl.AnalysisEngineProcessorAdapter;
import org.apache.uima.analysis_engine.impl.AnalysisEngineProcessorStub;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ResourceMetaData;

public class JCasProcessorAnnotator
extends AnalysisEngineProcessorAdapter {
    private ResourceMetaData metaData = UIMAFramework.getResourceSpecifierFactory().createAnalysisEngineMetaData();
    private JCasProcessor<? extends Exception> delegate;

    public JCasProcessorAnnotator(JCasProcessor<? extends Exception> aJCasAnnotator) {
        this.delegate = aJCasAnnotator;
    }

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        this.setStub(this.makeDelegate());
        return super.initialize(aSpecifier, aAdditionalParams);
    }

    private AnalysisEngineProcessorStub makeDelegate() {
        return new AnalysisEngineProcessorStub(){

            @Override
            public ResourceMetaData getMetaData() {
                return JCasProcessorAnnotator.this.metaData;
            }

            @Override
            public void process(CAS aCAS) throws AnalysisEngineProcessException {
                JCas jcas;
                try {
                    jcas = aCAS.getJCas();
                }
                catch (CASException e) {
                    throw new AnalysisEngineProcessException(e);
                }
                try {
                    JCasProcessorAnnotator.this.delegate.process(jcas);
                }
                catch (Exception e) {
                    if (e instanceof AnalysisEngineProcessException) {
                        throw (AnalysisEngineProcessException)e;
                    }
                    throw new AnalysisEngineProcessException(e);
                }
            }
        };
    }

    public static JCasProcessorAnnotator of(JCasProcessor<? extends Exception> aJCasAnnotator) throws ResourceInitializationException {
        JCasProcessorAnnotator engine = new JCasProcessorAnnotator(aJCasAnnotator);
        engine.initialize(null, null);
        return engine;
    }
}

