"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var boom_1 = __importDefault(require("@hapi/boom"));
var _1 = require(".");
exports.default = {
    name: 'ems-ui-plugin',
    version: '1.0.0',
    register: function (server, options) {
        server.bind(options);
        if (options.config.ui == true) {
            // EMS landing page
            server.route({
                method: 'GET',
                path: '/maps/{param*}',
                handler: {
                    directory: {
                        path: 'ems-landing-page',
                    },
                },
                options: { pre: [_1.licenseCheckPre] },
            });
            // Redirect for
            server.route({
                method: 'GET',
                path: '/maps',
                handler: function (request, reply) {
                    return reply.redirect('./maps/').permanent(true);
                },
            });
            // EMS Frontpage
            server.route({
                method: 'GET',
                path: '/{param*}',
                handler: {
                    directory: {
                        path: 'frontpage',
                    },
                },
            });
        }
        else {
            options.logger.info({
                message: 'Status page and map previews are disabled',
            });
            // All routes are by default forbidden
            server.route({
                method: 'GET',
                path: '/{param*}',
                handler: function () { return boom_1.default.forbidden(); },
            });
        }
    },
};
//# sourceMappingURL=ui.js.map