/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import java.util.Objects;
import org.elasticsearch.h3.Constants;
import org.elasticsearch.h3.CoordIJK;
import org.elasticsearch.h3.FastMath;
import org.elasticsearch.h3.H3Index;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.h3.Vec3d;

record Vec2d(double x, double y) {
    private static final double M_RSIN60 = 1.0 / Constants.M_SQRT3_2;
    private static final double M_ONETHIRD = 0.3333333333333333;
    private static final double VEC2D_RESOLUTION = 1.0E-7;
    public static final LatLng[] faceCenterGeo = new LatLng[]{new LatLng(0.80358264971899, 1.2483974196173961), new LatLng(1.3077478834556382, 2.5369450098779214), new LatLng(1.054751253523952, -1.3475173589003966), new LatLng(0.6001915955381868, -0.45060390946975576), new LatLng(0.49171542819877384, 0.40198820291130694), new LatLng(0.1727453274156187, 1.6781468852804338), new LatLng(0.6059293215713507, 2.9539233298124117), new LatLng(0.42737051832897965, -1.8888762003362853), new LatLng(-0.07906611854921283, -0.7334295133808677), new LatLng(-0.23096164445538364, 0.506495587332349), new LatLng(0.07906611854921283, 2.4081631402089254), new LatLng(0.23096164445538364, -2.635097066257444), new LatLng(-0.1727453274156187, -1.4634457683093596), new LatLng(-0.6059293215713507, -0.18766932377738163), new LatLng(-0.42737051832897965, 1.2527164532535078), new LatLng(-0.6001915955381868, 2.6909887441200375), new LatLng(-0.49171542819877384, -2.7396044506784865), new LatLng(-0.80358264971899, -1.8931952339723972), new LatLng(-1.3077478834556382, -0.6046476437118721), new LatLng(-1.054751253523952, 1.7940752946893965)};
    public static final double[][] faceAxesAzRadsCII = new double[][]{{5.6199582685239395, 3.5255631661307447, 1.4311680637375488}, {5.7603390817141875, 3.665943979320992, 1.571548876927796}, {0.78021365439343, 4.969003859179821, 2.8746087567866256}, {0.4304693639799999, 4.619259568766391, 2.5248644663731956}, {6.130269123335111, 4.0358740209419155, 1.9414789185487202}, {2.692877706530643, 0.5984826041374471, 4.787272808923838}, {2.982963003477244, 0.8885679010840484, 5.07735810587044}, {3.532912002790141, 1.4385169003969456, 5.627307105183337}, {3.494305004259568, 1.3999099018663728, 5.588700106652764}, {3.0032141694995382, 0.908819067106343, 5.0976092718927335}, {5.930472956509812, 3.836077854116616, 1.7416827517234204}, {0.13837848409025486, 4.327168688876646, 2.23277358648345}, {0.4487149470591504, 4.6375051518455415, 2.543110049452346}, {0.15862965011254937, 4.3474198548989405, 2.2530247525057447}, {5.891865957979238, 3.797470855586043, 1.7030757531928475}, {2.711123289609793, 0.6167281872165977, 4.8055183920029885}, {3.294508837434268, 1.2001137350410729, 5.388903939827464}, {3.80481969224544, 1.7104245898522445, 5.8992147946386355}, {3.6644388790551923, 1.570043776661997, 5.758833981448388}, {2.361378999196363, 0.2669838968031676, 4.455774101589559}};

    public LatLng hex2dToGeo(int face, int res, boolean substrate) {
        return Vec2d.hex2dToGeo(this.x, this.y, face, res, substrate);
    }

    static LatLng hex2dToGeo(double x, double y, int face, int res, boolean substrate) {
        double r = Math.sqrt(x * x + y * y);
        if (r < Constants.EPSILON) {
            return faceCenterGeo[face];
        }
        double theta = FastMath.atan2(y, x);
        for (int i = 0; i < res; ++i) {
            r *= 0.3779644730092272;
        }
        if (substrate) {
            r *= 0.3333333333333333;
            if (H3Index.isResolutionClassIII(res)) {
                r *= 0.3779644730092272;
            }
        }
        r *= Constants.RES0_U_GNOMONIC;
        r = FastMath.atan(r);
        if (!substrate && H3Index.isResolutionClassIII(res)) {
            theta = Vec2d.posAngleRads(theta + Constants.M_AP7_ROT_RADS);
        }
        theta = Vec2d.posAngleRads(faceAxesAzRadsCII[face][0] - theta);
        return Vec3d.faceCenterPoint[face].geoAzDistanceRads(theta, r);
    }

    static CoordIJK hex2dToCoordIJK(double x, double y) {
        int j;
        int i;
        boolean k = false;
        double a1 = Math.abs(x);
        double a2 = Math.abs(y);
        double x2 = a2 * M_RSIN60;
        double x1 = a1 + x2 * 0.5;
        int m1 = (int)x1;
        int m2 = (int)x2;
        double r1 = x1 - (double)m1;
        double r2 = x2 - (double)m2;
        if (r1 < 0.5) {
            if (r1 < 0.3333333333333333) {
                if (r2 < (1.0 + r1) * 0.5) {
                    i = m1;
                    j = m2;
                } else {
                    i = m1;
                    j = m2 + 1;
                }
            } else {
                j = r2 < 1.0 - r1 ? m2 : m2 + 1;
                i = 1.0 - r1 <= r2 && r2 < 2.0 * r1 ? m1 + 1 : m1;
            }
        } else if (r1 < 0.6666666666666666) {
            j = r2 < 1.0 - r1 ? m2 : m2 + 1;
            i = 2.0 * r1 - 1.0 < r2 && r2 < 1.0 - r1 ? m1 : m1 + 1;
        } else if (r2 < r1 * 0.5) {
            i = m1 + 1;
            j = m2;
        } else {
            i = m1 + 1;
            j = m2 + 1;
        }
        if (x < 0.0) {
            if (j % 2 == 0) {
                axisi = j / 2;
                int diff = i - axisi;
                i -= 2 * diff;
            } else {
                axisi = (j + 1) / 2;
                int diff = i - axisi;
                i -= 2 * diff + 1;
            }
        }
        if (y < 0.0) {
            i -= (2 * j + 1) / 2;
            j *= -1;
        }
        CoordIJK coordIJK = new CoordIJK(i, j, 0);
        coordIJK.ijkNormalize();
        return coordIJK;
    }

    public boolean numericallyIdentical(Vec2d vec2d) {
        return Math.abs(vec2d.x - this.x) < 1.0E-7 && Math.abs(vec2d.y - this.y) < 1.0E-7;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec2d vec2d = (Vec2d)o;
        return Double.compare(vec2d.x, this.x) == 0 && Double.compare(vec2d.y, this.y) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public static Vec2d v2dIntersect(Vec2d p0, Vec2d p1, Vec2d p2, Vec2d p3) {
        double s1x = p1.x - p0.x;
        double s1y = p1.y - p0.y;
        double s2x = p3.x - p2.x;
        double s2y = p3.y - p2.y;
        double t = (s2x * (p0.y - p2.y) - s2y * (p0.x - p2.x)) / (-s2x * s1y + s1x * s2y);
        return new Vec2d(p0.x + t * s1x, p0.y + t * s1y);
    }

    static double posAngleRads(double rads) {
        if (rads < 0.0) {
            return rads + Math.PI * 2;
        }
        if (rads >= Math.PI * 2) {
            return rads - Math.PI * 2;
        }
        return rads;
    }
}

