/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public record Measurement(Number value, Map<String, Object> attributes, boolean isDouble) {
    public Measurement {
        Objects.requireNonNull(value);
    }

    public boolean isLong() {
        return !this.isDouble;
    }

    public double getDouble() {
        assert (this.isDouble);
        return this.value.doubleValue();
    }

    public long getLong() {
        assert (this.isLong());
        return this.value.longValue();
    }

    public static List<Measurement> combine(List<Measurement> measurements) {
        if (measurements == null || measurements.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isDouble = measurements.get((int)0).isDouble;
        HashMap byAttr = new HashMap();
        measurements.forEach(m -> {
            if (m.isDouble != isDouble) {
                throw new IllegalArgumentException("cannot combine measurements of different types");
            }
            byAttr.compute(m.attributes, (k, v) -> v == null ? (Number)m.value : (Number)(isDouble ? v.doubleValue() + m.getDouble() : (double)(v.longValue() + m.getLong())));
        });
        return byAttr.entrySet().stream().map(entry -> new Measurement((Number)entry.getValue(), (Map)entry.getKey(), isDouble)).collect(Collectors.toList());
    }
}

