/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.TestBlock;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AbstractScriptFieldTypeTestCase
extends MapperServiceTestCase {
    private static final ToXContent.Params INCLUDE_DEFAULTS = new ToXContent.MapParams(Map.of("include_defaults", "true"));

    protected abstract MappedFieldType simpleMappedFieldType();

    protected abstract MappedFieldType loopFieldType();

    protected abstract String typeName();

    protected static <T extends IndexableField> void addDocument(RandomIndexWriter iw, Iterable<T> indexableFields) throws IOException {
        iw.addDocument(indexableFields);
        if (AbstractScriptFieldTypeTestCase.randomBoolean()) {
            iw.flush();
        }
    }

    public final void testMinimalSerializesToItself() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, ToXContent.EMPTY_PARAMS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, ToXContent.EMPTY_PARAMS);
        parsedFromOrig.endObject();
        AbstractScriptFieldTypeTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
    }

    public final void testMeta() throws IOException {
        XContentBuilder mapping = AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("foo", "bar"));
        }));
        MapperService mapperService = this.createMapperService(mapping);
        AbstractScriptFieldTypeTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping));
        AbstractScriptFieldTypeTestCase.merge(mapperService, mapping);
        AbstractScriptFieldTypeTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("baz", "quux"));
        }));
        AbstractScriptFieldTypeTestCase.merge(mapperService, mapping);
        AbstractScriptFieldTypeTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
    }

    public final void testMinimalMappingToMaximal() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, INCLUDE_DEFAULTS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, INCLUDE_DEFAULTS);
        parsedFromOrig.endObject();
        AbstractScriptFieldTypeTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
    }

    public void testCopyToIsNotSupported() throws IOException {
        XContentBuilder mapping = AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("copy_to", "target");
        }));
        MapperParsingException exception = (MapperParsingException)AbstractScriptFieldTypeTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(mapping));
        AbstractScriptFieldTypeTestCase.assertThat(exception.getMessage(), Matchers.containsString((String)"unknown parameter [copy_to] on runtime field"));
    }

    public void testMultiFieldsIsNotSupported() throws IOException {
        XContentBuilder mapping = AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.startObject("fields").startObject("test").field("type", "keyword").endObject().endObject();
        }));
        MapperParsingException exception = (MapperParsingException)AbstractScriptFieldTypeTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(mapping));
        AbstractScriptFieldTypeTestCase.assertThat(exception.getMessage(), Matchers.containsString((String)"unknown parameter [fields] on runtime field"));
    }

    public void testStoredScriptsAreNotSupported() throws Exception {
        XContentBuilder mapping = AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.typeName());
            b.startObject("script").field("id", "test").endObject();
        }));
        MapperParsingException exception = (MapperParsingException)AbstractScriptFieldTypeTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(mapping));
        AbstractScriptFieldTypeTestCase.assertEquals((Object)"Failed to parse mapping: stored scripts are not supported for runtime field [field]", (Object)exception.getMessage());
    }

    public void testFieldCaps() throws Exception {
        MapperService scriptIndexMapping = this.createMapperService(AbstractScriptFieldTypeTestCase.runtimeFieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field").field("type", this.typeName()).endObject().endObject().endObject().endObject();
        MapperService concreteIndexMapping = this.createMapperService(mapping);
        MappedFieldType scriptFieldType = scriptIndexMapping.fieldType("field");
        MappedFieldType concreteIndexType = concreteIndexMapping.fieldType("field");
        AbstractScriptFieldTypeTestCase.assertEquals((Object)concreteIndexType.familyTypeName(), (Object)scriptFieldType.familyTypeName());
        AbstractScriptFieldTypeTestCase.assertEquals((Object)concreteIndexType.isSearchable(), (Object)scriptFieldType.isSearchable());
        AbstractScriptFieldTypeTestCase.assertEquals((Object)concreteIndexType.isAggregatable(), (Object)scriptFieldType.isAggregatable());
    }

    public final void testOnScriptError() throws IOException {
        try (BaseDirectoryWrapper directory = AbstractScriptFieldTypeTestCase.newDirectory();
             RandomIndexWriter iw = new RandomIndexWriter(AbstractScriptFieldTypeTestCase.random(), (Directory)directory);){
            iw.addDocument(List.of(new StoredField("_source", new BytesRef((CharSequence)"{\"foo\": [1]}"))));
            try (DirectoryReader reader = iw.getReader();){
                IndexSearcher searcher = AbstractScriptFieldTypeTestCase.newSearcher((IndexReader)reader);
                AbstractScriptFieldType<?> fieldType = this.build("error", Collections.emptyMap(), OnScriptError.CONTINUE);
                SearchExecutionContext searchExecutionContext = AbstractScriptFieldTypeTestCase.mockContext(true, fieldType);
                Query query = new ExistsQueryBuilder("test").rewrite((QueryRewriteContext)searchExecutionContext).toQuery(searchExecutionContext);
                AbstractScriptFieldTypeTestCase.assertEquals((long)0L, (long)searcher.count(query));
                fieldType = this.build("error", Collections.emptyMap(), OnScriptError.FAIL);
                searchExecutionContext = AbstractScriptFieldTypeTestCase.mockContext(true, fieldType);
                query = new ExistsQueryBuilder("test").rewrite((QueryRewriteContext)searchExecutionContext).toQuery(searchExecutionContext);
                AbstractScriptFieldTypeTestCase.expectThrows(RuntimeException.class, () -> searcher.count(query));
            }
        }
    }

    public final void testOnScriptErrorFail() throws IOException {
        try (BaseDirectoryWrapper directory = AbstractScriptFieldTypeTestCase.newDirectory();
             RandomIndexWriter iw = new RandomIndexWriter(AbstractScriptFieldTypeTestCase.random(), (Directory)directory);){
            iw.addDocument(List.of(new StoredField("_source", new BytesRef((CharSequence)"{\"foo\": [1]}"))));
            try (DirectoryReader reader = iw.getReader();){
                IndexSearcher searcher = AbstractScriptFieldTypeTestCase.newSearcher((IndexReader)reader);
                AbstractScriptFieldType<?> fieldType = this.build("error", Collections.emptyMap(), OnScriptError.FAIL);
                SearchExecutionContext searchExecutionContext = AbstractScriptFieldTypeTestCase.mockContext(true, fieldType);
                Query query = new ExistsQueryBuilder("test").rewrite((QueryRewriteContext)searchExecutionContext).toQuery(searchExecutionContext);
                AbstractScriptFieldTypeTestCase.expectThrows(RuntimeException.class, () -> searcher.count(query));
            }
        }
    }

    @Override
    public void testFieldHasValue() {
        AbstractScriptFieldTypeTestCase.assertTrue((boolean)this.getMappedFieldType().fieldHasValue(new FieldInfos(new FieldInfo[]{this.getFieldInfoWithName(AbstractScriptFieldTypeTestCase.randomAlphaOfLength(5))})));
    }

    @Override
    public void testFieldHasValueWithEmptyFieldInfos() {
        AbstractScriptFieldTypeTestCase.assertTrue((boolean)this.getMappedFieldType().fieldHasValue(FieldInfos.EMPTY));
    }

    @Override
    public MappedFieldType getMappedFieldType() {
        return this.simpleMappedFieldType();
    }

    protected abstract AbstractScriptFieldType<?> build(String var1, Map<String, Object> var2, OnScriptError var3);

    public abstract void testDocValues() throws IOException;

    public abstract void testSort() throws IOException;

    public abstract void testUsedInScript() throws IOException;

    public abstract void testExistsQuery() throws IOException;

    public abstract void testRangeQuery() throws IOException;

    protected abstract Query randomRangeQuery(MappedFieldType var1, SearchExecutionContext var2);

    public abstract void testTermQuery() throws IOException;

    protected abstract Query randomTermQuery(MappedFieldType var1, SearchExecutionContext var2);

    public abstract void testTermsQuery() throws IOException;

    protected abstract Query randomTermsQuery(MappedFieldType var1, SearchExecutionContext var2);

    protected static SearchExecutionContext mockContext() {
        return AbstractScriptFieldTypeTestCase.mockContext(true);
    }

    protected static FieldDataContext mockFielddataContext() {
        SearchExecutionContext searchExecutionContext = AbstractScriptFieldTypeTestCase.mockContext();
        return new FieldDataContext("test", null, () -> ((SearchExecutionContext)searchExecutionContext).lookup(), arg_0 -> ((SearchExecutionContext)AbstractScriptFieldTypeTestCase.mockContext()).sourcePath(arg_0), MappedFieldType.FielddataOperation.SCRIPT);
    }

    protected static SearchExecutionContext mockContext(boolean allowExpensiveQueries) {
        return AbstractScriptFieldTypeTestCase.mockContext(allowExpensiveQueries, null);
    }

    protected boolean supportsTermQueries() {
        return true;
    }

    protected boolean supportsRangeQueries() {
        return true;
    }

    protected static SearchExecutionContext mockContext(boolean allowExpensiveQueries, MappedFieldType mappedFieldType) {
        return AbstractScriptFieldTypeTestCase.mockContext(allowExpensiveQueries, mappedFieldType, SourceProvider.fromLookup((MappingLookup)MappingLookup.EMPTY, null, (SourceFieldMetrics)SourceFieldMetrics.NOOP));
    }

    protected static SearchExecutionContext mockContext(boolean allowExpensiveQueries, MappedFieldType mappedFieldType, SourceProvider sourceProvider) {
        SearchExecutionContext context = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        if (mappedFieldType != null) {
            Mockito.when((Object)context.getFieldType(ArgumentMatchers.anyString())).thenReturn((Object)mappedFieldType);
        }
        Mockito.when((Object)context.allowExpensiveQueries()).thenReturn((Object)allowExpensiveQueries);
        SearchLookup lookup = new SearchLookup(arg_0 -> ((SearchExecutionContext)context).getFieldType(arg_0), (mft, lookupSupplier, fdo) -> mft.fielddataBuilder(new FieldDataContext("test", null, lookupSupplier, arg_0 -> ((SearchExecutionContext)context).sourcePath(arg_0), fdo)).build(null, null), sourceProvider);
        Mockito.when((Object)context.lookup()).thenReturn((Object)lookup);
        Mockito.when((Object)context.getForField((MappedFieldType)ArgumentMatchers.any(), (MappedFieldType.FielddataOperation)ArgumentMatchers.any())).then(args -> {
            MappedFieldType ft = (MappedFieldType)args.getArgument(0);
            MappedFieldType.FielddataOperation fdo = (MappedFieldType.FielddataOperation)args.getArgument(1);
            return ft.fielddataBuilder(new FieldDataContext("test", null, () -> ((SearchExecutionContext)context).lookup(), arg_0 -> ((SearchExecutionContext)context).sourcePath(arg_0), fdo)).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
        });
        Mockito.when((Object)context.getMatchingFieldNames((String)ArgumentMatchers.any())).thenReturn(Set.of("dummy_field"));
        return context;
    }

    public void testExistsQueryIsExpensive() {
        this.checkExpensiveQuery(MappedFieldType::existsQuery);
    }

    public void testExistsQueryInLoop() {
        this.checkLoop(MappedFieldType::existsQuery);
    }

    public void testRangeQueryWithShapeRelationIsError() {
        Exception e = (Exception)AbstractScriptFieldTypeTestCase.expectThrows(IllegalArgumentException.class, () -> this.simpleMappedFieldType().rangeQuery((Object)1, (Object)2, true, true, ShapeRelation.DISJOINT, null, null, null));
        AbstractScriptFieldTypeTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)("Runtime field [test] of type [" + this.typeName() + "] does not support DISJOINT ranges")));
    }

    public void testRangeQueryIsExpensive() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support range queries", (boolean)this.supportsRangeQueries());
        this.checkExpensiveQuery(this::randomRangeQuery);
    }

    public void testRangeQueryInLoop() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support range queries", (boolean)this.supportsRangeQueries());
        this.checkLoop(this::randomRangeQuery);
    }

    public void testTermQueryIsExpensive() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.checkExpensiveQuery(this::randomTermQuery);
    }

    public void testTermQueryInLoop() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.checkLoop(this::randomTermQuery);
    }

    public void testTermsQueryIsExpensive() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.checkExpensiveQuery(this::randomTermsQuery);
    }

    public void testTermsQueryInLoop() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.checkLoop(this::randomTermsQuery);
    }

    public void testPhraseQueryIsError() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.assertQueryOnlyOnText("phrase", () -> this.simpleMappedFieldType().phraseQuery(null, 1, false, null));
    }

    public void testPhrasePrefixQueryIsError() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.assertQueryOnlyOnText("phrase prefix", () -> this.simpleMappedFieldType().phrasePrefixQuery(null, 1, 1, null));
    }

    public void testMultiPhraseQueryIsError() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.assertQueryOnlyOnText("phrase", () -> this.simpleMappedFieldType().multiPhraseQuery(null, 1, false, null));
    }

    public void testSpanPrefixQueryIsError() {
        AbstractScriptFieldTypeTestCase.assumeTrue((String)"Impl does not support term queries", (boolean)this.supportsTermQueries());
        this.assertQueryOnlyOnText("span prefix", () -> this.simpleMappedFieldType().spanPrefixQuery(null, null, null));
    }

    public final void testCacheable() throws IOException {
        XContentBuilder mapping = AbstractScriptFieldTypeTestCase.runtimeMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startObject("field").field("type", this.typeName()).startObject("script").field("source", "dummy_source").field("lang", "test").endObject().endObject().startObject("field_source").field("type", this.typeName()).startObject("script").field("source", "deterministic_source").field("lang", "test").endObject().endObject()));
        MapperService mapperService = this.createMapperService(mapping);
        SearchExecutionContext c = this.createSearchExecutionContext(mapperService);
        c.getFieldType("field").existsQuery(c);
        AbstractScriptFieldTypeTestCase.assertFalse((boolean)c.isCacheable());
        c = this.createSearchExecutionContext(mapperService);
        c.getFieldType("field_source").existsQuery(c);
        AbstractScriptFieldTypeTestCase.assertTrue((boolean)c.isCacheable());
    }

    protected final List<Object> blockLoaderReadValuesFromColumnAtATimeReader(DirectoryReader reader, MappedFieldType fieldType, int offset) throws IOException {
        BlockLoader loader = fieldType.blockLoader(this.blContext());
        ArrayList<Object> all = new ArrayList<Object>();
        for (LeafReaderContext ctx : reader.leaves()) {
            TestBlock block = (TestBlock)loader.columnAtATimeReader(ctx).read(TestBlock.factory(), TestBlock.docs(ctx), offset);
            for (int i = 0; i < block.size(); ++i) {
                all.add(block.get(i));
            }
        }
        return all;
    }

    protected final List<Object> blockLoaderReadValuesFromRowStrideReader(DirectoryReader reader, MappedFieldType fieldType) throws IOException {
        BlockLoader loader = fieldType.blockLoader(this.blContext());
        ArrayList<Object> all = new ArrayList<Object>();
        for (LeafReaderContext ctx : reader.leaves()) {
            BlockLoader.RowStrideReader blockReader = loader.rowStrideReader(ctx);
            BlockLoader.Builder builder = loader.builder(TestBlock.factory(), ctx.reader().numDocs());
            for (int i = 0; i < ctx.reader().numDocs(); ++i) {
                blockReader.read(i, null, builder);
            }
            TestBlock block = (TestBlock)builder.build();
            for (int i = 0; i < block.size(); ++i) {
                all.add(block.get(i));
            }
        }
        return all;
    }

    private MappedFieldType.BlockLoaderContext blContext() {
        return new MappedFieldType.BlockLoaderContext(){

            public String indexName() {
                throw new UnsupportedOperationException();
            }

            public IndexSettings indexSettings() {
                throw new UnsupportedOperationException();
            }

            public MappedFieldType.FieldExtractPreference fieldExtractPreference() {
                return MappedFieldType.FieldExtractPreference.NONE;
            }

            public SearchLookup lookup() {
                return AbstractScriptFieldTypeTestCase.mockContext().lookup();
            }

            public Set<String> sourcePaths(String name) {
                throw new UnsupportedOperationException();
            }

            public String parentField(String field) {
                throw new UnsupportedOperationException();
            }

            public FieldNamesFieldMapper.FieldNamesFieldType fieldNames() {
                return FieldNamesFieldMapper.FieldNamesFieldType.get((boolean)true);
            }
        };
    }

    private void assertQueryOnlyOnText(String queryName, LuceneTestCase.ThrowingRunnable buildQuery) {
        Exception e = (Exception)AbstractScriptFieldTypeTestCase.expectThrows(IllegalArgumentException.class, (LuceneTestCase.ThrowingRunnable)buildQuery);
        AbstractScriptFieldTypeTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)("Can only use " + queryName + " queries on text fields - not on [test] which is a runtime field of type [" + this.typeName() + "]")));
    }

    protected final String readSource(IndexReader reader, int docId) throws IOException {
        return reader.document(docId).getBinaryValue("_source").utf8ToString();
    }

    protected final void checkExpensiveQuery(BiConsumer<MappedFieldType, SearchExecutionContext> queryBuilder) {
        Exception e = (Exception)AbstractScriptFieldTypeTestCase.expectThrows(ElasticsearchException.class, () -> queryBuilder.accept(this.simpleMappedFieldType(), AbstractScriptFieldTypeTestCase.mockContext(false)));
        AbstractScriptFieldTypeTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)"queries cannot be executed against runtime fields while [search.allow_expensive_queries] is set to [false]."));
    }

    protected final void checkLoop(BiConsumer<MappedFieldType, SearchExecutionContext> queryBuilder) {
        Exception e = (Exception)AbstractScriptFieldTypeTestCase.expectThrows(IllegalArgumentException.class, () -> queryBuilder.accept(this.loopFieldType(), AbstractScriptFieldTypeTestCase.mockContext()));
        AbstractScriptFieldTypeTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)"Cyclic dependency detected while resolving runtime fields: test -> test"));
    }

    protected final void minimalMapping(XContentBuilder b) throws IOException {
        b.field("type", this.typeName());
        b.startObject("script").field("source", "dummy_source").field("lang", "test").endObject();
    }

    protected abstract ScriptFactory parseFromSource();

    protected abstract ScriptFactory dummyScript();

    @Override
    protected <T> T compileScript(Script script, ScriptContext<T> context) {
        boolean deterministicSource = "deterministic_source".equals(script.getIdOrCode());
        return (T)(deterministicSource ? this.parseFromSource() : this.dummyScript());
    }
}

