/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers;

import java.util.List;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.datageneration.matchers.GenericEqualsMatcher;
import org.elasticsearch.datageneration.matchers.MatchResult;
import org.elasticsearch.datageneration.matchers.Messages;
import org.elasticsearch.xcontent.XContentBuilder;

public class ListEqualMatcher
extends GenericEqualsMatcher<List<?>> {
    public ListEqualMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings, List<?> actual, List<?> expected, boolean ignoringSort) {
        super(actualMappings, actualSettings, expectedMappings, expectedSettings, actual, expected, ignoringSort);
    }

    @Override
    public MatchResult match() {
        return this.matchListEquals((List)this.actual, (List)this.expected, this.ignoringSort);
    }

    private MatchResult matchListEquals(List<Object> actualList, List<Object> expectedList, boolean ignoreSorting) {
        if (actualList.size() != expectedList.size()) {
            return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "List lengths do not match, " + Messages.prettyPrintCollections(actualList, expectedList)));
        }
        if (ignoreSorting) {
            return ListEqualMatcher.matchListsEqualIgnoringSorting(actualList, expectedList) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Lists do not match when ignoring sort order, " + Messages.prettyPrintCollections(actualList, expectedList)));
        }
        return ListEqualMatcher.matchListsEqualExact(actualList, expectedList) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Lists do not match exactly, " + Messages.prettyPrintCollections(actualList, expectedList)));
    }

    private static boolean matchListsEqualIgnoringSorting(List<Object> actualList, List<Object> expectedList) {
        return actualList.containsAll(expectedList) && expectedList.containsAll(actualList);
    }

    private static <T> boolean matchListsEqualExact(List<Object> actualList, List<Object> expectedList) {
        for (int i = 0; i < actualList.size(); ++i) {
            boolean isEqual = actualList.get(i).equals(expectedList.get(i));
            if (isEqual) continue;
            return false;
        }
        return true;
    }
}

