/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration;

import org.elasticsearch.datageneration.FieldDataGenerator;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.fields.leaf.BooleanFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ByteFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ConstantKeywordFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.CountedKeywordFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.DateFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.DoubleFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.FloatFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.GeoPointFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.HalfFloatFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.IntegerFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.IpFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.KeywordFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.LongFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ScaledFloatFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ShortFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.TextFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.UnsignedLongFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.WildcardFieldDataGenerator;

public enum FieldType {
    KEYWORD("keyword"),
    LONG("long"),
    UNSIGNED_LONG("unsigned_long"),
    INTEGER("integer"),
    SHORT("short"),
    BYTE("byte"),
    DOUBLE("double"),
    FLOAT("float"),
    HALF_FLOAT("half_float"),
    SCALED_FLOAT("scaled_float"),
    COUNTED_KEYWORD("counted_keyword"),
    BOOLEAN("boolean"),
    DATE("date"),
    GEO_POINT("geo_point"),
    TEXT("text"),
    IP("ip"),
    CONSTANT_KEYWORD("constant_keyword"),
    WILDCARD("wildcard");

    private final String name;

    private FieldType(String name) {
        this.name = name;
    }

    public FieldDataGenerator generator(String fieldName, DataSource dataSource) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case KEYWORD -> new KeywordFieldDataGenerator(dataSource);
            case LONG -> new LongFieldDataGenerator(fieldName, dataSource);
            case UNSIGNED_LONG -> new UnsignedLongFieldDataGenerator(fieldName, dataSource);
            case INTEGER -> new IntegerFieldDataGenerator(fieldName, dataSource);
            case SHORT -> new ShortFieldDataGenerator(fieldName, dataSource);
            case BYTE -> new ByteFieldDataGenerator(fieldName, dataSource);
            case DOUBLE -> new DoubleFieldDataGenerator(fieldName, dataSource);
            case FLOAT -> new FloatFieldDataGenerator(fieldName, dataSource);
            case HALF_FLOAT -> new HalfFloatFieldDataGenerator(fieldName, dataSource);
            case SCALED_FLOAT -> new ScaledFloatFieldDataGenerator(fieldName, dataSource);
            case COUNTED_KEYWORD -> new CountedKeywordFieldDataGenerator(fieldName, dataSource);
            case BOOLEAN -> new BooleanFieldDataGenerator(dataSource);
            case DATE -> new DateFieldDataGenerator(dataSource);
            case GEO_POINT -> new GeoPointFieldDataGenerator(dataSource);
            case TEXT -> new TextFieldDataGenerator(dataSource);
            case IP -> new IpFieldDataGenerator(dataSource);
            case CONSTANT_KEYWORD -> new ConstantKeywordFieldDataGenerator();
            case WILDCARD -> new WildcardFieldDataGenerator(dataSource);
        };
    }

    public static FieldType tryParse(String name) {
        return switch (name) {
            case "keyword" -> KEYWORD;
            case "long" -> LONG;
            case "unsigned_long" -> UNSIGNED_LONG;
            case "integer" -> INTEGER;
            case "short" -> SHORT;
            case "byte" -> BYTE;
            case "double" -> DOUBLE;
            case "float" -> FLOAT;
            case "half_float" -> HALF_FLOAT;
            case "scaled_float" -> SCALED_FLOAT;
            case "counted_keyword" -> COUNTED_KEYWORD;
            case "boolean" -> BOOLEAN;
            case "date" -> DATE;
            case "geo_point" -> GEO_POINT;
            case "text" -> TEXT;
            case "ip" -> IP;
            case "constant_keyword" -> CONSTANT_KEYWORD;
            case "wildcard" -> WILDCARD;
            default -> null;
        };
    }

    public String toString() {
        return this.name;
    }
}

