/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;

public class LeafDocLookup
implements Map<String, ScriptDocValues<?>> {
    private final Function<String, MappedFieldType> fieldTypeLookup;
    private final BiFunction<MappedFieldType, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup;
    private final LeafReaderContext reader;
    private int docId = -1;
    final Map<String, FieldFactoryWrapper> fieldFactoryCache = Maps.newMapWithExpectedSize(4);
    final Map<String, FieldFactoryWrapper> docFactoryCache = Maps.newMapWithExpectedSize(4);

    LeafDocLookup(Function<String, MappedFieldType> fieldTypeLookup, BiFunction<MappedFieldType, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup, LeafReaderContext reader) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.fieldDataLookup = fieldDataLookup;
        this.reader = reader;
    }

    public void setDocument(int docId) {
        this.docId = docId;
    }

    private FieldFactoryWrapper getFactoryForField(String fieldName) {
        MappedFieldType fieldType = this.fieldTypeLookup.apply(fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping");
        }
        IndexFieldData<?> indexFieldData = this.fieldDataLookup.apply(fieldType, MappedFieldType.FielddataOperation.SCRIPT);
        FieldFactoryWrapper docFactory = null;
        if (!this.docFactoryCache.isEmpty()) {
            docFactory = this.docFactoryCache.get(fieldName);
        }
        FieldFactoryWrapper fieldFactory = docFactory != null && !(indexFieldData instanceof SourceValueFetcherIndexFieldData) ? docFactory : new FieldFactoryWrapper(indexFieldData.load(this.reader).getScriptFieldFactory(fieldName));
        this.fieldFactoryCache.put(fieldName, fieldFactory);
        return fieldFactory;
    }

    public Field<?> getScriptField(String fieldName) {
        FieldFactoryWrapper factoryWrapper = this.fieldFactoryCache.get(fieldName);
        if (factoryWrapper == null) {
            factoryWrapper = this.getFactoryForField(fieldName);
        }
        factoryWrapper.advanceToDoc();
        return factoryWrapper.factory.toScriptField();
    }

    private FieldFactoryWrapper getFactoryForDoc(String fieldName) {
        IndexFieldData<?> fieldIndexFieldData;
        MappedFieldType fieldType = this.fieldTypeLookup.apply(fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping");
        }
        FieldFactoryWrapper docFactory = null;
        FieldFactoryWrapper fieldFactory = null;
        if (!this.fieldFactoryCache.isEmpty()) {
            fieldFactory = this.fieldFactoryCache.get(fieldName);
        }
        if (fieldFactory != null && !((fieldIndexFieldData = this.fieldDataLookup.apply(fieldType, MappedFieldType.FielddataOperation.SCRIPT)) instanceof SourceValueFetcherIndexFieldData)) {
            docFactory = fieldFactory;
        }
        if (docFactory == null) {
            IndexFieldData<?> indexFieldData = this.fieldDataLookup.apply(fieldType, MappedFieldType.FielddataOperation.SEARCH);
            docFactory = new FieldFactoryWrapper(indexFieldData.load(this.reader).getScriptFieldFactory(fieldName));
        }
        this.docFactoryCache.put(fieldName, docFactory);
        return docFactory;
    }

    @Override
    public ScriptDocValues<?> get(Object key) {
        String fieldName = key.toString();
        FieldFactoryWrapper factoryWrapper = this.docFactoryCache.get(fieldName);
        if (factoryWrapper == null) {
            factoryWrapper = this.getFactoryForDoc(key.toString());
        }
        factoryWrapper.advanceToDoc();
        return factoryWrapper.factory.toScriptDocValues();
    }

    @Override
    public boolean containsKey(Object key) {
        String fieldName = key.toString();
        return this.docFactoryCache.containsKey(key) || this.fieldFactoryCache.containsKey(key) || this.fieldTypeLookup.apply(fieldName) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> put(String key, ScriptDocValues<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends ScriptDocValues<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ScriptDocValues<?>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, ScriptDocValues<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }

    class FieldFactoryWrapper {
        final DocValuesScriptFieldFactory factory;

        FieldFactoryWrapper(DocValuesScriptFieldFactory factory) {
            this.factory = factory;
        }

        void advanceToDoc() {
            try {
                this.factory.setNextDocId(LeafDocLookup.this.docId);
            }
            catch (IOException ioe) {
                throw ExceptionsHelper.convertToElastic(ioe);
            }
        }
    }
}

