/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.bucket.filter.FilterByFilterAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class FiltersAggregator
extends BucketsAggregator {
    public static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    public static final ParseField OTHER_BUCKET_FIELD = new ParseField("other_bucket", new String[0]);
    public static final ParseField OTHER_BUCKET_KEY_FIELD = new ParseField("other_bucket_key", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    private final List<QueryToFilterAdapter> filters;
    private final boolean keyed;
    private final boolean keyedBucket;
    protected final String otherBucketKey;

    public static FiltersAggregator build(String name, final AggregatorFactories factories, List<QueryToFilterAdapter> filters, boolean keyed, String otherBucketKey, boolean keyedBucket, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        FilterByFilterAggregator.AdapterBuilder<FilterByFilterAggregator> filterByFilterBuilder = new FilterByFilterAggregator.AdapterBuilder<FilterByFilterAggregator>(name, keyed, keyedBucket, otherBucketKey, context, parent, cardinality, metadata){

            @Override
            protected FilterByFilterAggregator adapt(CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> delegate) throws IOException {
                return (FilterByFilterAggregator)delegate.apply((Object)factories);
            }
        };
        for (QueryToFilterAdapter f : filters) {
            filterByFilterBuilder.add(f);
        }
        FilterByFilterAggregator filterByFilter = (FilterByFilterAggregator)filterByFilterBuilder.build();
        if (filterByFilter != null) {
            return filterByFilter;
        }
        return new Compatible(name, factories, filters, keyed, keyedBucket, otherBucketKey, context, parent, cardinality, metadata);
    }

    FiltersAggregator(String name, AggregatorFactories factories, List<QueryToFilterAdapter> filters, boolean keyed, boolean keyedBucket, String otherBucketKey, AggregationContext aggCtx, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggCtx, parent, cardinality.multiply(filters.size() + (otherBucketKey == null ? 0 : 1)), metadata);
        this.filters = List.copyOf(filters);
        this.keyed = keyed;
        this.keyedBucket = keyedBucket;
        this.otherBucketKey = otherBucketKey;
    }

    List<QueryToFilterAdapter> filters() {
        return this.filters;
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        return this.buildAggregationsForFixedBucketCount(owningBucketOrds, this.filters.size() + (this.otherBucketKey == null ? 0 : 1), (offsetInOwningOrd, docCount, subAggregationResults) -> {
            if (offsetInOwningOrd < this.filters.size()) {
                return new InternalFilters.InternalBucket(this.filters.get(offsetInOwningOrd).key(), docCount, subAggregationResults);
            }
            return new InternalFilters.InternalBucket(this.otherBucketKey, docCount, subAggregationResults);
        }, buckets -> new InternalFilters(this.name, (List<InternalFilters.InternalBucket>)buckets, this.keyed, this.keyedBucket, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList<InternalFilters.InternalBucket> buckets = new ArrayList<InternalFilters.InternalBucket>(this.filters.size() + (this.otherBucketKey == null ? 0 : 1));
        for (QueryToFilterAdapter filter : this.filters) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(filter.key(), 0L, subAggs);
            buckets.add(bucket);
        }
        if (this.otherBucketKey != null) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.otherBucketKey, 0L, subAggs);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.keyedBucket, this.metadata());
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        ArrayList filtersDebug = new ArrayList(this.filters.size());
        for (QueryToFilterAdapter filter : this.filters) {
            HashMap debug = new HashMap();
            filter.collectDebugInfo(debug::put);
            filtersDebug.add(debug);
        }
        add.accept("filters", filtersDebug);
    }

    static class Compatible
    extends FiltersAggregator {
        private final int totalNumKeys;

        Compatible(String name, AggregatorFactories factories, List<QueryToFilterAdapter> filters, boolean keyed, boolean keyedBucket, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, filters, keyed, keyedBucket, otherBucketKey, context, parent, cardinality, metadata);
            this.totalNumKeys = otherBucketKey == null ? filters.size() : filters.size() + 1;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
            boolean usesCompetitiveIterator;
            if (QueryToFilterAdapter.matchesNoDocs(this.filters()) && this.otherBucketKey == null) {
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            int numFilters = this.filters().size();
            ArrayList<FilterMatchingDisiWrapper> filterWrappers = new ArrayList<FilterMatchingDisiWrapper>();
            long totalCost = 0L;
            this.addRequestCircuitBreakerBytes(0L);
            for (int filterOrd = 0; filterOrd < numFilters; ++filterOrd) {
                Scorer randomAccessScorer = this.filters().get(filterOrd).randomAccessScorer(aggCtx.getLeafReaderContext());
                if (randomAccessScorer == null) continue;
                this.addRequestCircuitBreakerBytes(0L);
                totalCost += randomAccessScorer.iterator().cost();
                filterWrappers.add(randomAccessScorer.twoPhaseIterator() == null ? new FilterMatchingDisiWrapper(randomAccessScorer, filterOrd) : new TwoPhaseFilterMatchingDisiWrapper(randomAccessScorer, filterOrd));
            }
            boolean hasOtherBucket = this.otherBucketKey != null;
            boolean bl = usesCompetitiveIterator = this.parent == null && !hasOtherBucket && !filterWrappers.isEmpty() && totalCost < (long)aggCtx.getLeafReaderContext().reader().maxDoc();
            if (filterWrappers.size() == 1) {
                return new SingleFilterLeafCollector(sub, (FilterMatchingDisiWrapper)((Object)filterWrappers.get(0)), numFilters, this.totalNumKeys, usesCompetitiveIterator, hasOtherBucket);
            }
            return new MultiFilterLeafCollector(sub, filterWrappers, numFilters, this.totalNumKeys, usesCompetitiveIterator, hasOtherBucket);
        }
    }

    static class Counter
    implements LeafCollector {
        final DocCountProvider docCount;
        private long count;

        Counter(DocCountProvider docCount) {
            this.docCount = docCount;
        }

        public long readAndReset(LeafReaderContext ctx) throws IOException {
            long result = this.count;
            this.count = 0L;
            this.docCount.setLeafReaderContext(ctx);
            return result;
        }

        public void collect(int doc) throws IOException {
            this.count += (long)this.docCount.getDocCount(doc);
        }

        public void setScorer(Scorable scorer) throws IOException {
        }
    }

    private static class TwoPhaseFilterMatchingDisiWrapper
    extends FilterMatchingDisiWrapper {
        int lastMatchingDoc = -1;
        int lastCheckedDoc = -1;

        TwoPhaseFilterMatchingDisiWrapper(Scorer scorer, int ord) {
            super(scorer, ord);
        }

        @Override
        boolean checkDocForMatch(int doc) throws IOException {
            if (this.lastCheckedDoc < doc) {
                this.lastCheckedDoc = doc;
                if (this.twoPhaseView.matches()) {
                    this.lastMatchingDoc = doc;
                }
            }
            return this.lastMatchingDoc == doc;
        }
    }

    private static class FilterMatchingDisiWrapper
    extends DisiWrapper {
        final int filterOrd;

        FilterMatchingDisiWrapper(Scorer scorer, int ord) {
            super(scorer);
            this.filterOrd = ord;
        }

        boolean checkDocForMatch(int doc) throws IOException {
            return true;
        }
    }

    private class MultiFilterLeafCollector
    extends AbstractLeafCollector {
        final DisiPriorityQueue filterIterators;

        MultiFilterLeafCollector(LeafBucketCollector sub, List<FilterMatchingDisiWrapper> filterWrappers, int numFilters, int totalNumKeys, boolean usesCompetitiveIterator, boolean hasOtherBucket) {
            super(sub, numFilters, totalNumKeys, usesCompetitiveIterator, hasOtherBucket);
            this.filterIterators = filterWrappers.isEmpty() ? null : new DisiPriorityQueue(filterWrappers.size());
            for (FilterMatchingDisiWrapper wrapper : filterWrappers) {
                this.filterIterators.add((DisiWrapper)wrapper);
            }
        }

        @Override
        public void collect(int doc, long bucket) throws IOException {
            boolean matched = false;
            if (this.filterIterators != null) {
                DisiWrapper top = this.filterIterators.top();
                while (top.doc < doc) {
                    top.doc = top.approximation.advance(doc);
                    top = this.filterIterators.updateTop();
                }
                if (top.doc == doc) {
                    DisiWrapper w = this.filterIterators.topList();
                    while (w != null) {
                        FilterMatchingDisiWrapper topMatch = (FilterMatchingDisiWrapper)w;
                        if (topMatch.checkDocForMatch(doc)) {
                            FiltersAggregator.this.collectBucket(this.sub, doc, this.bucketOrd(bucket, topMatch.filterOrd));
                            matched = true;
                        }
                        w = w.next;
                    }
                }
            }
            if (this.hasOtherBucket && !matched) {
                FiltersAggregator.this.collectBucket(this.sub, doc, this.bucketOrd(bucket, this.numFilters));
            }
        }

        public DocIdSetIterator competitiveIterator() throws IOException {
            if (this.usesCompetitiveIterator) {
                assert (this.filterIterators != null);
                return new DisjunctionDISIApproximation(this.filterIterators);
            }
            return null;
        }
    }

    private class SingleFilterLeafCollector
    extends AbstractLeafCollector {
        final FilterMatchingDisiWrapper filterWrapper;

        SingleFilterLeafCollector(LeafBucketCollector sub, FilterMatchingDisiWrapper filterWrapper, int numFilters, int totalNumKeys, boolean usesCompetitiveIterator, boolean hasOtherBucket) {
            super(sub, numFilters, totalNumKeys, usesCompetitiveIterator, hasOtherBucket);
            this.filterWrapper = filterWrapper;
        }

        @Override
        public void collect(int doc, long bucket) throws IOException {
            if (this.filterWrapper.approximation.docID() < doc) {
                this.filterWrapper.approximation.advance(doc);
            }
            boolean matched = false;
            if (this.filterWrapper.approximation.docID() == doc && this.filterWrapper.checkDocForMatch(doc)) {
                FiltersAggregator.this.collectBucket(this.sub, doc, this.bucketOrd(bucket, this.filterWrapper.filterOrd));
                matched = true;
            }
            if (this.hasOtherBucket && !matched) {
                FiltersAggregator.this.collectBucket(this.sub, doc, this.bucketOrd(bucket, this.numFilters));
            }
        }

        public DocIdSetIterator competitiveIterator() throws IOException {
            if (this.usesCompetitiveIterator) {
                return this.filterWrapper.approximation;
            }
            return null;
        }
    }

    private static abstract class AbstractLeafCollector
    extends LeafBucketCollectorBase {
        final LeafBucketCollector sub;
        final int numFilters;
        final int totalNumKeys;
        final boolean usesCompetitiveIterator;
        final boolean hasOtherBucket;

        AbstractLeafCollector(LeafBucketCollector sub, int numFilters, int totalNumKeys, boolean usesCompetitiveIterator, boolean hasOtherBucket) {
            super(sub, null);
            this.sub = sub;
            this.numFilters = numFilters;
            this.totalNumKeys = totalNumKeys;
            this.usesCompetitiveIterator = usesCompetitiveIterator;
            this.hasOtherBucket = hasOtherBucket;
        }

        final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
            return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
        }
    }

    public static class KeyedFilter
    implements Writeable,
    ToXContentFragment {
        private final String key;
        private final QueryBuilder filter;

        public KeyedFilter(String key, QueryBuilder filter) {
            if (key == null) {
                throw new IllegalArgumentException("[key] must not be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("[filter] must not be null");
            }
            this.key = key;
            this.filter = filter;
        }

        public KeyedFilter(StreamInput in) throws IOException {
            this.key = in.readString();
            this.filter = in.readNamedWriteable(QueryBuilder.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeNamedWriteable(this.filter);
        }

        public String key() {
            return this.key;
        }

        public QueryBuilder filter() {
            return this.filter;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.key, (ToXContent)this.filter);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyedFilter other = (KeyedFilter)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter);
        }
    }
}

