/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.DeflateCompressor;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class CompressedXContent
implements Writeable {
    private static final ThreadLocal<InflaterAndBuffer> inflater = ThreadLocal.withInitial(InflaterAndBuffer::new);
    private static final ThreadLocal<BytesStreamOutput> baos = ThreadLocal.withInitial(BytesStreamOutput::new);
    private final byte[] bytes;
    private final String sha256;

    private static String sha256(BytesReference data) {
        MessageDigest messageDigest = MessageDigests.sha256();
        try {
            data.writeTo(new DigestOutputStream(Streams.NULL_OUTPUT_STREAM, messageDigest));
        }
        catch (IOException bogus) {
            throw new Error(bogus);
        }
        return Base64.getEncoder().encodeToString(messageDigest.digest());
    }

    private static String sha256FromCompressed(byte[] compressed) {
        MessageDigest messageDigest = MessageDigests.sha256();
        InflaterAndBuffer inflaterAndBuffer = inflater.get();
        try {
            Inflater inflater = inflaterAndBuffer.inflater;
            ByteBuffer buffer = inflaterAndBuffer.buffer;
            assert (CompressedXContent.assertBufferIsCleared(buffer));
            CompressedXContent.setInflaterInput(compressed, inflater);
            do {
                if (inflater.inflate(buffer) > 0) {
                    messageDigest.update(buffer.flip());
                }
                buffer.clear();
            } while (!inflater.finished());
            String string = Base64.getEncoder().encodeToString(messageDigest.digest());
            if (inflaterAndBuffer != null) {
                inflaterAndBuffer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (inflaterAndBuffer != null) {
                    try {
                        inflaterAndBuffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (DataFormatException e) {
                throw new ElasticsearchException(e);
            }
        }
    }

    private CompressedXContent(byte[] compressed, String sha256) {
        this.bytes = compressed;
        this.sha256 = sha256;
        this.assertConsistent();
    }

    public CompressedXContent(Map<String, Object> map) throws IOException {
        this((builder, params) -> builder.mapContents(map), ToXContent.EMPTY_PARAMS);
    }

    public CompressedXContent(ToXContent xcontent) throws IOException {
        this(xcontent, ToXContent.EMPTY_PARAMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressedXContent(ToXContent xcontent, ToXContent.Params params) throws IOException {
        MessageDigest messageDigest = MessageDigests.sha256();
        BytesStreamOutput bStream = baos.get();
        try {
            DigestOutputStream checkedStream = new DigestOutputStream(CompressorFactory.COMPRESSOR.threadLocalOutputStream(bStream), messageDigest);
            try (XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)checkedStream);){
                if (xcontent.isFragment()) {
                    builder.startObject();
                }
                xcontent.toXContent(builder, params);
                if (xcontent.isFragment()) {
                    builder.endObject();
                }
            }
            this.bytes = bStream.copyBytes().array();
        }
        finally {
            bStream.reset();
        }
        this.sha256 = Base64.getEncoder().encodeToString(messageDigest.digest());
        this.assertConsistent();
    }

    public CompressedXContent(BytesReference data) throws IOException {
        Compressor compressor = CompressorFactory.compressorForUnknownXContentType(data);
        if (compressor != null) {
            this.bytes = BytesReference.toBytes(data);
            this.sha256 = CompressedXContent.sha256FromCompressed(this.bytes);
        } else {
            this.bytes = BytesReference.toBytes(CompressorFactory.COMPRESSOR.compress(data));
            this.sha256 = CompressedXContent.sha256(data);
        }
        this.assertConsistent();
    }

    private void assertConsistent() {
        assert (CompressorFactory.compressorForUnknownXContentType(new BytesArray(this.bytes)) != null);
        assert (this.sha256.equals(CompressedXContent.sha256(this.uncompressed())));
        assert (this.sha256.equals(CompressedXContent.sha256FromCompressed(this.bytes)));
    }

    public CompressedXContent(byte[] data) throws IOException {
        this(new BytesArray(data));
    }

    public static CompressedXContent fromJSON(String json) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, json);){
            CompressedXContent compressedXContent = new CompressedXContent((ToXContent)((ToXContentObject)(builder, params) -> builder.copyCurrentStructure(parser)));
            return compressedXContent;
        }
    }

    public CompressedXContent(String str) throws IOException {
        this(new BytesArray(str.getBytes(StandardCharsets.UTF_8)));
    }

    public byte[] compressed() {
        return this.bytes;
    }

    public BytesReference compressedReference() {
        return new BytesArray(this.bytes);
    }

    public BytesReference uncompressed() {
        try {
            return CompressorFactory.uncompress(new BytesArray(this.bytes));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot decompress compressed string", e);
        }
    }

    public String string() {
        return this.uncompressed().utf8ToString();
    }

    public String getSha256() {
        return this.sha256;
    }

    public static CompressedXContent readCompressedString(StreamInput in) throws IOException {
        byte[] compressedData;
        String sha256;
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            sha256 = in.readString();
            compressedData = in.readByteArray();
        } else {
            int crc32 = in.readInt();
            compressedData = in.readByteArray();
            sha256 = CompressedXContent.sha256FromCompressed(compressedData);
        }
        return new CompressedXContent(compressedData, sha256);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            out.writeString(this.sha256);
        } else {
            int crc32 = CompressedXContent.crc32FromCompressed(this.bytes);
            out.writeInt(crc32);
        }
        out.writeByteArray(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressedXContent that = (CompressedXContent)o;
        return this.sha256.equals(that.sha256);
    }

    public void copyTo(XContentBuilder builder) throws IOException {
        try (InputStream decompressed = CompressorFactory.COMPRESSOR.threadLocalInputStream(new ByteArrayInputStream(this.bytes));
             XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, decompressed);){
            builder.copyCurrentStructure(parser);
        }
    }

    public int hashCode() {
        return this.sha256.hashCode();
    }

    public String toString() {
        return this.string();
    }

    private static int crc32FromCompressed(byte[] compressed) {
        CRC32 crc32 = new CRC32();
        InflaterAndBuffer inflaterAndBuffer = inflater.get();
        try {
            Inflater inflater = inflaterAndBuffer.inflater;
            ByteBuffer buffer = inflaterAndBuffer.buffer;
            assert (CompressedXContent.assertBufferIsCleared(buffer));
            CompressedXContent.setInflaterInput(compressed, inflater);
            do {
                if (inflater.inflate(buffer) > 0) {
                    crc32.update(buffer.flip());
                }
                buffer.clear();
            } while (!inflater.finished());
            int n = (int)crc32.getValue();
            if (inflaterAndBuffer != null) {
                inflaterAndBuffer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (inflaterAndBuffer != null) {
                    try {
                        inflaterAndBuffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (DataFormatException e) {
                throw new ElasticsearchException(e);
            }
        }
    }

    private static void setInflaterInput(byte[] compressed, Inflater inflater) {
        inflater.setInput(compressed, DeflateCompressor.HEADER_SIZE, compressed.length - DeflateCompressor.HEADER_SIZE);
    }

    private static boolean assertBufferIsCleared(ByteBuffer buffer) {
        assert (buffer.limit() == buffer.capacity()) : "buffer limit != capacity, was [" + buffer.limit() + "] and [" + buffer.capacity() + "]";
        assert (buffer.position() == 0) : "buffer position != 0, was [" + buffer.position() + "]";
        return true;
    }

    private static final class InflaterAndBuffer
    implements Releasable {
        final ByteBuffer buffer = ByteBuffer.allocate(4096);
        final Inflater inflater = new Inflater(true);

        private InflaterAndBuffer() {
        }

        public void close() {
            this.inflater.reset();
            this.buffer.clear();
        }
    }
}

