/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RotationShardShuffler;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.ShardShuffler;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class IndexRoutingTable
implements SimpleDiffable<IndexRoutingTable> {
    private static final List<Predicate<ShardRouting>> PRIORITY_REMOVE_CLAUSES = Stream.of(shardRouting -> !shardRouting.isPromotableToPrimary(), Predicates.always()).flatMap(p1 -> Stream.of(ShardRouting::unassigned, ShardRouting::initializing, Predicates.always()).map(p1::and)).toList();
    private final Index index;
    private final ShardShuffler shuffler;
    private final IndexShardRoutingTable[] shards;
    private final boolean allShardsActive;
    private final List<ShardRouting> allActiveShards;

    IndexRoutingTable(Index index, IndexShardRoutingTable[] shards) {
        this.index = index;
        this.shuffler = new RotationShardShuffler(Randomness.get().nextInt());
        this.shards = shards;
        int totalShardCount = 0;
        ArrayList<ShardRouting> allActiveShards = new ArrayList<ShardRouting>();
        for (IndexShardRoutingTable shard : shards) {
            allActiveShards.addAll(shard.activeShards());
            totalShardCount += shard.size();
        }
        this.allActiveShards = CollectionUtils.wrapUnmodifiableOrEmptySingleton(allActiveShards);
        this.allShardsActive = totalShardCount == allActiveShards.size();
    }

    public Index getIndex() {
        return this.index;
    }

    boolean validate(Metadata metadata) {
        if (!metadata.hasIndex(this.index.getName())) {
            throw new IllegalStateException(String.valueOf(this.index) + " exists in routing does not exists in metadata");
        }
        IndexMetadata indexMetadata = metadata.index(this.index.getName());
        if (!indexMetadata.getIndexUUID().equals(this.index.getUUID())) {
            throw new IllegalStateException(this.index.getName() + " exists in routing does not exists in metadata with the same uuid");
        }
        if (indexMetadata.getNumberOfShards() != this.shards.length) {
            HashSet<Integer> expected = new HashSet<Integer>();
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                expected.add(i);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : this.shards) {
                expected.remove(indexShardRoutingTable.shardId().id());
            }
            throw new IllegalStateException("Wrong number of shards in routing table, missing: " + String.valueOf(expected));
        }
        for (IndexShardRoutingTable indexShardRoutingTable : this.shards) {
            int routingNumberOfReplicas = indexShardRoutingTable.size() - 1;
            if (routingNumberOfReplicas != indexMetadata.getNumberOfReplicas()) {
                throw new IllegalStateException("Shard [" + indexShardRoutingTable.shardId().id() + "] routing table has wrong number of replicas, expected [" + indexMetadata.getNumberOfReplicas() + "], got [" + routingNumberOfReplicas + "]");
            }
            for (int copy = 0; copy < indexShardRoutingTable.size(); ++copy) {
                ShardRouting shardRouting = indexShardRoutingTable.shard(copy);
                if (!shardRouting.index().equals(this.index)) {
                    throw new IllegalStateException("shard routing has an index [" + String.valueOf(shardRouting.index()) + "] that is different from the routing table");
                }
                Set<String> inSyncAllocationIds = indexMetadata.inSyncAllocationIds(shardRouting.id());
                if (shardRouting.active() && shardRouting.isPromotableToPrimary() && !inSyncAllocationIds.contains(shardRouting.allocationId().getId())) {
                    throw new IllegalStateException("active shard routing " + String.valueOf(shardRouting) + " has no corresponding entry in the in-sync allocation set " + String.valueOf(inSyncAllocationIds));
                }
                if (!shardRouting.primary() || !shardRouting.initializing() || shardRouting.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE) continue;
                if (inSyncAllocationIds.contains("_forced_allocation_")) {
                    if (inSyncAllocationIds.size() == 1) continue;
                    throw new IllegalStateException("a primary shard routing " + String.valueOf(shardRouting) + " is a primary that is recovering from a stale primary has unexpected allocation ids in in-sync allocation set " + String.valueOf(inSyncAllocationIds));
                }
                if (inSyncAllocationIds.contains(shardRouting.allocationId().getId())) continue;
                throw new IllegalStateException("a primary shard routing " + String.valueOf(shardRouting) + " is a primary that is recovering from a known allocation id but has no corresponding entry in the in-sync allocation set " + String.valueOf(inSyncAllocationIds));
            }
        }
        return true;
    }

    public int numberOfNodesShardsAreAllocatedOn(String ... excludedNodes) {
        HashSet<String> nodes = new HashSet<String>();
        for (IndexShardRoutingTable shardRoutingTable : this.shards) {
            for (int copy = 0; copy < shardRoutingTable.size(); ++copy) {
                ShardRouting shardRouting = shardRoutingTable.shard(copy);
                if (!shardRouting.assignedToNode()) continue;
                String currentNodeId = shardRouting.currentNodeId();
                boolean excluded = false;
                if (excludedNodes != null) {
                    for (String excludedNode : excludedNodes) {
                        if (!currentNodeId.equals(excludedNode)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                nodes.add(currentNodeId);
            }
        }
        return nodes.size();
    }

    public int size() {
        return this.shards.length;
    }

    @Nullable
    public IndexShardRoutingTable shard(int shardId) {
        if (shardId > this.shards.length - 1) {
            return null;
        }
        return this.shards[shardId];
    }

    public Stream<IndexShardRoutingTable> allShards() {
        return Stream.of(this.shards);
    }

    public boolean allPrimaryShardsActive() {
        return this.primaryShardsActive() == this.shards.length;
    }

    public boolean readyForSearch(ClusterState clusterState) {
        for (IndexShardRoutingTable shardRoutingTable : this.shards) {
            boolean found = false;
            for (int idx = 0; idx < shardRoutingTable.size(); ++idx) {
                ShardRouting shardRouting = shardRoutingTable.shard(idx);
                if (!shardRouting.active() || !shardRouting.isSearchable()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean allShardsActive() {
        return this.allShardsActive;
    }

    public int primaryShardsActive() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this.shards) {
            if (!shardRoutingTable.primaryShard().active()) continue;
            ++counter;
        }
        return counter;
    }

    public boolean allPrimaryShardsUnassigned() {
        return this.primaryShardsUnassigned() == this.shards.length;
    }

    public int primaryShardsUnassigned() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this.shards) {
            if (!shardRoutingTable.primaryShard().unassigned()) continue;
            ++counter;
        }
        return counter;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexShardRoutingTable shardRoutingTable : this.shards) {
            shards.addAll(shardRoutingTable.shardsWithState(state));
        }
        return shards;
    }

    public ShardsIterator randomAllActiveShardsIt() {
        return new PlainShardsIterator(this.shuffler.shuffle(this.allActiveShards));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRoutingTable that = (IndexRoutingTable)o;
        if (!this.index.equals(that.index)) {
            return false;
        }
        return Arrays.equals(this.shards, that.shards);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + Arrays.hashCode(this.shards);
        return result;
    }

    public static IndexRoutingTable readFrom(StreamInput in) throws IOException {
        Index index = new Index(in);
        Builder builder = new Builder(ShardRoutingRoleStrategy.NO_SHARD_CREATION, index);
        int size = in.readVInt();
        builder.ensureShardArray(size);
        for (int i = 0; i < size; ++i) {
            builder.addIndexShard(IndexShardRoutingTable.Builder.readFromThin(in, index));
        }
        return builder.build();
    }

    public static Diff<IndexRoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(IndexRoutingTable::readFrom, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeArray((o, s) -> IndexShardRoutingTable.Builder.writeToThin(s, o), this.shards);
    }

    public static Builder builder(Index index) {
        return new Builder(ShardRoutingRoleStrategy.NO_SHARD_CREATION, index);
    }

    public static Builder builder(ShardRoutingRoleStrategy shardRoutingRoleStrategy, Index index) {
        return new Builder(shardRoutingRoleStrategy, index);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("-- index [" + String.valueOf(this.index) + "]\n");
        for (IndexShardRoutingTable indexShard : this.shards) {
            sb.append("----shard_id [").append(indexShard.shardId().getIndex().getName()).append("][").append(indexShard.shardId().id()).append("]\n");
            for (int copy = 0; copy < indexShard.size(); ++copy) {
                sb.append("--------").append(indexShard.shard(copy).shortSummary()).append("\n");
            }
        }
        return sb.toString();
    }

    public static class Builder {
        private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;
        private final Index index;
        private IndexShardRoutingTable.Builder[] shards;

        public Builder(ShardRoutingRoleStrategy shardRoutingRoleStrategy, Index index) {
            this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
            this.index = index;
        }

        public Builder initializeAsNew(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null), null);
        }

        public Builder initializeAsRecovery(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.CLUSTER_RECOVERED, null), null);
        }

        public Builder initializeAsFromDangling(IndexMetadata indexMetadata) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.DANGLING_INDEX_IMPORTED, null), null);
        }

        public Builder initializeAsFromCloseToOpen(IndexMetadata indexMetadata, IndexRoutingTable indexRoutingTable) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.INDEX_REOPENED, null), indexRoutingTable);
        }

        public Builder initializeAsFromOpenToClose(IndexMetadata indexMetadata, IndexRoutingTable indexRoutingTable) {
            return this.initializeEmpty(indexMetadata, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CLOSED, null), indexRoutingTable);
        }

        public Builder initializeAsNewRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource, Set<Integer> ignoreShards) {
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.NEW_INDEX_RESTORED, "restore_source[" + recoverySource.snapshot().getRepository() + "/" + recoverySource.snapshot().getSnapshotId().getName() + "]");
            return this.initializeAsRestore(indexMetadata, recoverySource, ignoreShards, true, unassignedInfo, null);
        }

        public Builder initializeAsRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource, IndexRoutingTable previousIndexRoutingTable) {
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.EXISTING_INDEX_RESTORED, "restore_source[" + recoverySource.snapshot().getRepository() + "/" + recoverySource.snapshot().getSnapshotId().getName() + "]");
            return this.initializeAsRestore(indexMetadata, recoverySource, null, false, unassignedInfo, previousIndexRoutingTable);
        }

        private Builder initializeAsRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource, Set<Integer> ignoreShards, boolean asNew, UnassignedInfo unassignedInfo, @Nullable IndexRoutingTable previousIndexRoutingTable) {
            assert (indexMetadata.getIndex().equals(this.index));
            if (this.shards != null) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            this.shards = new IndexShardRoutingTable.Builder[indexMetadata.getNumberOfShards()];
            for (int shardNumber = 0; shardNumber < indexMetadata.getNumberOfShards(); ++shardNumber) {
                ShardId shardId = new ShardId(this.index, shardNumber);
                List<String> previousNodes = Builder.getPreviousNodes(previousIndexRoutingTable, shardNumber);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder(shardId);
                for (int i = 0; i <= indexMetadata.getNumberOfReplicas(); ++i) {
                    boolean primary;
                    boolean bl = primary = i == 0;
                    if (asNew && ignoreShards.contains(shardNumber)) {
                        indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo, this.shardRoutingRoleStrategy.newRestoredRole(i)));
                        continue;
                    }
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? recoverySource : RecoverySource.PeerRecoverySource.INSTANCE, Builder.withLastAllocatedNodeId(unassignedInfo, previousNodes, i), this.shardRoutingRoleStrategy.newRestoredRole(i)));
                }
                this.shards[shardNumber] = indexShardRoutingBuilder;
            }
            return this;
        }

        private Builder initializeEmpty(IndexMetadata indexMetadata, UnassignedInfo unassignedInfo, @Nullable IndexRoutingTable previousIndexRoutingTable) {
            assert (indexMetadata.getIndex().equals(this.index));
            assert (previousIndexRoutingTable == null || previousIndexRoutingTable.size() == indexMetadata.getNumberOfShards());
            if (this.shards != null) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            this.shards = new IndexShardRoutingTable.Builder[indexMetadata.getNumberOfShards()];
            for (int shardNumber = 0; shardNumber < indexMetadata.getNumberOfShards(); ++shardNumber) {
                ShardId shardId = new ShardId(this.index, shardNumber);
                List<String> previousNodes = Builder.getPreviousNodes(previousIndexRoutingTable, shardNumber);
                RecoverySource primaryRecoverySource = !indexMetadata.inSyncAllocationIds(shardNumber).isEmpty() ? RecoverySource.ExistingStoreRecoverySource.INSTANCE : (indexMetadata.getResizeSourceIndex() != null ? RecoverySource.LocalShardsRecoverySource.INSTANCE : RecoverySource.EmptyStoreRecoverySource.INSTANCE);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder(shardId);
                for (int i = 0; i <= indexMetadata.getNumberOfReplicas(); ++i) {
                    boolean primary = i == 0;
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? primaryRecoverySource : RecoverySource.PeerRecoverySource.INSTANCE, Builder.withLastAllocatedNodeId(unassignedInfo, previousNodes, i), this.shardRoutingRoleStrategy.newEmptyRole(i)));
                }
                this.shards[shardNumber] = indexShardRoutingBuilder;
            }
            return this;
        }

        private static List<String> getPreviousNodes(@Nullable IndexRoutingTable previousIndexRoutingTable, int shardId) {
            if (previousIndexRoutingTable == null) {
                return null;
            }
            IndexShardRoutingTable previousShardRoutingTable = previousIndexRoutingTable.shard(shardId);
            if (previousShardRoutingTable == null) {
                return null;
            }
            String primaryNodeId = previousShardRoutingTable.primaryShard().currentNodeId();
            if (primaryNodeId == null) {
                return null;
            }
            ArrayList<String> previousNodes = new ArrayList<String>(previousShardRoutingTable.size());
            previousNodes.add(primaryNodeId);
            for (ShardRouting assignedShard : previousShardRoutingTable.assignedShards()) {
                if (assignedShard.initializing() && assignedShard.relocatingNodeId() != null) continue;
                String currentNodeId = assignedShard.currentNodeId();
                assert (currentNodeId != null);
                if (primaryNodeId.equals(currentNodeId)) continue;
                previousNodes.add(currentNodeId);
            }
            return previousNodes;
        }

        private static UnassignedInfo withLastAllocatedNodeId(UnassignedInfo unassignedInfo, List<String> previousNodes, int shardCopy) {
            return previousNodes == null || previousNodes.size() <= shardCopy ? unassignedInfo : new UnassignedInfo(unassignedInfo.reason(), unassignedInfo.message(), unassignedInfo.failure(), unassignedInfo.failedAllocations(), unassignedInfo.unassignedTimeNanos(), unassignedInfo.unassignedTimeMillis(), unassignedInfo.delayed(), unassignedInfo.lastAllocationStatus(), unassignedInfo.failedNodeIds(), previousNodes.get(shardCopy));
        }

        public Builder addReplica(ShardRouting.Role role) {
            assert (this.shards != null);
            for (IndexShardRoutingTable.Builder existing : this.shards) {
                assert (existing != null);
                existing.addShard(ShardRouting.newUnassigned(existing.shardId(), false, RecoverySource.PeerRecoverySource.INSTANCE, new UnassignedInfo(UnassignedInfo.Reason.REPLICA_ADDED, null), role));
            }
            return this;
        }

        public Builder removeReplica() {
            assert (this.shards != null);
            for (int shardId = 0; shardId < this.shards.length; ++shardId) {
                IndexShardRoutingTable.Builder found = this.shards[shardId];
                assert (found != null);
                IndexShardRoutingTable indexShard = found.build();
                if (indexShard.replicaShards().isEmpty()) {
                    return this;
                }
                IndexShardRoutingTable.Builder builder = IndexShardRoutingTable.builder(indexShard.shardId());
                for (int copy = 0; copy < indexShard.size(); ++copy) {
                    ShardRouting shardRouting = indexShard.shard(copy);
                    builder.addShard(shardRouting);
                }
                block2: for (Predicate<ShardRouting> removeClause : PRIORITY_REMOVE_CLAUSES) {
                    for (int copy = 0; copy < indexShard.size(); ++copy) {
                        ShardRouting shardRouting = indexShard.shard(copy);
                        if (shardRouting.primary() || !removeClause.test(shardRouting)) continue;
                        builder.removeShard(shardRouting);
                        break block2;
                    }
                }
                this.shards[shardId] = builder;
            }
            return this;
        }

        public Builder addIndexShard(IndexShardRoutingTable.Builder indexShard) {
            assert (indexShard.shardId().getIndex().equals(this.index)) : "cannot add shard routing table for " + String.valueOf(indexShard.shardId()) + " to index routing table for " + String.valueOf(this.index);
            int sid = indexShard.shardId().id();
            this.ensureShardArray(sid + 1);
            this.shards[sid] = indexShard;
            return this;
        }

        public Builder addShard(ShardRouting shard) {
            assert (shard.index().equals(this.index)) : "cannot add [" + String.valueOf(shard) + "] to routing table for " + String.valueOf(this.index);
            int shardId = shard.id();
            this.ensureShardArray(shardId + 1);
            IndexShardRoutingTable.Builder indexShard = this.shards[shardId];
            if (indexShard == null) {
                this.shards[shardId] = IndexShardRoutingTable.builder(shard.shardId()).addShard(shard);
            } else {
                indexShard.addShard(shard);
            }
            return this;
        }

        void ensureShardArray(int shardCount) {
            if (this.shards == null) {
                this.shards = new IndexShardRoutingTable.Builder[shardCount];
            } else if (this.shards.length < shardCount) {
                IndexShardRoutingTable.Builder[] updated = new IndexShardRoutingTable.Builder[shardCount];
                System.arraycopy(this.shards, 0, updated, 0, this.shards.length);
                this.shards = updated;
            }
        }

        public IndexRoutingTable build() {
            IndexShardRoutingTable[] res;
            if (this.shards != null) {
                res = new IndexShardRoutingTable[this.shards.length];
                for (int i = 0; i < this.shards.length; ++i) {
                    res[i] = this.shards[i].build();
                }
            } else {
                res = new IndexShardRoutingTable[]{};
            }
            return new IndexRoutingTable(this.index, res);
        }
    }
}

