/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;

public final class DateDiffMillisNanosEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateDiffMillisNanosEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator unit;
    private final EvalOperator.ExpressionEvaluator startTimestampMillis;
    private final EvalOperator.ExpressionEvaluator endTimestampNanos;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateDiffMillisNanosEvaluator(Source source, EvalOperator.ExpressionEvaluator unit, EvalOperator.ExpressionEvaluator startTimestampMillis, EvalOperator.ExpressionEvaluator endTimestampNanos, DriverContext driverContext) {
        this.source = source;
        this.unit = unit;
        this.startTimestampMillis = startTimestampMillis;
        this.endTimestampNanos = endTimestampNanos;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.unit.baseRamBytesUsed();
        baseRamBytesUsed += this.startTimestampMillis.baseRamBytesUsed();
        return baseRamBytesUsed += this.endTimestampNanos.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, BytesRefBlock unitBlock, LongBlock startTimestampMillisBlock, LongBlock endTimestampNanosBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (unitBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (unitBlock.getValueCount(p) != 1) {
                    if (unitBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (startTimestampMillisBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (startTimestampMillisBlock.getValueCount(p) != 1) {
                    if (startTimestampMillisBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (endTimestampNanosBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (endTimestampNanosBlock.getValueCount(p) != 1) {
                    if (endTimestampNanosBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendInt(DateDiff.processMillisNanos(unitBlock.getBytesRef(unitBlock.getFirstValueIndex(p), unitScratch), startTimestampMillisBlock.getLong(startTimestampMillisBlock.getFirstValueIndex(p)), endTimestampNanosBlock.getLong(endTimestampNanosBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, BytesRefVector unitVector, LongVector startTimestampMillisVector, LongVector endTimestampNanosVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendInt(DateDiff.processMillisNanos(unitVector.getBytesRef(p, unitScratch), startTimestampMillisVector.getLong(p), endTimestampNanosVector.getLong(p)));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "DateDiffMillisNanosEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestampMillis=" + String.valueOf(this.startTimestampMillis) + ", endTimestampNanos=" + String.valueOf(this.endTimestampNanos) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.unit, this.startTimestampMillis, this.endTimestampNanos});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory unit;
        private final EvalOperator.ExpressionEvaluator.Factory startTimestampMillis;
        private final EvalOperator.ExpressionEvaluator.Factory endTimestampNanos;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory unit, EvalOperator.ExpressionEvaluator.Factory startTimestampMillis, EvalOperator.ExpressionEvaluator.Factory endTimestampNanos) {
            this.source = source;
            this.unit = unit;
            this.startTimestampMillis = startTimestampMillis;
            this.endTimestampNanos = endTimestampNanos;
        }

        public DateDiffMillisNanosEvaluator get(DriverContext context) {
            return new DateDiffMillisNanosEvaluator(this.source, this.unit.get(context), this.startTimestampMillis.get(context), this.endTimestampNanos.get(context), context);
        }

        public String toString() {
            return "DateDiffMillisNanosEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestampMillis=" + String.valueOf(this.startTimestampMillis) + ", endTimestampNanos=" + String.valueOf(this.endTimestampNanos) + "]";
        }
    }
}

