/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.initialization;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.initialization.DynamicInstrumentation;
import org.elasticsearch.entitlement.initialization.EntitlementCheckerUtils;
import org.elasticsearch.entitlement.runtime.policy.ElasticsearchEntitlementChecker;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.PolicyChecker;
import org.elasticsearch.entitlement.runtime.policy.PolicyCheckerImpl;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class EntitlementInitialization {
    private static final Logger logger = LogManager.getLogger(EntitlementInitialization.class);
    private static final Module ENTITLEMENTS_MODULE = PolicyManager.class.getModule();
    public static InitializeArgs initializeArgs;
    private static ElasticsearchEntitlementChecker checker;
    private static AtomicReference<RuntimeException> error;

    public static EntitlementChecker checker() {
        return checker;
    }

    public static RuntimeException getError() {
        return error.get();
    }

    public static void initialize(Instrumentation inst) {
        try {
            checker = EntitlementInitialization.initChecker(initializeArgs.policyManager());
            EntitlementInitialization.initInstrumentation(inst);
        }
        catch (Exception e) {
            error.set(new RuntimeException("Failed to initialize entitlements", e));
        }
    }

    private static PolicyCheckerImpl createPolicyChecker(PolicyManager policyManager) {
        return new PolicyCheckerImpl(initializeArgs.suppressFailureLogPackages(), ENTITLEMENTS_MODULE, policyManager, initializeArgs.pathLookup());
    }

    private static void ensureClassesSensitiveToVerificationAreInitialized() {
        Set<String> classesToInitialize = Set.of("sun.net.www.protocol.http.HttpURLConnection", "sun.nio.ch.SocketChannelImpl", "java.net.ProxySelector", "sun.nio.ch.DatagramChannelImpl", "sun.nio.ch.ServerSocketChannelImpl");
        for (String className : classesToInitialize) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
    }

    static ElasticsearchEntitlementChecker initChecker(PolicyManager policyManager) {
        ElasticsearchEntitlementChecker checker;
        Constructor<?> constructor;
        PolicyCheckerImpl policyChecker = EntitlementInitialization.createPolicyChecker(policyManager);
        Class<?> clazz = EntitlementCheckerUtils.getVersionSpecificCheckerClass(ElasticsearchEntitlementChecker.class, Runtime.version().feature());
        try {
            constructor = clazz.getConstructor(PolicyChecker.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("entitlement impl is missing required constructor: [" + clazz.getName() + "]", e);
        }
        try {
            checker = (ElasticsearchEntitlementChecker)constructor.newInstance(policyChecker);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        return checker;
    }

    static void initInstrumentation(Instrumentation instrumentation) throws Exception {
        boolean verifyBytecode = Booleans.parseBoolean((String)System.getProperty("es.entitlements.verify_bytecode", "false"));
        if (verifyBytecode) {
            EntitlementInitialization.ensureClassesSensitiveToVerificationAreInitialized();
        }
        DynamicInstrumentation.initialize(instrumentation, EntitlementCheckerUtils.getVersionSpecificCheckerClass(EntitlementChecker.class, Runtime.version().feature()), verifyBytecode);
    }

    static {
        error = new AtomicReference();
    }

    public record InitializeArgs(PathLookup pathLookup, Set<Package> suppressFailureLogPackages, PolicyManager policyManager) {
        public InitializeArgs {
            Objects.requireNonNull(pathLookup);
            Objects.requireNonNull(suppressFailureLogPackages);
            Objects.requireNonNull(policyManager);
        }
    }
}

