/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpamPoolCidrState {
    PENDING_PROVISION("pending-provision"),
    PROVISIONED("provisioned"),
    FAILED_PROVISION("failed-provision"),
    PENDING_DEPROVISION("pending-deprovision"),
    DEPROVISIONED("deprovisioned"),
    FAILED_DEPROVISION("failed-deprovision"),
    PENDING_IMPORT("pending-import"),
    FAILED_IMPORT("failed-import"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpamPoolCidrState> VALUE_MAP;
    private final String value;

    private IpamPoolCidrState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpamPoolCidrState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpamPoolCidrState> knownValues() {
        EnumSet<IpamPoolCidrState> knownValues = EnumSet.allOf(IpamPoolCidrState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpamPoolCidrState.class, IpamPoolCidrState::toString);
    }
}

