/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.kuromoji;

import org.apache.lucene.analysis.ja.JapaneseCompletionAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseCompletionFilter;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiCompletionFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiTokenizerFactory;

public class KuromojiCompletionAnalyzerProvider
extends AbstractIndexAnalyzerProvider<JapaneseCompletionAnalyzer> {
    private final JapaneseCompletionAnalyzer analyzer;

    public KuromojiCompletionAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name, settings);
        UserDictionary userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        JapaneseCompletionFilter.Mode mode = KuromojiCompletionFilterFactory.getMode(settings);
        this.analyzer = new JapaneseCompletionAnalyzer(userDictionary, mode);
    }

    public JapaneseCompletionAnalyzer get() {
        return this.analyzer;
    }
}

