/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.security.JdkUser;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;

public class JdkUserProvider
extends UserProvider {
    private static final Log LOG = LogFactory.getLog(JdkUserProvider.class);

    @Override
    public User getUser() {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Could not locate existing Subject - Creating new one");
            }
            subject = new Subject();
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Located existing Subject - " + subject));
        }
        return new JdkUser(subject, this.getSettings());
    }
}

