/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.launchers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JavaVersion
implements Comparable<JavaVersion> {
    public static final JavaVersion CURRENT = JavaVersion.parse(System.getProperty("java.specification.version"));
    public static final JavaVersion JAVA_11 = JavaVersion.parse("11");
    private final List<Integer> version;

    private JavaVersion(List<Integer> version) {
        this.version = version;
    }

    static JavaVersion parse(String value) {
        String[] components;
        if (!value.matches("^0*[0-9]+(\\.[0-9]+)*$")) {
            throw new IllegalArgumentException(value);
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        for (String component : components = value.split("\\.")) {
            version.add(Integer.valueOf(component));
        }
        return new JavaVersion(version);
    }

    public static int majorVersion(JavaVersion javaVersion) {
        Objects.requireNonNull(javaVersion);
        if (javaVersion.version.get(0) > 1) {
            return javaVersion.version.get(0);
        }
        return javaVersion.version.get(1);
    }

    private static int compare(JavaVersion leftVersion, JavaVersion rightVersion) {
        List<Integer> left = leftVersion.version;
        List<Integer> right = rightVersion.version;
        int len = Math.max(left.size(), right.size());
        for (int i = 0; i < len; ++i) {
            int r;
            int l = i < left.size() ? left.get(i) : 0;
            int n = r = i < right.size() ? right.get(i) : 0;
            if (l < r) {
                return -1;
            }
            if (r >= l) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(JavaVersion other) {
        return JavaVersion.compare(this, other);
    }
}

