/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Available;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAvailable
extends Available
implements Callable {
    private Set<String> importedSchemaNamespaces;
    private boolean isXSLT20basic;

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        this.isXSLT20basic = !env.isSchemaAware() && !env.getXPathLanguageLevel().equals(DecimalValue.THREE);
        super.checkArguments(visitor);
        if (!(this.argument[0] instanceof Literal) || this.argument.length != 1 && !(this.argument[1] instanceof Literal)) {
            this.importedSchemaNamespaces = visitor.getStaticContext().getImportedSchemaNamespaces();
        }
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        this.nsContext = visitor.getStaticContext().getNamespaceResolver();
        String lexicalQName = ((Literal)this.argument[0]).getValue().getStringValue();
        boolean b = this.typeAvailable(lexicalQName, this.getContainer().getPackageData(), visitor.getStaticContext().getImportedSchemaNamespaces());
        return Literal.makeLiteral(BooleanValue.get(b), this.getContainer());
    }

    @Override
    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.argument[0].evaluateItem(context);
        StringValue nameValue = (StringValue)av1;
        boolean b = this.typeAvailable(nameValue.getStringValue(), this.getContainer().getPackageData(), this.importedSchemaNamespaces);
        return BooleanValue.get(b);
    }

    private boolean typeAvailable(String lexicalName, PackageData packageData, Set<String> importedSchemaNamespaces) throws XPathException {
        StructuredQName qName;
        String uri;
        Configuration config = packageData.getConfiguration();
        try {
            if (lexicalName.indexOf(58) < 0 && !lexicalName.startsWith("Q{")) {
                uri = this.nsContext.getURIForPrefix("", true);
                qName = new StructuredQName("", uri, lexicalName);
            } else {
                boolean is30 = packageData.isAllowXPath30();
                qName = StructuredQName.fromLexicalQName(lexicalName, false, is30, this.nsContext);
            }
        }
        catch (XPathException e) {
            e.setErrorCode("XTDE1428");
            e.setLocator(this);
            throw e;
        }
        uri = qName.getURI();
        if (uri.equals("http://saxon.sf.net/java-type")) {
            try {
                String className = JavaExternalObjectType.localNameToClassName(qName.getLocalPart());
                config.getClass(className, false, null);
                return true;
            }
            catch (XPathException err) {
                return false;
            }
        }
        if (uri.equals("http://www.w3.org/2001/XMLSchema") || importedSchemaNamespaces.contains(uri)) {
            int fp = config.getNamePool().allocate(qName.getPrefix(), uri, qName.getLocalPart()) & 0xFFFFF;
            SchemaType type = config.getSchemaType(fp);
            return type != null && (!this.isXSLT20basic || !(type instanceof BuiltInListType) && (!(type instanceof BuiltInAtomicType) || ((BuiltInAtomicType)type).isAllowedInBasicXSLT()));
        }
        return false;
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        String lexicalQName = arguments[0].head().getStringValue();
        return BooleanValue.get(this.typeAvailable(lexicalQName, this.getContainer().getPackageData(), this.importedSchemaNamespaces));
    }
}

