/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.DebugByteTeeOutputStream;
import org.apache.derby.iapi.services.io.ErrorInfo;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.shared.common.sanity.SanityManager;

public class FormatIdOutputStream
extends DataOutputStream
implements ObjectOutput,
ErrorInfo {
    public FormatIdOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writeObject(Object ref) throws IOException {
        String name;
        Formatable f;
        int fmtId;
        String str;
        if (ref == null) {
            FormatIdUtil.writeFormatIdInteger(this, 0);
            return;
        }
        if (ref instanceof String && (str = (String)ref).length() <= 20000) {
            FormatIdUtil.writeFormatIdInteger(this, 1);
            this.writeUTF((String)ref);
            return;
        }
        OutputStream oldOut = null;
        if (ref instanceof Formatable) {
            oldOut = this.out;
            this.out = new DebugByteTeeOutputStream(oldOut);
        }
        if (ref instanceof Storable) {
            Storable s = (Storable)ref;
            int fmtId2 = s.getTypeFormatId();
            if (fmtId2 != 2) {
                FormatIdUtil.writeFormatIdInteger(this, fmtId2);
                boolean isNull = s.isNull();
                this.writeBoolean(isNull);
                if (!isNull) {
                    s.writeExternal(this);
                }
                ((DebugByteTeeOutputStream)this.out).checkObject(s);
                this.out = oldOut;
                return;
            }
        } else if (ref instanceof Formatable && (fmtId = (f = (Formatable)ref).getTypeFormatId()) != 2) {
            FormatIdUtil.writeFormatIdInteger(this, fmtId);
            f.writeExternal(this);
            ((DebugByteTeeOutputStream)this.out).checkObject(f);
            this.out = oldOut;
            return;
        }
        if (SanityManager.DEBUG_ON((String)"SerializedTrace") && !(name = ref.getClass().getName()).startsWith("java.lang") && !name.startsWith("java.math")) {
            SanityManager.DEBUG((String)"SerializedTrace", (String)("...writing serialized class: " + name));
            System.out.println("...writing serialized class: " + name);
        }
        FormatIdUtil.writeFormatIdInteger(this, 2);
        ObjectOutputStream oos = new ObjectOutputStream(this);
        oos.writeObject(ref);
        oos.flush();
        if (ref instanceof Formatable) {
            ((DebugByteTeeOutputStream)this.out).checkObject((Formatable)ref);
            this.out = oldOut;
        }
    }

    public void setOutput(OutputStream out) {
        this.out = out;
        this.written = 0;
    }

    @Override
    public String getErrorInfo() {
        return null;
    }

    @Override
    public Exception getNestedException() {
        return null;
    }
}

