/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.MavenPluginConfigurationValidator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

abstract class AbstractMavenPluginParametersValidator
implements MavenPluginConfigurationValidator {
    protected final PluginValidationManager pluginValidationManager;

    protected AbstractMavenPluginParametersValidator(PluginValidationManager pluginValidationManager) {
        this.pluginValidationManager = Objects.requireNonNull(pluginValidationManager);
    }

    protected boolean isValueSet(PlexusConfiguration config, ExpressionEvaluator expressionEvaluator) {
        if (config == null) {
            return false;
        }
        if (config.getChildCount() > 0) {
            return true;
        }
        String strValue = config.getValue();
        if (strValue == null || strValue.isEmpty()) {
            return false;
        }
        if (this.isIgnoredProperty(strValue)) {
            return false;
        }
        try {
            return expressionEvaluator.evaluate(strValue) != null;
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            return false;
        }
    }

    @Override
    public final void validate(MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        this.doValidate(mavenSession, mojoDescriptor, mojoClass, pomConfiguration, expressionEvaluator);
    }

    protected abstract void doValidate(MavenSession var1, MojoDescriptor var2, Class<?> var3, PlexusConfiguration var4, ExpressionEvaluator var5);

    protected boolean isIgnoredProperty(String strValue) {
        return false;
    }

    protected abstract String getParameterLogReason(Parameter var1);

    protected String formatParameter(Parameter parameter) {
        StringBuilder stringBuilder = new StringBuilder().append("Parameter '").append(parameter.getName()).append('\'');
        if (parameter.getExpression() != null) {
            String userProperty = parameter.getExpression().replace("${", "'").replace('}', '\'');
            stringBuilder.append(" (user property ").append(userProperty).append(")");
        }
        stringBuilder.append(" ").append(this.getParameterLogReason(parameter));
        return stringBuilder.toString();
    }
}

