/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import java.util.Iterator;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> boolean sizeEquals(Iterable<T> iterable, int expectedSize) {
        Iterator<T> iterator = iterable.iterator();
        int currentSize = 0;
        while (iterator.hasNext()) {
            if (expectedSize > currentSize) {
                ++currentSize;
                iterator.next();
                continue;
            }
            return false;
        }
        return true;
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T last = null;
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator == null) {
            return null;
        }
        return iterator.hasNext() ? (T)iterator.next() : null;
    }
}

