/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record TransformConfigVersion(int id) implements VersionId<TransformConfigVersion>,
ToXContentFragment
{
    private static Map<String, Integer> IDS = new HashMap<String, Integer>();
    public static final String TRANSFORM_CONFIG_VERSION_NODE_ATTR = "transform.config_version";
    public static final TransformConfigVersion ZERO = TransformConfigVersion.registerTransformConfigVersion(0, "00000000-0000-0000-0000-000000000000");
    public static final TransformConfigVersion V_7_2_0 = TransformConfigVersion.registerTransformConfigVersion(7020099, "4DCD30C3-FF6B-4195-AD28-4600D48F4A7B");
    public static final TransformConfigVersion V_7_2_1 = TransformConfigVersion.registerTransformConfigVersion(7020199, "0C6EDC80-77C9-4897-843B-EC4377E997FD");
    public static final TransformConfigVersion V_7_3_0 = TransformConfigVersion.registerTransformConfigVersion(7030099, "69107EE3-48A7-4FC2-BDB3-7440C4B3E0D4");
    public static final TransformConfigVersion V_7_3_2 = TransformConfigVersion.registerTransformConfigVersion(7030299, "2155846F-36F5-420B-BD29-6415019AB64A");
    public static final TransformConfigVersion V_7_4_0 = TransformConfigVersion.registerTransformConfigVersion(7040099, "21E66DF1-9AAE-40E8-9EF0-E4494CF513B6");
    public static final TransformConfigVersion V_7_5_0 = TransformConfigVersion.registerTransformConfigVersion(7050099, "ED5D4FA8-E22B-4ABD-A69E-76BBE9363CDD");
    public static final TransformConfigVersion V_7_6_0 = TransformConfigVersion.registerTransformConfigVersion(7060099, "1155C404-6ABA-4782-9A6D-FD7167D4109C");
    public static final TransformConfigVersion V_7_6_2 = TransformConfigVersion.registerTransformConfigVersion(0x6BBB4B, "4FC29EC6-E702-4C44-B2DF-E3C9D3BD4DEC");
    public static final TransformConfigVersion V_7_7_0 = TransformConfigVersion.registerTransformConfigVersion(7070099, "5369472F-3845-4759-9927-875DCACB66FC");
    public static final TransformConfigVersion V_7_8_0 = TransformConfigVersion.registerTransformConfigVersion(7080099, "94F8181D-4F74-4C22-9015-7BE6D2ACA9FE");
    public static final TransformConfigVersion V_7_8_1 = TransformConfigVersion.registerTransformConfigVersion(7080199, "1522F9FD-CAD5-4221-95A8-61C22C9AA4FD");
    public static final TransformConfigVersion V_7_9_0 = TransformConfigVersion.registerTransformConfigVersion(7090099, "42557660-0127-47B3-B01F-B02E2A5B47DB");
    public static final TransformConfigVersion V_7_9_1 = TransformConfigVersion.registerTransformConfigVersion(7090199, "0AA38DE2-74C0-4D36-BCA9-AAB2EE728D2C");
    public static final TransformConfigVersion V_7_9_2 = TransformConfigVersion.registerTransformConfigVersion(7090299, "165B1C7D-51A7-4FC6-A673-28885C2403E0");
    public static final TransformConfigVersion V_7_9_3 = TransformConfigVersion.registerTransformConfigVersion(7090399, "4B9B8DB4-D1C1-4F8B-994A-3352CE4C376E");
    public static final TransformConfigVersion V_7_10_0 = TransformConfigVersion.registerTransformConfigVersion(7100099, "389FEA3F-1A53-4F26-AEBA-584EF954596F");
    public static final TransformConfigVersion V_7_10_1 = TransformConfigVersion.registerTransformConfigVersion(7100199, "ACA28B55-87B8-4F87-9517-7B3345F1F789");
    public static final TransformConfigVersion V_7_11_0 = TransformConfigVersion.registerTransformConfigVersion(7110099, "0377318D-6D53-41C5-A376-8E42E1435806");
    public static final TransformConfigVersion V_7_12_0 = TransformConfigVersion.registerTransformConfigVersion(7120099, "0CB23517-70F2-4F26-9E7D-8F6FCD16B14A");
    public static final TransformConfigVersion V_7_13_0 = TransformConfigVersion.registerTransformConfigVersion(7130099, "49BE3B14-9E33-48A2-B605-DB0B61AAD49D");
    public static final TransformConfigVersion V_7_14_0 = TransformConfigVersion.registerTransformConfigVersion(7140099, "DD87203A-2CBD-40A6-A466-70D9F560B282");
    public static final TransformConfigVersion V_7_15_0 = TransformConfigVersion.registerTransformConfigVersion(7150099, "890AA965-41D4-4C99-9493-2CA8BBD06C99");
    public static final TransformConfigVersion V_7_15_1 = TransformConfigVersion.registerTransformConfigVersion(7150199, "0C0EC66A-DAD7-4448-99F6-A13D465D5203");
    public static final TransformConfigVersion V_7_16_0 = TransformConfigVersion.registerTransformConfigVersion(7160099, "F4C8C99C-EC0D-4119-AD6A-CFEEAFE6461C");
    public static final TransformConfigVersion V_7_17_0 = TransformConfigVersion.registerTransformConfigVersion(7170099, "056316CB-61CB-4A5D-84BB-8ACDA24D5748");
    public static final TransformConfigVersion V_7_17_1 = TransformConfigVersion.registerTransformConfigVersion(7170199, "A0006AC5-7C5A-42CC-97F7-8792FC8DEEAC");
    public static final TransformConfigVersion V_7_17_8 = TransformConfigVersion.registerTransformConfigVersion(7170899, "A769CAD5-0A3F-4CB4-BC0C-9CFDCC6D6605");
    public static final TransformConfigVersion V_8_0_0 = TransformConfigVersion.registerTransformConfigVersion(8000099, "2B5AFCFD-90F9-41CD-9E55-4D2711F03758");
    public static final TransformConfigVersion V_8_1_0 = TransformConfigVersion.registerTransformConfigVersion(8010099, "4E1B967E-4BFA-4C41-8F59-E43C87B1DEFF");
    public static final TransformConfigVersion V_8_2_0 = TransformConfigVersion.registerTransformConfigVersion(8020099, "01E035F3-D864-4094-8523-84D717EFB89D");
    public static final TransformConfigVersion V_8_3_0 = TransformConfigVersion.registerTransformConfigVersion(8030099, "574B950D-2E9F-4CCA-9E61-F93B4420D800");
    public static final TransformConfigVersion V_8_4_0 = TransformConfigVersion.registerTransformConfigVersion(8040099, "D92DAC63-DAE6-4858-9E63-9BD91B67459A");
    public static final TransformConfigVersion V_8_5_0 = TransformConfigVersion.registerTransformConfigVersion(8050099, "178A2E20-8F8E-4430-A002-B156E1E99B22");
    public static final TransformConfigVersion V_8_6_0 = TransformConfigVersion.registerTransformConfigVersion(8060099, "C910CB2A-A7B5-47AE-A9F5-FAC8F5205D27");
    public static final TransformConfigVersion V_8_6_1 = TransformConfigVersion.registerTransformConfigVersion(8060199, "DFD4116C-1173-4461-8A00-00E0ADCAD2C2");
    public static final TransformConfigVersion V_8_7_0 = TransformConfigVersion.registerTransformConfigVersion(8070099, "C9A8AACB-84FA-44C6-A541-2FDEAECB280D");
    public static final TransformConfigVersion V_8_7_1 = TransformConfigVersion.registerTransformConfigVersion(8070199, "B2EC2F2F-9D73-4057-A21C-23E0EF3AD311");
    public static final TransformConfigVersion V_8_8_0 = TransformConfigVersion.registerTransformConfigVersion(8080099, "8E50EED5-54E3-45B1-A3B2-83A44ADBBF09");
    public static final TransformConfigVersion V_8_8_1 = TransformConfigVersion.registerTransformConfigVersion(0x7B4B47, "99A928F3-FD13-4325-9770-317EB624C85C");
    public static final TransformConfigVersion V_8_9_0 = TransformConfigVersion.registerTransformConfigVersion(8090099, "C50F56AB-4DB8-48A5-9467-4F5B07365C5C");
    private static final TransformConfigVersion V_8_10_0 = TransformConfigVersion.registerTransformConfigVersion(8100099, "9315A548-D81B-4FE7-8C0D-0DA81EA00F9E");
    public static final TransformConfigVersion V_10;
    public static final TransformConfigVersion CURRENT;
    public static final TransformConfigVersion MINIMUM_DETACHED_TRANSFORM_CONFIG_VERSION;
    public static final TransformConfigVersion FIRST_TRANSFORM_VERSION;
    private static final NavigableMap<Integer, TransformConfigVersion> VERSION_IDS;

    private static TransformConfigVersion registerTransformConfigVersion(int id, String uniqueId) {
        TransformConfigVersion.checkUniqueness(id, uniqueId);
        return new TransformConfigVersion(id);
    }

    private static void checkUniqueness(int id, String uniqueId) {
        if (IDS == null) {
            throw new IllegalStateException("The IDS map needs to be present to call this method");
        }
        Strings.requireNonEmpty(uniqueId, "Each TransformConfigVersion needs a unique string id");
        Integer existing = IDS.put(uniqueId, id);
        if (existing != null) {
            throw new IllegalArgumentException("Versions " + id + " and " + existing + " have the same unique id");
        }
    }

    public static NavigableMap<Integer, TransformConfigVersion> getAllVersionIds(Class<?> cls) {
        HashMap<Integer, String> versionIdFields = new HashMap<Integer, String>();
        TreeMap<Integer, TransformConfigVersion> builder = new TreeMap<Integer, TransformConfigVersion>();
        Set<String> ignore = Set.of("V_8_10_0", "ZERO", "CURRENT", "FIRST_TRANSFORM_VERSION");
        for (Field declaredField : cls.getFields()) {
            TransformConfigVersion version;
            String fieldName;
            if (!declaredField.getType().equals(TransformConfigVersion.class) || ignore.contains(fieldName = declaredField.getName()) || !fieldName.matches("V_.*")) continue;
            try {
                version = (TransformConfigVersion)declaredField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            builder.put(version.id, version);
            if (!Assertions.ENABLED) continue;
            String sameVersionNumber = versionIdFields.put(version.id, fieldName);
            assert (sameVersionNumber == null) : "Versions [" + sameVersionNumber + "] and [" + fieldName + "] have the same version number [" + version.id + "]. Each TransformConfigVersion should have a different version number";
        }
        return Collections.unmodifiableNavigableMap(builder);
    }

    static Collection<TransformConfigVersion> getAllVersions() {
        return VERSION_IDS.values();
    }

    public static TransformConfigVersion readVersion(StreamInput in) throws IOException {
        return TransformConfigVersion.fromId(in.readVInt());
    }

    public static TransformConfigVersion fromId(int id) {
        TransformConfigVersion known = (TransformConfigVersion)VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        return new TransformConfigVersion(id);
    }

    public static TransformConfigVersion fromNode(DiscoveryNode node) {
        return TransformConfigVersion.getTransformConfigVersionForNode(node);
    }

    public static void writeVersion(TransformConfigVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static TransformConfigVersion min(TransformConfigVersion version1, TransformConfigVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static TransformConfigVersion max(TransformConfigVersion version1, TransformConfigVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static TransformConfigVersion getMinTransformConfigVersion(DiscoveryNodes nodes) {
        return TransformConfigVersion.getMinMaxTransformConfigVersion(nodes).v1();
    }

    public static TransformConfigVersion getMaxTransformConfigVersion(DiscoveryNodes nodes) {
        return TransformConfigVersion.getMinMaxTransformConfigVersion(nodes).v2();
    }

    public static Tuple<TransformConfigVersion, TransformConfigVersion> getMinMaxTransformConfigVersion(DiscoveryNodes nodes) {
        TransformConfigVersion minTransformConfigVersion = CURRENT;
        TransformConfigVersion maxTransformConfigVersion = FIRST_TRANSFORM_VERSION;
        for (DiscoveryNode node : nodes) {
            try {
                TransformConfigVersion TransformConfigVersion2 = TransformConfigVersion.getTransformConfigVersionForNode(node);
                if (TransformConfigVersion2.before(minTransformConfigVersion)) {
                    minTransformConfigVersion = TransformConfigVersion2;
                }
                if (!TransformConfigVersion2.after(maxTransformConfigVersion)) continue;
                maxTransformConfigVersion = TransformConfigVersion2;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return new Tuple<TransformConfigVersion, TransformConfigVersion>(minTransformConfigVersion, maxTransformConfigVersion);
    }

    public static TransformConfigVersion getTransformConfigVersionForNode(DiscoveryNode node) {
        String transformConfigVerStr = node.getAttributes().get(TRANSFORM_CONFIG_VERSION_NODE_ATTR);
        if (transformConfigVerStr != null) {
            return TransformConfigVersion.fromString(transformConfigVerStr);
        }
        return TransformConfigVersion.fromId(node.getPre811VersionId().orElseThrow(() -> new IllegalStateException("getting legacy version id not possible")));
    }

    public static TransformConfigVersion fromString(String str) {
        if (str == null) {
            return CURRENT;
        }
        if (str.equals("8.10.0")) {
            return V_10;
        }
        Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-\\w+)?$").matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Transform config version [" + str + "] not valid");
        }
        int first = Integer.parseInt(matcher.group(1));
        int second = Integer.parseInt(matcher.group(2));
        int third = Integer.parseInt(matcher.group(3));
        if (first >= 10 && (second > 0 || third > 0)) {
            throw new IllegalArgumentException("Transform config version [" + str + "] not valid");
        }
        return TransformConfigVersion.fromId(1000000 * first + 10000 * second + 100 * third + 99);
    }

    @Override
    public String toString() {
        int major = this.id / 1000000;
        if (this.id < MINIMUM_DETACHED_TRANSFORM_CONFIG_VERSION.id()) {
            int minor = this.id % 1000000 / 10000;
            int patch = this.id % 1000000 % 10000 / 100;
            return major + "." + minor + "." + patch;
        }
        return major + ".0.0";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    static {
        CURRENT = V_10 = TransformConfigVersion.registerTransformConfigVersion(10000099, "4B940FD9-BEDD-4589-8E08-02D9B480B22D");
        MINIMUM_DETACHED_TRANSFORM_CONFIG_VERSION = V_10;
        FIRST_TRANSFORM_VERSION = V_7_2_0;
        IDS = null;
        VERSION_IDS = TransformConfigVersion.getAllVersionIds(TransformConfigVersion.class);
    }
}

