/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.TimeValue;

public final class Automatons {
    static final Setting<Integer> MAX_DETERMINIZED_STATES_SETTING = Setting.intSetting("xpack.security.automata.max_determinized_states", 100000, 10000, Setting.Property.NodeScope);
    static final Setting<Boolean> CACHE_ENABLED = Setting.boolSetting("xpack.security.automata.cache.enabled", true, Setting.Property.NodeScope);
    static final Setting<Integer> CACHE_SIZE = Setting.intSetting("xpack.security.automata.cache.size", 10000, Setting.Property.NodeScope);
    static final Setting<TimeValue> CACHE_TTL = Setting.timeSetting("xpack.security.automata.cache.ttl", TimeValue.timeValueHours(48L), Setting.Property.NodeScope);
    public static final Automaton EMPTY = Automata.makeEmpty();
    public static final Automaton MATCH_ALL = Automata.makeAnyString();
    private static int maxDeterminizedStates = 100000;
    private static Cache<Object, Automaton> cache = Automatons.buildCache(Settings.EMPTY);
    static final char WILDCARD_STRING = '*';
    static final char WILDCARD_CHAR = '?';
    static final char WILDCARD_ESCAPE = '\\';
    public static boolean recordPatterns = System.getProperty("tests.automaton.record.patterns", "false").equals("true");
    private static final Map<Automaton, List<String>> patternsMap = new HashMap<Automaton, List<String>>();

    private Automatons() {
    }

    public static Automaton patterns(String ... patterns) {
        return Automatons.patterns(Arrays.asList(patterns));
    }

    public static Automaton patterns(Collection<String> patterns) {
        if (patterns.isEmpty()) {
            return EMPTY;
        }
        if (cache == null) {
            return Automatons.maybeRecordPatterns(Automatons.buildAutomaton(patterns), patterns);
        }
        try {
            return cache.computeIfAbsent(Sets.newHashSet(patterns), p -> Automatons.maybeRecordPatterns(Automatons.buildAutomaton((Set)p), patterns));
        }
        catch (ExecutionException e) {
            throw Automatons.unwrapCacheException(e);
        }
    }

    private static Automaton buildAutomaton(Collection<String> patterns) {
        if (patterns.size() == 1) {
            return Automatons.minimize(Automatons.pattern(patterns.iterator().next()));
        }
        Function<Collection, Automaton> build = strings -> {
            ArrayList<Automaton> automata = new ArrayList<Automaton>(strings.size());
            for (String pattern : strings) {
                Automaton patternAutomaton = Automatons.pattern(pattern);
                automata.add(patternAutomaton);
            }
            return Automatons.unionAndMinimize(automata);
        };
        HashSet<String> prefix = new HashSet<String>();
        HashSet<String> infix = new HashSet<String>();
        HashSet<String> suffix = new HashSet<String>();
        HashSet<String> misc = new HashSet<String>();
        for (String p : patterns) {
            if (p.length() <= 1) {
                misc.add(p);
                continue;
            }
            char first = p.charAt(0);
            char last = p.charAt(p.length() - 1);
            if (first == '/') {
                misc.add(p);
                continue;
            }
            if (first == '*') {
                if (last == '*') {
                    infix.add(p.substring(1, p.length() - 1));
                    continue;
                }
                suffix.add(p.substring(1));
                continue;
            }
            if (last == '*' && p.indexOf(42) != p.length() - 1) {
                prefix.add(p.substring(0, p.length() - 1));
                continue;
            }
            misc.add(p);
        }
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        if (!prefix.isEmpty()) {
            automata.add(Operations.concatenate(build.apply(prefix), Automata.makeAnyString()));
        }
        if (!suffix.isEmpty()) {
            automata.add(Operations.concatenate(Automata.makeAnyString(), build.apply(suffix)));
        }
        if (!infix.isEmpty()) {
            automata.add(Operations.concatenate(List.of(Automata.makeAnyString(), build.apply(infix), Automata.makeAnyString())));
        }
        if (!misc.isEmpty()) {
            automata.add(build.apply(misc));
        }
        return Automatons.unionAndMinimize(automata);
    }

    static Automaton pattern(String pattern) {
        if (cache == null) {
            return Automatons.buildAutomaton(pattern);
        }
        try {
            return cache.computeIfAbsent(pattern, p -> Automatons.buildAutomaton((String)p));
        }
        catch (ExecutionException e) {
            throw Automatons.unwrapCacheException(e);
        }
    }

    public static boolean isLuceneRegex(String str) {
        return str.length() > 1 && str.charAt(0) == '/' && str.charAt(str.length() - 1) == '/';
    }

    private static Automaton buildAutomaton(String pattern) {
        if (pattern.startsWith("/")) {
            if (pattern.length() == 1 || !pattern.endsWith("/")) {
                throw new IllegalArgumentException("invalid pattern [" + pattern + "]. patterns starting with '/' indicate regular expression pattern and therefore must also end with '/'. other patterns (those that do not start with '/') will be treated as simple wildcard patterns");
            }
            String regex = pattern.substring(1, pattern.length() - 1);
            return new RegExp(regex).toAutomaton();
        }
        if (pattern.equals("*")) {
            return MATCH_ALL;
        }
        return Automatons.wildcard(pattern);
    }

    private static RuntimeException unwrapCacheException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new RuntimeException(cause);
    }

    static Automaton wildcard(String text) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        block5: for (int i = 0; i < text.length(); i += length) {
            char c = text.charAt(i);
            length = 1;
            switch (c) {
                case '*': {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case '?': {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case '\\': {
                    if (i + length < text.length()) {
                        char nextChar = text.charAt(i + length);
                        ++length;
                        automata.add(Automata.makeChar(nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(Automata.makeChar(c));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    public static Automaton unionAndMinimize(Collection<Automaton> automata) {
        Automaton res = automata.size() == 1 ? automata.iterator().next() : Operations.union(automata);
        return Automatons.minimize(res);
    }

    public static Automaton minusAndMinimize(Automaton a1, Automaton a2) {
        Automaton res = Operations.minus(a1, a2, maxDeterminizedStates);
        return Automatons.minimize(res);
    }

    public static Automaton intersectAndMinimize(Automaton a1, Automaton a2) {
        Automaton res = Operations.intersection(a1, a2);
        return Automatons.minimize(res);
    }

    private static Automaton minimize(Automaton automaton) {
        return MinimizationOperations.minimize(automaton, maxDeterminizedStates);
    }

    public static Predicate<String> predicate(String ... patterns) {
        return Automatons.predicate(Arrays.asList(patterns));
    }

    public static Predicate<String> predicate(Collection<String> patterns) {
        return Automatons.predicate(Automatons.patterns(patterns), Strings.collectionToDelimitedString(patterns, "|"));
    }

    public static Predicate<String> predicate(Automaton automaton) {
        return Automatons.predicate(automaton, "Predicate for " + String.valueOf(automaton));
    }

    public static void updateConfiguration(Settings settings) {
        maxDeterminizedStates = MAX_DETERMINIZED_STATES_SETTING.get(settings);
        cache = Automatons.buildCache(settings);
    }

    private static Cache<Object, Automaton> buildCache(Settings settings) {
        if (!CACHE_ENABLED.get(settings).booleanValue()) {
            return null;
        }
        return CacheBuilder.builder().setExpireAfterAccess(CACHE_TTL.get(settings)).setMaximumWeight(CACHE_SIZE.get(settings).intValue()).build();
    }

    static int getMaxDeterminizedStates() {
        return maxDeterminizedStates;
    }

    private static Predicate<String> predicate(Automaton automaton, final String toString) {
        if (automaton == MATCH_ALL) {
            return Predicates.always();
        }
        if (automaton == EMPTY) {
            return Predicates.never();
        }
        final CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton, maxDeterminizedStates);
        return new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return runAutomaton.run(s);
            }

            public String toString() {
                return toString;
            }
        };
    }

    public static void addSettings(List<Setting<?>> settingsList) {
        settingsList.add(MAX_DETERMINIZED_STATES_SETTING);
        settingsList.add(CACHE_ENABLED);
        settingsList.add(CACHE_SIZE);
        settingsList.add(CACHE_TTL);
    }

    private static Automaton maybeRecordPatterns(Automaton automaton, Collection<String> patterns) {
        if (recordPatterns) {
            patternsMap.put(automaton, patterns.stream().map(String::trim).map(s -> s.toLowerCase(Locale.ROOT)).sorted().collect(Collectors.toList()));
        }
        return automaton;
    }

    static List<String> getPatterns(Automaton automaton) {
        if (recordPatterns) {
            return patternsMap.get(automaton);
        }
        throw new IllegalArgumentException("recordPatterns is set to false");
    }
}

