/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.io.IOException;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public class AuthenticationContextSerializer {
    private static final Logger logger = LogManager.getLogger(AuthenticationContextSerializer.class);
    private final String contextKey;

    public AuthenticationContextSerializer() {
        this("_xpack_security_authentication");
    }

    public AuthenticationContextSerializer(String contextKey) {
        this.contextKey = contextKey;
    }

    @Nullable
    public Authentication readFromContext(ThreadContext ctx) throws IOException {
        Authentication authentication = (Authentication)ctx.getTransient(this.contextKey);
        if (authentication != null) {
            assert (ctx.getHeader(this.contextKey) != null);
            return authentication;
        }
        String authenticationHeader = ctx.getHeader(this.contextKey);
        if (authenticationHeader == null) {
            return null;
        }
        return this.deserializeHeaderAndPutInContext(authenticationHeader, ctx);
    }

    Authentication deserializeHeaderAndPutInContext(String headerValue, ThreadContext ctx) throws IOException, IllegalArgumentException {
        assert (ctx.getTransient(this.contextKey) == null);
        Authentication authentication = AuthenticationContextSerializer.decode(headerValue);
        ctx.putTransient(this.contextKey, authentication);
        return authentication;
    }

    public static Authentication decode(String header) throws IOException {
        try {
            byte[] bytes = Base64.getDecoder().decode(header);
            StreamInput input = StreamInput.wrap(bytes);
            TransportVersion version = TransportVersion.readVersion(input);
            input.setTransportVersion(version);
            return new Authentication(input);
        }
        catch (IOException | RuntimeException e) {
            logger.warn("Failed to decode authentication [" + header + "]", (Throwable)e);
            throw e;
        }
    }

    public Authentication getAuthentication(ThreadContext context) {
        return (Authentication)context.getTransient(this.contextKey);
    }

    public void writeToContext(Authentication authentication, ThreadContext ctx) throws IOException {
        this.ensureContextDoesNotContainAuthentication(ctx);
        String header = authentication.encode();
        assert (header != null) : "Authentication object encoded to null";
        ctx.putTransient(this.contextKey, authentication);
        ctx.putHeader(this.contextKey, header);
    }

    void ensureContextDoesNotContainAuthentication(ThreadContext ctx) {
        if (ctx.getTransient(this.contextKey) != null) {
            if (ctx.getHeader(this.contextKey) == null) {
                throw new IllegalStateException("authentication present as a transient ([" + this.contextKey + "]) but not a header");
            }
            throw new IllegalStateException("authentication ([" + this.contextKey + "]) is already present in the context");
        }
    }
}

