/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.plugins.spi.NamedXContentProvider;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Accuracy;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.AucRoc;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.MulticlassConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.common.AbstractAucRoc;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.ConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.OutlierDetection;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.Recall;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.ScoreByThresholdResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.Huber;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.MeanSquaredError;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.MeanSquaredLogarithmicError;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.RSquared;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.Regression;

public class MlEvaluationNamedXContentProvider
implements NamedXContentProvider {
    public static String registeredMetricName(ParseField evaluationName, ParseField metricName) {
        return MlEvaluationNamedXContentProvider.registeredMetricName(evaluationName.getPreferredName(), metricName.getPreferredName());
    }

    public static String registeredMetricName(String evaluationName, String metricName) {
        return evaluationName + "." + metricName;
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Evaluation.class, OutlierDetection.NAME, OutlierDetection::fromXContent), new NamedXContentRegistry.Entry(Evaluation.class, Classification.NAME, Classification::fromXContent), new NamedXContentRegistry.Entry(Evaluation.class, Regression.NAME, Regression::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.AucRoc.NAME), new String[0]), org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.AucRoc::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, Precision.NAME), new String[0]), Precision::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, Recall.NAME), new String[0]), Recall::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, ConfusionMatrix.NAME), new String[0]), ConfusionMatrix::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, AucRoc.NAME), new String[0]), AucRoc::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, MulticlassConfusionMatrix.NAME), new String[0]), MulticlassConfusionMatrix::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Accuracy.NAME), new String[0]), Accuracy::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision.NAME), new String[0]), org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall.NAME), new String[0]), org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredError.NAME), new String[0]), MeanSquaredError::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredLogarithmicError.NAME), new String[0]), MeanSquaredLogarithmicError::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, Huber.NAME), new String[0]), Huber::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, RSquared.NAME), new String[0]), RSquared::fromXContent));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(Evaluation.class, OutlierDetection.NAME.getPreferredName(), OutlierDetection::new), new NamedWriteableRegistry.Entry(Evaluation.class, Classification.NAME.getPreferredName(), Classification::new), new NamedWriteableRegistry.Entry(Evaluation.class, Regression.NAME.getPreferredName(), Regression::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.AucRoc.NAME), org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.AucRoc::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, Precision.NAME), Precision::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, Recall.NAME), Recall::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, ConfusionMatrix.NAME), ConfusionMatrix::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, AucRoc.NAME), AucRoc::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, MulticlassConfusionMatrix.NAME), MulticlassConfusionMatrix::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Accuracy.NAME), Accuracy::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision.NAME), org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall.NAME), org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredError.NAME), MeanSquaredError::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredLogarithmicError.NAME), MeanSquaredLogarithmicError::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, Huber.NAME), Huber::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, RSquared.NAME), RSquared::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, ScoreByThresholdResult.NAME), ScoreByThresholdResult::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, ConfusionMatrix.NAME), ConfusionMatrix.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, "auc_roc_result", AbstractAucRoc.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, MulticlassConfusionMatrix.NAME), MulticlassConfusionMatrix.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Accuracy.NAME), Accuracy.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision.NAME), Precision.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall.NAME), Recall.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredError.NAME), MeanSquaredError.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredLogarithmicError.NAME), MeanSquaredLogarithmicError.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, Huber.NAME), Huber.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, RSquared.NAME), RSquared.Result::new));
    }
}

