/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CopyExecutionStateStep
extends ClusterStateActionStep {
    public static final String NAME = "copy-execution-state";
    private static final Logger logger = LogManager.getLogger(CopyExecutionStateStep.class);
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;
    private final Step.StepKey targetNextStepKey;
    private final SetOnce<String> calculatedTargetIndexName = new SetOnce();

    public CopyExecutionStateStep(Step.StepKey key, Step.StepKey nextStepKey, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier, Step.StepKey targetNextStepKey) {
        super(key, nextStepKey);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
        this.targetNextStepKey = targetNextStepKey;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    Step.StepKey getTargetNextStepKey() {
        return this.targetNextStepKey;
    }

    @Override
    public Tuple<String, Step.StepKey> indexForAsyncInvocation() {
        assert (this.calculatedTargetIndexName.get() != null) : "attempted to retrieve the index for async invocation before it was set";
        return new Tuple<String, Step.StepKey>(this.calculatedTargetIndexName.get(), this.targetNextStepKey);
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return clusterState;
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String targetIndexName = this.targetIndexNameSupplier.apply(index.getName(), lifecycleState);
        this.calculatedTargetIndexName.set(targetIndexName);
        IndexMetadata targetIndexMetadata = clusterState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            logger.warn("[{}] index [{}] unable to copy execution state to target index [{}] as target index does not exist", (Object)this.getKey().action(), (Object)index.getName(), (Object)targetIndexName);
            throw new IllegalStateException("unable to copy execution state from [" + index.getName() + "] to [" + targetIndexName + "] as target index does not exist");
        }
        String phase = this.targetNextStepKey.phase();
        String action = this.targetNextStepKey.action();
        String step = this.targetNextStepKey.name();
        LifecycleExecutionState.Builder newLifecycleState = LifecycleExecutionState.builder(lifecycleState);
        newLifecycleState.setPhase(phase);
        newLifecycleState.setAction(action);
        newLifecycleState.setStep(step);
        IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(targetIndexMetadata).version(targetIndexMetadata.getVersion() + 1L).putCustom("ilm", newLifecycleState.build().asMap());
        if (targetIndexMetadata.getSettings().hasValue("index.lifecycle.skip")) {
            Settings.Builder newSettings = Settings.builder().put(targetIndexMetadata.getSettings());
            newSettings.remove("index.lifecycle.skip");
            indexMetadataBuilder.settingsVersion(targetIndexMetadata.getSettingsVersion() + 1L).settings(newSettings);
        }
        return ClusterState.builder(clusterState).metadata(Metadata.builder(clusterState.metadata()).put(indexMetadataBuilder.build(), false)).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyExecutionStateStep that = (CopyExecutionStateStep)o;
        return super.equals(o) && Objects.equals(this.targetIndexNameSupplier, that.targetIndexNameSupplier) && Objects.equals(this.targetNextStepKey, that.targetNextStepKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexNameSupplier, this.targetNextStepKey);
    }
}

