/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public abstract class AsyncRetryDuringSnapshotActionStep
extends AsyncActionStep {
    private static final Logger logger = LogManager.getLogger(AsyncRetryDuringSnapshotActionStep.class);

    public AsyncRetryDuringSnapshotActionStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public final void performAction(IndexMetadata indexMetadata, ClusterState currentClusterState, ClusterStateObserver observer, ActionListener<Void> listener) {
        SnapshotExceptionListener snapshotExceptionListener = new SnapshotExceptionListener(indexMetadata.getIndex(), listener, observer, currentClusterState.nodes().getLocalNode());
        this.performDuringNoSnapshot(indexMetadata, currentClusterState, snapshotExceptionListener);
    }

    abstract void performDuringNoSnapshot(IndexMetadata var1, ClusterState var2, ActionListener<Void> var3);

    class SnapshotExceptionListener
    implements ActionListener<Void> {
        private final Index index;
        private final ActionListener<Void> originalListener;
        private final ClusterStateObserver observer;
        private final DiscoveryNode localNode;

        SnapshotExceptionListener(Index index, ActionListener<Void> originalListener, ClusterStateObserver observer, DiscoveryNode localNode) {
            this.index = index;
            this.originalListener = originalListener;
            this.observer = observer;
            this.localNode = localNode;
        }

        @Override
        public void onResponse(Void unused) {
            this.originalListener.onResponse(null);
        }

        @Override
        public void onFailure(Exception e) {
            if (e instanceof SnapshotInProgressException) {
                try {
                    logger.debug("[{}] attempted to run ILM step but a snapshot is in progress, step will retry at a later time", (Object)this.index.getName());
                    final String indexName = this.index.getName();
                    this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                        @Override
                        public void onNewClusterState(ClusterState state) {
                            if (!state.nodes().isLocalNodeElectedMaster()) {
                                SnapshotExceptionListener.this.originalListener.onFailure(new NotMasterException("no longer master"));
                                return;
                            }
                            try {
                                logger.debug("[{}] retrying ILM step after snapshot has completed", (Object)indexName);
                                IndexMetadata idxMeta = state.metadata().index(SnapshotExceptionListener.this.index);
                                if (idxMeta == null) {
                                    SnapshotExceptionListener.this.originalListener.onResponse(null);
                                } else {
                                    AsyncRetryDuringSnapshotActionStep.this.performAction(idxMeta, state, SnapshotExceptionListener.this.observer, SnapshotExceptionListener.this.originalListener);
                                }
                            }
                            catch (Exception e) {
                                SnapshotExceptionListener.this.originalListener.onFailure(e);
                            }
                        }

                        @Override
                        public void onClusterServiceClose() {
                            SnapshotExceptionListener.this.originalListener.onFailure(new NodeClosedException(SnapshotExceptionListener.this.localNode));
                        }

                        @Override
                        public void onTimeout(TimeValue timeout) {
                            SnapshotExceptionListener.this.originalListener.onFailure(new IllegalStateException("step timed out while waiting for snapshots to complete"));
                        }
                    }, state -> {
                        if (!state.nodes().isLocalNodeElectedMaster()) {
                            return true;
                        }
                        if (state.metadata().index(this.index) == null) {
                            return true;
                        }
                        for (List<SnapshotsInProgress.Entry> snapshots : SnapshotsInProgress.get(state).entriesByRepo()) {
                            for (SnapshotsInProgress.Entry snapshot : snapshots) {
                                if (!snapshot.indices().containsKey(indexName)) continue;
                                return false;
                            }
                        }
                        return true;
                    }, TimeValue.MAX_VALUE);
                }
                catch (Exception secondError) {
                    secondError.addSuppressed(e);
                    assert (false) : new AssertionError("This should never fail", secondError);
                    this.originalListener.onFailure(secondError);
                }
            } else {
                this.originalListener.onFailure(e);
            }
        }
    }
}

