/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DownsampleAfterBulkInfo(long currentTimeMillis, long executionId, long lastIngestTookInMillis, long lastTookInMillis, boolean hasFailures, int restStatusCode) implements NamedWriteable,
ToXContentObject
{
    public static final String NAME = "rollup_after_bulk_info";
    private static final ParseField CURRENT_TIME_IN_MILLIS = new ParseField("current_time_in_millis", new String[0]);
    private static final ParseField EXECUTION_ID = new ParseField("execution_id", new String[0]);
    private static final ParseField LAST_INGEST_TOOK_IN_MILLIS = new ParseField("last_ingest_took_in_millis", new String[0]);
    private static final ParseField LAST_TOOK_IN_MILLIS = new ParseField("last_took_in_millis", new String[0]);
    private static final ParseField HAS_FAILURES = new ParseField("has_failures", new String[0]);
    private static final ParseField REST_STATUS_CODE = new ParseField("rest_status_code", new String[0]);
    private static final ConstructingObjectParser<DownsampleAfterBulkInfo, Void> PARSER = new ConstructingObjectParser("rollup_after_bulk_info", args -> new DownsampleAfterBulkInfo((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Boolean)args[4], (Integer)args[5]));

    public DownsampleAfterBulkInfo(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readBoolean(), in.readVInt());
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.currentTimeMillis);
        out.writeVLong(this.executionId);
        out.writeVLong(this.lastIngestTookInMillis);
        out.writeVLong(this.lastTookInMillis);
        out.writeBoolean(this.hasFailures);
        out.writeVInt(this.restStatusCode);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(CURRENT_TIME_IN_MILLIS.getPreferredName(), this.currentTimeMillis);
        builder.field(EXECUTION_ID.getPreferredName(), this.executionId);
        builder.field(LAST_INGEST_TOOK_IN_MILLIS.getPreferredName(), this.lastIngestTookInMillis);
        builder.field(LAST_TOOK_IN_MILLIS.getPreferredName(), this.lastTookInMillis);
        builder.field(HAS_FAILURES.getPreferredName(), this.hasFailures);
        builder.field(REST_STATUS_CODE.getPreferredName(), this.restStatusCode);
        return builder.endObject();
    }

    public static DownsampleAfterBulkInfo fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CURRENT_TIME_IN_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), EXECUTION_ID);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_INGEST_TOOK_IN_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_TOOK_IN_MILLIS);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), HAS_FAILURES);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), REST_STATUS_CODE);
    }
}

