/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;

public class PutAutoFollowPatternAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "cluster:admin/xpack/ccr/auto_follow_pattern/put";
    public static final PutAutoFollowPatternAction INSTANCE = new PutAutoFollowPatternAction();
    private static final int MAX_NAME_BYTES = 255;

    private PutAutoFollowPatternAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private static final ObjectParser<PutAutoFollowPatternParameters, Void> PARSER = new ObjectParser("put_auto_follow_pattern_request", PutAutoFollowPatternParameters::new);
        private String name;
        private String remoteCluster;
        private List<String> leaderIndexPatterns;
        private String followIndexNamePattern;
        private Settings settings = Settings.EMPTY;
        private FollowParameters parameters = new FollowParameters();
        private List<String> leaderIndexExclusionPatterns = Collections.emptyList();

        public static Request fromXContent(TimeValue masterNodeTimeout, TimeValue ackTimeout, XContentParser parser, String name) throws IOException {
            PutAutoFollowPatternParameters parameters = PARSER.parse(parser, null);
            Request request = new Request(masterNodeTimeout, ackTimeout);
            request.setName(name);
            request.setRemoteCluster(parameters.remoteCluster);
            request.setLeaderIndexPatterns(parameters.leaderIndexPatterns);
            request.setFollowIndexNamePattern(parameters.followIndexNamePattern);
            if (parameters.leaderIndexExclusionPatterns != null) {
                request.setLeaderIndexExclusionPatterns(parameters.leaderIndexExclusionPatterns);
            }
            request.setSettings(parameters.settings);
            request.setParameters(parameters);
            return request;
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout) {
            super(masterNodeTimeout, ackTimeout);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = this.parameters.validate();
            if (this.name == null) {
                validationException = ValidateActions.addValidationError("[name] is missing", validationException);
            }
            if (this.name != null) {
                int byteCount;
                if (this.name.contains(",")) {
                    validationException = ValidateActions.addValidationError("[name] name must not contain a ','", validationException);
                }
                if (this.name.startsWith("_")) {
                    validationException = ValidateActions.addValidationError("[name] name must not start with '_'", validationException);
                }
                if ((byteCount = this.name.getBytes(StandardCharsets.UTF_8).length) > 255) {
                    validationException = ValidateActions.addValidationError("[name] name is too long (" + byteCount + " > 255)", validationException);
                }
            }
            if (this.remoteCluster == null) {
                validationException = ValidateActions.addValidationError("[" + AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD.getPreferredName() + "] is missing", validationException);
            }
            if (this.leaderIndexPatterns == null || this.leaderIndexPatterns.isEmpty()) {
                validationException = ValidateActions.addValidationError("[" + AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD.getPreferredName() + "] is missing", validationException);
            }
            return validationException;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public void setRemoteCluster(String remoteCluster) {
            this.remoteCluster = remoteCluster;
        }

        public List<String> getLeaderIndexPatterns() {
            return this.leaderIndexPatterns;
        }

        public void setLeaderIndexPatterns(List<String> leaderIndexPatterns) {
            this.leaderIndexPatterns = leaderIndexPatterns;
        }

        public List<String> getLeaderIndexExclusionPatterns() {
            return this.leaderIndexExclusionPatterns;
        }

        public void setLeaderIndexExclusionPatterns(List<String> leaderIndexExclusionPatterns) {
            this.leaderIndexExclusionPatterns = leaderIndexExclusionPatterns;
        }

        public String getFollowIndexNamePattern() {
            return this.followIndexNamePattern;
        }

        public void setFollowIndexNamePattern(String followIndexNamePattern) {
            this.followIndexNamePattern = followIndexNamePattern;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void setSettings(Settings settings) {
            this.settings = Objects.requireNonNull(settings);
        }

        public FollowParameters getParameters() {
            return this.parameters;
        }

        public void setParameters(FollowParameters parameters) {
            this.parameters = parameters;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.remoteCluster = in.readString();
            this.leaderIndexPatterns = in.readStringCollectionAsList();
            this.followIndexNamePattern = in.readOptionalString();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_9_0)) {
                this.settings = Settings.readSettingsFromStream(in);
            }
            this.parameters = new FollowParameters(in);
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_14_0)) {
                this.leaderIndexExclusionPatterns = in.readStringCollectionAsList();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeString(this.remoteCluster);
            out.writeStringCollection(this.leaderIndexPatterns);
            out.writeOptionalString(this.followIndexNamePattern);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_9_0)) {
                this.settings.writeTo(out);
            }
            this.parameters.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_14_0)) {
                out.writeStringCollection(this.leaderIndexExclusionPatterns);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.field(AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD.getPreferredName(), (Collection<String>)this.leaderIndexPatterns);
            builder.field(AutoFollowMetadata.AutoFollowPattern.LEADER_EXCLUSION_PATTERNS_FIELD.getPreferredName(), (Collection<String>)this.leaderIndexExclusionPatterns);
            if (this.followIndexNamePattern != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.FOLLOW_PATTERN_FIELD.getPreferredName(), this.followIndexNamePattern);
            }
            if (!this.settings.isEmpty()) {
                builder.startObject(AutoFollowMetadata.AutoFollowPattern.SETTINGS_FIELD.getPreferredName());
                this.settings.toXContent(builder, params);
                builder.endObject();
            }
            this.parameters.toXContentFragment(builder);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.name, request.name) && Objects.equals(this.remoteCluster, request.remoteCluster) && Objects.equals(this.leaderIndexPatterns, request.leaderIndexPatterns) && Objects.equals(this.leaderIndexExclusionPatterns, request.leaderIndexExclusionPatterns) && Objects.equals(this.followIndexNamePattern, request.followIndexNamePattern) && Objects.equals(this.parameters, request.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.remoteCluster, this.leaderIndexPatterns, this.leaderIndexExclusionPatterns, this.followIndexNamePattern, this.parameters);
        }

        static {
            PARSER.declareString((params, value) -> {
                params.remoteCluster = value;
            }, AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD);
            PARSER.declareStringArray((params, value) -> {
                params.leaderIndexPatterns = value;
            }, AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD);
            PARSER.declareString((params, value) -> {
                params.followIndexNamePattern = value;
            }, AutoFollowMetadata.AutoFollowPattern.FOLLOW_PATTERN_FIELD);
            PARSER.declareObject((params, value) -> {
                params.settings = value;
            }, (p, c) -> Settings.fromXContent(p), AutoFollowMetadata.AutoFollowPattern.SETTINGS_FIELD);
            PARSER.declareStringArray((params, value) -> {
                params.leaderIndexExclusionPatterns = value;
            }, AutoFollowMetadata.AutoFollowPattern.LEADER_EXCLUSION_PATTERNS_FIELD);
            FollowParameters.initParser(PARSER);
        }

        private static class PutAutoFollowPatternParameters
        extends FollowParameters {
            private String remoteCluster;
            private List<String> leaderIndexPatterns;
            private String followIndexNamePattern;
            private Settings settings = Settings.EMPTY;
            private List<String> leaderIndexExclusionPatterns;

            private PutAutoFollowPatternParameters() {
            }
        }
    }
}

