/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.mapper.IdLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.search.RescoreDocIds;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.transport.LeakTracker;

public abstract class SearchContext
implements Releasable {
    public static final int DEFAULT_TERMINATE_AFTER = 0;
    public static final int TRACK_TOTAL_HITS_ACCURATE = Integer.MAX_VALUE;
    public static final int TRACK_TOTAL_HITS_DISABLED = -1;
    public static final int DEFAULT_TRACK_TOTAL_HITS_UP_TO = 10000;
    protected final List<Releasable> releasables = new CopyOnWriteArrayList<Releasable>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InnerHitsContext innerHitsContext;
    private Query rewriteQuery;

    protected SearchContext() {
        if (Assertions.ENABLED) {
            this.releasables.add(LeakTracker.wrap(() -> {
                assert (this.closed.get());
            }));
        }
    }

    public final List<Runnable> getCancellationChecks() {
        Runnable timeoutRunnable = QueryPhase.getTimeoutCheck(this);
        if (this.lowLevelCancellation()) {
            Runnable c = () -> {
                CancellableTask task = this.getTask();
                if (task != null) {
                    task.ensureNotCancelled();
                }
            };
            return timeoutRunnable == null ? List.of(c) : List.of(c, timeoutRunnable);
        }
        return timeoutRunnable == null ? List.of() : List.of(timeoutRunnable);
    }

    public abstract void setTask(CancellableTask var1);

    public abstract CancellableTask getTask();

    public abstract boolean isCancelled();

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            Releasables.close(this.releasables);
        }
    }

    public abstract void preProcess();

    public abstract Query buildFilteredQuery(Query var1);

    public abstract ShardSearchContextId id();

    public abstract String source();

    public abstract ShardSearchRequest request();

    public abstract SearchType searchType();

    public abstract SearchShardTarget shardTarget();

    public abstract int numberOfShards();

    public abstract ScrollContext scrollContext();

    public abstract SearchContextAggregations aggregations();

    public abstract SearchContext aggregations(SearchContextAggregations var1);

    public abstract SearchExtBuilder getSearchExt(String var1);

    public abstract SearchHighlightContext highlight();

    public abstract void highlight(SearchHighlightContext var1);

    public InnerHitsContext innerHits() {
        if (this.innerHitsContext == null) {
            this.innerHitsContext = new InnerHitsContext();
        }
        return this.innerHitsContext;
    }

    public abstract SuggestionSearchContext suggest();

    public abstract QueryPhaseRankShardContext queryPhaseRankShardContext();

    public abstract void queryPhaseRankShardContext(QueryPhaseRankShardContext var1);

    public abstract List<RescoreContext> rescore();

    public abstract void addRescore(RescoreContext var1);

    public final RescoreDocIds rescoreDocIds() {
        List<RescoreContext> rescore = this.rescore();
        if (rescore == null) {
            return RescoreDocIds.EMPTY;
        }
        HashMap<Integer, Set<Integer>> rescoreDocIds = null;
        for (int i = 0; i < rescore.size(); ++i) {
            Set<Integer> docIds = rescore.get(i).getRescoredDocs();
            if (docIds == null || docIds.isEmpty()) continue;
            if (rescoreDocIds == null) {
                rescoreDocIds = new HashMap<Integer, Set<Integer>>();
            }
            rescoreDocIds.put(i, docIds);
        }
        return rescoreDocIds == null ? RescoreDocIds.EMPTY : new RescoreDocIds(rescoreDocIds);
    }

    public final void assignRescoreDocIds(RescoreDocIds rescoreDocIds) {
        List<RescoreContext> rescore = this.rescore();
        if (rescore != null) {
            for (int i = 0; i < rescore.size(); ++i) {
                Set<Integer> docIds = rescoreDocIds.getId(i);
                if (docIds == null) continue;
                rescore.get(i).setRescoredDocs(docIds);
            }
        }
    }

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean sourceRequested();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract FetchDocValuesContext docValuesContext();

    public abstract SearchContext docValuesContext(FetchDocValuesContext var1);

    public abstract FetchFieldsContext fetchFieldsContext();

    public abstract SearchContext fetchFieldsContext(FetchFieldsContext var1);

    public abstract ContextIndexSearcher searcher();

    public abstract IndexShard indexShard();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract TimeValue timeout();

    public abstract int terminateAfter();

    public abstract void terminateAfter(int var1);

    public abstract boolean lowLevelCancellation();

    public abstract SearchContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract SearchContext sort(SortAndFormats var1);

    public abstract SortAndFormats sort();

    public abstract SearchContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchContext trackTotalHitsUpTo(int var1);

    public abstract int trackTotalHitsUpTo();

    public abstract SearchContext searchAfter(FieldDoc var1);

    public abstract FieldDoc searchAfter();

    public abstract CollapseContext collapse();

    public abstract SearchContext parsedPostFilter(ParsedQuery var1);

    public abstract ParsedQuery parsedPostFilter();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract Query query();

    public Query rewrittenQuery() {
        if (this.query() == null) {
            throw new IllegalStateException("preProcess must be called first");
        }
        if (this.rewriteQuery == null) {
            try {
                this.rewriteQuery = this.searcher().rewrite(this.query());
            }
            catch (IOException exc) {
                throw new QueryShardException((QueryRewriteContext)this.getSearchExecutionContext(), "rewrite failed", (Throwable)exc, new Object[0]);
            }
        }
        return this.rewriteQuery;
    }

    public abstract int from();

    public abstract SearchContext from(int var1);

    public abstract int size();

    public abstract SearchContext size(int var1);

    public abstract boolean hasStoredFields();

    public abstract StoredFieldsContext storedFieldsContext();

    public abstract SearchContext storedFieldsContext(StoredFieldsContext var1);

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    @Nullable
    public abstract List<String> groupStats();

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract boolean seqNoAndPrimaryTerm();

    public abstract void seqNoAndPrimaryTerm(boolean var1);

    public abstract DfsSearchResult dfsResult();

    public abstract void addDfsResult();

    public abstract QuerySearchResult queryResult();

    public abstract void addQueryResult();

    public abstract TotalHits getTotalHits();

    public abstract float getMaxScore();

    public abstract void addRankFeatureResult();

    public abstract RankFeatureResult rankFeatureResult();

    public abstract FetchPhase fetchPhase();

    public abstract FetchSearchResult fetchResult();

    public abstract void addFetchResult();

    public abstract Profilers getProfilers();

    public void addReleasable(Releasable releasable) {
        assert (!this.closed.get());
        this.releasables.add(releasable);
    }

    public final boolean hasOnlySuggest() {
        return this.request().source() != null && this.request().source().isSuggestOnly();
    }

    public abstract long getRelativeTimeInMillis();

    public abstract SearchExecutionContext getSearchExecutionContext();

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.shardTarget());
        if (this.searchType() != SearchType.DEFAULT) {
            result.append("searchType=[").append((Object)this.searchType()).append("]");
        }
        if (this.scrollContext() != null) {
            if (this.scrollContext().scroll != null) {
                result.append("scroll=[").append(this.scrollContext().scroll.keepAlive()).append("]");
            } else {
                result.append("scroll=[null]");
            }
        }
        result.append(" query=[").append(this.query()).append("]");
        return result.toString();
    }

    public abstract ReaderContext readerContext();

    public abstract SourceLoader newSourceLoader(@Nullable SourceFilter var1);

    public abstract IdLoader newIdLoader();
}

