/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.MemoryTrackingTDigestArrays;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.TDigest;
import org.elasticsearch.tdigest.arrays.TDigestArrays;

public class TDigestState
implements Releasable,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TDigestState.class);
    private static final CircuitBreaker DEFAULT_NOOP_BREAKER = new NoopCircuitBreaker("default-tdigest-state-noop-breaker");
    private final CircuitBreaker breaker;
    private boolean closed = false;
    private final double compression;
    private final TDigest tdigest;
    private final Type type;

    @Deprecated
    public static TDigestState createWithoutCircuitBreaking(double compression) {
        return TDigestState.create(DEFAULT_NOOP_BREAKER, compression);
    }

    public static TDigestState create(CircuitBreaker breaker, double compression) {
        breaker.addEstimateBytesAndMaybeBreak(SHALLOW_SIZE, "tdigest-state-create");
        try {
            return new TDigestState(breaker, Type.defaultValue(), compression);
        }
        catch (Exception e) {
            breaker.addWithoutBreaking(-SHALLOW_SIZE);
            throw e;
        }
    }

    static TDigestState create(CircuitBreaker breaker, Type type, double compression) {
        breaker.addEstimateBytesAndMaybeBreak(SHALLOW_SIZE, "tdigest-state-create-with-type");
        try {
            return new TDigestState(breaker, type, compression);
        }
        catch (Exception e) {
            breaker.addWithoutBreaking(-SHALLOW_SIZE);
            throw e;
        }
    }

    static TDigestState createOptimizedForAccuracy(CircuitBreaker breaker, double compression) {
        breaker.addEstimateBytesAndMaybeBreak(SHALLOW_SIZE, "tdigest-state-create-optimized-for-accuracy");
        try {
            return new TDigestState(breaker, Type.valueForHighAccuracy(), compression);
        }
        catch (Exception e) {
            breaker.addWithoutBreaking(-SHALLOW_SIZE);
            throw e;
        }
    }

    @Deprecated
    public static TDigestState createWithoutCircuitBreaking(double compression, TDigestExecutionHint executionHint) {
        return TDigestState.create(DEFAULT_NOOP_BREAKER, compression, executionHint);
    }

    public static TDigestState create(CircuitBreaker breaker, double compression, TDigestExecutionHint executionHint) {
        return switch (executionHint) {
            default -> throw new IncompatibleClassChangeError();
            case TDigestExecutionHint.HIGH_ACCURACY -> TDigestState.createOptimizedForAccuracy(breaker, compression);
            case TDigestExecutionHint.DEFAULT -> TDigestState.create(breaker, compression);
        };
    }

    public static TDigestState createUsingParamsFrom(TDigestState state) {
        state.breaker.addEstimateBytesAndMaybeBreak(SHALLOW_SIZE, "tdigest-state-create-using-params-from");
        try {
            return new TDigestState(state.breaker, state.type, state.compression);
        }
        catch (Exception e) {
            state.breaker.addWithoutBreaking(-SHALLOW_SIZE);
            throw e;
        }
    }

    protected TDigestState(CircuitBreaker breaker, Type type, double compression) {
        this.breaker = breaker;
        MemoryTrackingTDigestArrays arrays = new MemoryTrackingTDigestArrays(breaker);
        this.tdigest = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.HYBRID -> TDigest.createHybridDigest((TDigestArrays)arrays, (double)compression);
            case Type.AVL_TREE -> TDigest.createAvlTreeDigest((TDigestArrays)arrays, (double)compression);
            case Type.SORTING -> TDigest.createSortingDigest((TDigestArrays)arrays);
            case Type.MERGING -> TDigest.createMergingDigest((TDigestArrays)arrays, (double)compression);
        };
        this.type = type;
        this.compression = compression;
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.tdigest.ramBytesUsed();
    }

    public final double compression() {
        return this.compression;
    }

    public static void write(TDigestState state, StreamOutput out) throws IOException {
        out.writeDouble(state.compression);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeString(state.type.toString());
            out.writeVLong(state.tdigest.size());
        }
        out.writeVInt(state.centroidCount());
        for (Centroid centroid : state.centroids()) {
            out.writeDouble(centroid.mean());
            out.writeVLong(centroid.count());
        }
    }

    @Deprecated
    public static TDigestState read(StreamInput in) throws IOException {
        return TDigestState.read(DEFAULT_NOOP_BREAKER, in);
    }

    public static TDigestState read(CircuitBreaker breaker, StreamInput in) throws IOException {
        TDigestState state;
        double compression = in.readDouble();
        long size = 0L;
        breaker.addEstimateBytesAndMaybeBreak(SHALLOW_SIZE, "tdigest-state-read");
        try {
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                state = new TDigestState(breaker, Type.valueOf(in.readString()), compression);
                size = in.readVLong();
            } else {
                state = new TDigestState(breaker, Type.valueForHighAccuracy(), compression);
            }
        }
        catch (Exception e) {
            breaker.addWithoutBreaking(-SHALLOW_SIZE);
            throw e;
        }
        int n = in.readVInt();
        if (size > 0L) {
            state.tdigest.reserve(size);
        }
        for (int i = 0; i < n; ++i) {
            state.add(in.readDouble(), in.readVLong());
        }
        return state;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TDigestState)) {
            return false;
        }
        TDigestState that = (TDigestState)obj;
        if (this == that) {
            return true;
        }
        if (this.compression != that.compression) {
            return false;
        }
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        if (this.getMax() != that.getMax()) {
            return false;
        }
        if (this.getMin() != that.getMin()) {
            return false;
        }
        if (this.centroidCount() != that.centroidCount()) {
            return false;
        }
        Iterator<Centroid> thisCentroids = this.centroids().iterator();
        Iterator<Centroid> thatCentroids = that.centroids().iterator();
        while (thisCentroids.hasNext()) {
            if (!thatCentroids.hasNext()) {
                return false;
            }
            Centroid thisNext = thisCentroids.next();
            Centroid thatNext = thatCentroids.next();
            if (thisNext.mean() == thatNext.mean() && thisNext.count() == thatNext.count()) continue;
            return false;
        }
        return !thatCentroids.hasNext();
    }

    public int hashCode() {
        int h = 31 * Double.hashCode(this.compression) + this.type.hashCode();
        h = 31 * h + Integer.hashCode(this.centroidCount());
        for (Centroid centroid : this.centroids()) {
            h = 31 * h + Double.hashCode(centroid.mean());
            h = 31 * h + (int)centroid.count();
        }
        h = 31 * h + Double.hashCode(this.getMax());
        h = 31 * h + Double.hashCode(this.getMin());
        return h;
    }

    public void add(TDigestState other) {
        this.tdigest.add(other.tdigest);
    }

    public void add(double x, long w) {
        this.tdigest.add(x, w);
    }

    public void add(double x) {
        this.tdigest.add(x, 1L);
    }

    public final void compress() {
        this.tdigest.compress();
    }

    public final long size() {
        return this.tdigest.size();
    }

    public final double cdf(double x) {
        return this.tdigest.cdf(x);
    }

    public final double quantile(double q) {
        return this.tdigest.quantile(q);
    }

    public final Collection<Centroid> centroids() {
        return this.tdigest.centroids();
    }

    public final int centroidCount() {
        return this.tdigest.centroidCount();
    }

    public final double getMin() {
        return this.tdigest.getMin();
    }

    public final double getMax() {
        return this.tdigest.getMax();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.breaker.addWithoutBreaking(-SHALLOW_SIZE);
            Releasables.close((Releasable)this.tdigest);
        }
    }

    protected static enum Type {
        HYBRID,
        AVL_TREE,
        MERGING,
        SORTING;


        static Type defaultValue() {
            return HYBRID;
        }

        static Type valueForHighAccuracy() {
            return AVL_TREE;
        }
    }
}

